/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.test.junit;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.build.test.junit.JunitTestResultsParser;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class JunitTestReportCollector
implements TestReportCollector {
    private static final Logger log = Logger.getLogger(JunitTestReportCollector.class);
    private static final int JUNIT_RESULT_VALIDATOR_HEADER_NO_LINES_TO_CHECK = 50;
    private static final String JUNIT_RESULT_VALIDATOR_HEADER_DETECTION_WORD = "<testsuite";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        FileInputStream stream = new FileInputStream(file);
        try {
            JunitTestResultsParser parser = new JunitTestResultsParser();
            parser.parse(stream);
            TestCollectionResultBuilder builder = new TestCollectionResultBuilder().addSuccessfulTestResults(parser.getSuccessfulTests()).addFailedTestResults(parser.getFailedTests()).addSkippedTestResults(parser.getSkippedTests());
            TestCollectionResult testCollectionResult = builder.build();
            return testCollectionResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public boolean canIgnoreResultsFrom(File file) {
        return file.getName().toLowerCase().contains("testng") || !JunitTestReportCollector.isJunitResult(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJunitResult(File file) {
        try (Stream<String> lines = Files.lines(file.toPath());){
            boolean bl = lines.limit(50L).anyMatch(line -> line.toLowerCase().contains(JUNIT_RESULT_VALIDATOR_HEADER_DETECTION_WORD));
            return bl;
        }
        catch (IOException e) {
            log.info((Object)String.format("Could not check if file: %s is potentially a JUnit result. Assuming it is not.", file.getName()), (Throwable)e);
            return false;
        }
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"xml", "junit"});
    }
}

