/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.test.junit;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.configuration.DefaultContentHandler;
import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementContentElementParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.results.tests.TestResultsUtils;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JunitTestResultsParser
extends DefaultContentHandler {
    private static final Logger log = Logger.getLogger(JunitTestResultsParser.class);
    private static final String TESTNG_SUPERFLOUS_TEXT_START = "on instance";
    private String suiteClassName;
    private TestResults currentTestResult;
    private boolean isIgnoredTest = false;
    private Set<TestResults> failedTests;
    private Set<TestResults> passedTests;
    private Set<TestResults> skippedTests;

    public JunitTestResultsParser() {
        this.registerElementParser("testsuite", new TestSuiteElementParser());
        this.registerElementParser("testcase", new TestCaseElementParser(SystemProperty.JUNIT_PARSER_IGNORE_NAMED_INNER_CLASSES.getTypedValue()));
        this.registerElementParser("error", new ErrorElementParser());
        this.registerElementParser("failure", new FailureElementParser());
        this.registerElementParser("skipped", new SkippedElementParser());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.hasParserFor(localName)) {
            this.registerElementParser(localName, DefaultElementParser.getInstance());
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void parse(@NotNull InputStream inputStream) throws SAXException, IOException {
        this.parse(new InputStreamReader(inputStream));
    }

    public void parse(@NotNull Reader inputReader) throws SAXException, IOException {
        this.failedTests = new HashSet<TestResults>();
        this.passedTests = new HashSet<TestResults>();
        this.skippedTests = new HashSet<TestResults>();
        XMLReader reader = SecureXmlParserFactory.newNamespaceAwareXmlReader();
        reader.setContentHandler(this);
        reader.parse(new InputSource(BambooXmlUtils.sanitiseXml10Reader((Reader)inputReader)));
    }

    public boolean hasErrors() {
        return this.getNumberOfErrors() > 0;
    }

    public int getNumberOfErrors() {
        return this.failedTests.size();
    }

    public int getNumberOfTests() {
        return this.failedTests.size() + this.passedTests.size();
    }

    public Set<TestResults> getSuccessfulTests() {
        return this.passedTests != null ? this.passedTests : Collections.emptySet();
    }

    public Set<TestResults> getFailedTests() {
        return this.failedTests != null ? this.failedTests : Collections.emptySet();
    }

    public Set<TestResults> getSkippedTests() {
        return this.skippedTests != null ? this.skippedTests : Collections.emptySet();
    }

    class SkippedElementParser
    extends DefaultElementParser {
        SkippedElementParser() {
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.isIgnoredTest = true;
        }
    }

    class FailureElementParser
    extends ElementWithStacktraceContentParser {
        FailureElementParser() {
        }

        @Override
        void handleContent(String content) {
            JunitTestResultsParser.this.currentTestResult.addError((TestCaseResultError)new TestCaseResultErrorImpl(content));
        }
    }

    class ErrorElementParser
    extends ElementWithStacktraceContentParser {
        ErrorElementParser() {
        }

        @Override
        void handleContent(String content) {
            TestCaseResultErrorImpl error = new TestCaseResultErrorImpl(content);
            if (JunitTestResultsParser.this.currentTestResult != null) {
                JunitTestResultsParser.this.currentTestResult.addError((TestCaseResultError)error);
            } else {
                TestResults errorTestResult = new TestResults(JunitTestResultsParser.this.suiteClassName, "unknownTestCase", Long.valueOf(0L));
                errorTestResult.addError((TestCaseResultError)error);
                errorTestResult.setState(TestState.FAILED);
                JunitTestResultsParser.this.failedTests.add(errorTestResult);
            }
        }
    }

    abstract class ElementWithStacktraceContentParser
    extends ElementContentElementParser {
        private String message;
        private String type;

        ElementWithStacktraceContentParser() {
        }

        @Override
        public void startElement(Attributes attributes) {
            super.startElement(attributes);
            this.message = attributes.getValue("message");
            this.type = attributes.getValue("type");
        }

        @Override
        public void endElement() throws ConfigurationException {
            String content = this.getElementContent();
            if (this.message != null) {
                StringBuilder sb = new StringBuilder();
                if (this.type != null) {
                    sb.append(this.type);
                    sb.append(": ");
                }
                sb.append(this.message);
                sb.append('\n');
                String messageLine = sb.toString();
                if (!content.startsWith(messageLine)) {
                    sb.append(content);
                    content = sb.toString();
                }
            }
            this.handleContent(content);
            this.message = null;
            this.type = null;
        }

        abstract void handleContent(String var1);
    }

    class TestCaseElementParser
    extends DefaultElementParser {
        private final boolean ignoreNamedInnerClass;

        TestCaseElementParser(boolean ignoreNamedInnerClass) {
            this.ignoreNamedInnerClass = ignoreNamedInnerClass;
        }

        @Override
        public void startElement(Attributes attributes) {
            String className;
            String testName = attributes.getValue("name");
            String testDuration = attributes.getValue("time");
            if (testName.contains(JunitTestResultsParser.TESTNG_SUPERFLOUS_TEXT_START)) {
                testName = testName.substring(0, testName.indexOf(JunitTestResultsParser.TESTNG_SUPERFLOUS_TEXT_START)).trim();
            }
            if ((className = attributes.getValue("classname")) == null) {
                className = JunitTestResultsParser.this.suiteClassName;
            } else if (className.contains("$") && this.ignoreNamedInnerClass) {
                className = JunitTestResultsParser.this.suiteClassName;
            } else if (this.isInnerClassAnonymous(className)) {
                className = JunitTestResultsParser.this.suiteClassName;
            }
            JunitTestResultsParser.this.currentTestResult = new TestResults(className, testName, TestResultsUtils.toMilliseconds(testDuration));
        }

        private boolean isInnerClassAnonymous(String className) {
            return NumberUtils.isNumber((String)StringUtils.substringAfterLast((String)className, (String)"$"));
        }

        @Override
        public void endElement() {
            if (JunitTestResultsParser.this.isIgnoredTest) {
                JunitTestResultsParser.this.currentTestResult.setState(TestState.SKIPPED);
                JunitTestResultsParser.this.skippedTests.add(JunitTestResultsParser.this.currentTestResult);
                JunitTestResultsParser.this.isIgnoredTest = false;
            } else if (JunitTestResultsParser.this.currentTestResult.hasErrors()) {
                JunitTestResultsParser.this.currentTestResult.setState(TestState.FAILED);
                JunitTestResultsParser.this.failedTests.add(JunitTestResultsParser.this.currentTestResult);
            } else {
                JunitTestResultsParser.this.currentTestResult.setState(TestState.SUCCESS);
                JunitTestResultsParser.this.passedTests.add(JunitTestResultsParser.this.currentTestResult);
            }
            JunitTestResultsParser.this.currentTestResult = null;
        }
    }

    class TestSuiteElementParser
    extends DefaultElementParser {
        TestSuiteElementParser() {
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.suiteClassName = attributes.getValue("name");
        }
    }
}

