/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.jetbrains.annotations.NotNull;

public class BuildWarning {
    private final PlanResultKey chainResultKey;
    private final Map<String, String> artifactHandlerConfiguration;
    private final Collection<Artifact> artifacts;
    private final Map<Long, RepositoryNotificationInfo> repositoryNotificationInfo;
    private final boolean rebuild;

    public BuildWarning(@NotNull PlanResultKey chainResultKey, boolean rebuild, @NotNull Collection<BuildWarningSummary> chainWarningSummaries, @NotNull Collection<RepositoryChangeset> affectedChangesets, @NotNull Map<String, String> artifactHandlerConfiguration, @NotNull Collection<Artifact> artifacts) {
        this.chainResultKey = chainResultKey;
        this.rebuild = rebuild;
        this.artifactHandlerConfiguration = artifactHandlerConfiguration;
        this.artifacts = artifacts;
        this.repositoryNotificationInfo = this.prepareRepositoryNotificationInfo(chainWarningSummaries, affectedChangesets);
    }

    public PlanResultKey getChainResultKey() {
        return this.chainResultKey;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public Map<String, String> getArtifactHandlerConfiguration() {
        return this.artifactHandlerConfiguration;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public RepositoryNotificationInfo getRepositoryNotificationInfo(Long repositoryId) {
        return this.repositoryNotificationInfo.get(repositoryId);
    }

    private Map<Long, RepositoryNotificationInfo> prepareRepositoryNotificationInfo(@NotNull Collection<BuildWarningSummary> chainWarningSummaries, @NotNull Collection<RepositoryChangeset> affectedChangesets) {
        Map summariesByRepository = chainWarningSummaries.stream().collect(Collectors.toMap(BuildWarningSummary::getRepositoryId, Function.identity()));
        HashSetValuedHashMap changeSetsByRepository = new HashSetValuedHashMap();
        affectedChangesets.forEach(arg_0 -> BuildWarning.lambda$prepareRepositoryNotificationInfo$0((MultiValuedMap)changeSetsByRepository, arg_0));
        HashMap<Long, RepositoryNotificationInfo> result = new HashMap<Long, RepositoryNotificationInfo>();
        summariesByRepository.forEach((arg_0, arg_1) -> BuildWarning.lambda$prepareRepositoryNotificationInfo$1(result, (MultiValuedMap)changeSetsByRepository, arg_0, arg_1));
        return result;
    }

    public Collection<Long> getRepositoryIds() {
        return new HashSet<Long>(this.repositoryNotificationInfo.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildWarning that = (BuildWarning)o;
        return Objects.equals(this.chainResultKey, that.chainResultKey);
    }

    public int hashCode() {
        return Objects.hash(this.chainResultKey);
    }

    public String toString() {
        return new StringJoiner(", ", BuildWarning.class.getSimpleName() + "[", "]").add("chainResultKey=" + this.chainResultKey).add("repositoryNotificationInfo=" + this.repositoryNotificationInfo).toString();
    }

    private static /* synthetic */ void lambda$prepareRepositoryNotificationInfo$1(Map result, MultiValuedMap changeSetsByRepository, Long key, BuildWarningSummary value) {
        result.put(key, new RepositoryNotificationInfo(value, changeSetsByRepository.get((Object)key)));
    }

    private static /* synthetic */ void lambda$prepareRepositoryNotificationInfo$0(MultiValuedMap changeSetsByRepository, RepositoryChangeset affectedChangeset) {
        changeSetsByRepository.put((Object)affectedChangeset.repositoryId, (Object)affectedChangeset.changesetId);
    }

    public static class RepositoryNotificationInfo {
        private final BuildWarningSummary summary;
        private final Collection<String> changeSets;

        public RepositoryNotificationInfo(BuildWarningSummary summary, Collection<String> changeSets) {
            this.summary = summary;
            this.changeSets = changeSets;
        }

        public BuildWarningSummary getSummary() {
            return this.summary;
        }

        public Collection<String> getChangeSets() {
            return this.changeSets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryNotificationInfo that = (RepositoryNotificationInfo)o;
            return Objects.equals(this.summary, that.summary) && Objects.equals(this.changeSets, that.changeSets);
        }

        public int hashCode() {
            return Objects.hash(this.summary, this.changeSets);
        }

        public String toString() {
            return new StringJoiner(", ", RepositoryNotificationInfo.class.getSimpleName() + "[", "]").add("summary=" + this.summary).add("changeSets=" + this.changeSets).toString();
        }
    }

    public static class RepositoryChangeset {
        private final long repositoryId;
        private final String changesetId;

        public RepositoryChangeset(long repositoryId, @NotNull String changesetId) {
            this.repositoryId = repositoryId;
            this.changesetId = changesetId;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public String getChangesetId() {
            return this.changesetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryChangeset that = (RepositoryChangeset)o;
            return this.repositoryId == that.repositoryId && Objects.equals(this.changesetId, that.changesetId);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryId, this.changesetId);
        }

        public String toString() {
            return new StringJoiner(", ", RepositoryChangeset.class.getSimpleName() + "[", "]").add("repositoryId=" + this.repositoryId).add("changesetId='" + this.changesetId + "'").toString();
        }
    }

    public static class Artifact {
        private final PlanResultKey jobResultKey;
        private final ArtifactDefinitionContext artifactDefinitionContext;

        public Artifact(PlanResultKey jobResultKey, String artifactLabel) {
            this.jobResultKey = jobResultKey;
            this.artifactDefinitionContext = new ArtifactDefinitionContextImpl(artifactLabel, true, null);
            this.artifactDefinitionContext.setCopyPattern("*.zip");
        }

        public PlanResultKey getJobResultKey() {
            return this.jobResultKey;
        }

        public ArtifactDefinitionContext getArtifactDefinitionContext() {
            return this.artifactDefinitionContext;
        }
    }
}

