/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.build.warning.WarningAnnotation;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

class BuildWarningQueue {
    private final int oneKeyMaxValueCount;
    private final int wholeMapMaxValues;
    private final BiConsumer<Long, Collection<WarningAnnotation>> flusher;
    private final Map<Long, Collection<WarningAnnotation>> map;
    private int currentWholeMapSize = 0;

    BuildWarningQueue(int oneKeyMaxValueCount, int wholeMapMaxValues, BiConsumer<Long, Collection<WarningAnnotation>> flusher) {
        this.oneKeyMaxValueCount = oneKeyMaxValueCount;
        this.wholeMapMaxValues = wholeMapMaxValues;
        this.flusher = flusher;
        this.map = new HashMap<Long, Collection<WarningAnnotation>>();
    }

    void add(Long key, WarningAnnotation value) {
        Collection values = this.map.computeIfAbsent(key, k -> new ArrayList());
        values.add(value);
        ++this.currentWholeMapSize;
        this.handleNewMapSize(values.size(), key);
    }

    private void handleNewMapSize(Integer oneKeyCapacity, Long key) {
        if (oneKeyCapacity >= this.oneKeyMaxValueCount) {
            this.flush(key);
        } else if (this.currentWholeMapSize >= this.wholeMapMaxValues) {
            Long mostNumerousKey = this.getMostNumerousKey();
            this.flush(mostNumerousKey);
        }
    }

    private Long getMostNumerousKey() {
        return (Long)this.map.entrySet().stream().max(Comparator.comparingInt(e -> ((Collection)e.getValue()).size())).get().getKey();
    }

    private int flush(Long key) {
        Collection<WarningAnnotation> oneKeyValues = this.map.remove(key);
        this.flusher.accept(key, oneKeyValues);
        return this.decreaseMapSizeAndReturnCollectionSize(oneKeyValues);
    }

    int flushAll() {
        AtomicInteger flushedCount = new AtomicInteger(0);
        Iterator<Long> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Long key = iterator.next();
            Collection<WarningAnnotation> values = this.map.get(key);
            this.flusher.accept(key, values);
            flushedCount.addAndGet(this.decreaseMapSizeAndReturnCollectionSize(values));
            iterator.remove();
        }
        return flushedCount.get();
    }

    @VisibleForTesting
    int getCurrentWholeMapSize() {
        return this.currentWholeMapSize;
    }

    private int decreaseMapSizeAndReturnCollectionSize(Collection<WarningAnnotation> collection) {
        int keyValuesSize = collection.size();
        this.currentWholeMapSize -= keyValuesSize;
        return keyValuesSize;
    }
}

