/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.warning.BuildWarning;
import com.atlassian.bamboo.build.warning.BuildWarningSenderWorker;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

class BuildWarningSenderService {
    private static final Logger log = Logger.getLogger(BuildWarningSenderService.class);
    private static final int MAX_QUEUE_SIZE = (int)SystemProperty.BUILD_WARNINGS_QUEUE_MAX_SIZE.getTypedValue();
    private static final int THREAD_POOL_SIZE = (int)SystemProperty.BUILD_WARNINGS_THREAD_COUNT.getTypedValue();
    private final ThreadFactory threadFactory = new CustomizableThreadFactory("WarningsSender-");
    private final Executor executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE, this.threadFactory);
    private BlockingQueue<BuildWarning> queueToSend;
    @Inject
    private ArtifactLinkDao artifactLinkDao;
    @Inject
    private ArtifactManager artifactManager;
    @Inject
    private CustomVariableContext customVariableContext;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;

    BuildWarningSenderService() {
    }

    @PostConstruct
    private void init() {
        this.queueToSend = new LinkedBlockingQueue<BuildWarning>();
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            this.executor.execute(new BuildWarningSenderWorker(this.queueToSend, this.artifactManager, this.customVariableContext, this.artifactLinkDao, this.repositoryDefinitionManager, this.resultsSummaryManager, this.vcsRepositoryManager));
        }
    }

    boolean enqueue(@NotNull BuildWarning buildWarning) {
        int queueSize = this.queueToSend.size();
        if (queueSize > MAX_QUEUE_SIZE) {
            log.warn((Object)String.format("Queue size [%s] is over safe limit of [%s]", queueSize, MAX_QUEUE_SIZE));
            return false;
        }
        return this.queueToSend.offer(buildWarning);
    }
}

