/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.build.warning.BuildWarning;
import com.atlassian.bamboo.build.warning.BuildWarningQueue;
import com.atlassian.bamboo.build.warning.BuildWarningSenderException;
import com.atlassian.bamboo.build.warning.WarningAnnotation;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooRepositoryUtils;
import com.atlassian.bamboo.utils.archive.ArchiveUtils;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsBuildWarningsUpdater;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildWarningSenderWorker
implements Runnable {
    private static final Logger log = Logger.getLogger(BuildWarningSenderWorker.class);
    private static final int BULK_SIZE = 128;
    private static final int MAX_ENTRIES = 1000;
    private final ArtifactLinkDao artifactLinkDao;
    private final ArtifactManager artifactManager;
    private final BlockingQueue<BuildWarning> queue;
    private final CustomVariableContext customVariableContext;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final VcsRepositoryManager vcsRepositoryManager;
    private Set<String> skipKeys = new HashSet<String>();

    BuildWarningSenderWorker(@NotNull BlockingQueue<BuildWarning> queue, @NotNull ArtifactManager artifactManager, @NotNull CustomVariableContext customVariableContext, @NotNull ArtifactLinkDao artifactLinkDao, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull ResultsSummaryManager resultsSummaryManager, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.queue = queue;
        this.artifactManager = artifactManager;
        this.customVariableContext = customVariableContext;
        this.artifactLinkDao = artifactLinkDao;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<Void>("Can't handle build warning"){

                @Override
                public Void call() throws Exception {
                    BuildWarningSenderWorker.this.handleBuildWarning((BuildWarning)BuildWarningSenderWorker.this.queue.take());
                    return null;
                }

                @Override
                public void onThrow(@NotNull Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void handleBuildWarning(@NotNull BuildWarning warning) throws IOException {
        Gson gson = new GsonBuilder().create();
        log.debug((Object)("Start processing of build warnings for " + warning.getChainResultKey()));
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (warning.isRebuild()) {
            this.removePreviousBuildWarnings(warning);
        }
        this.handleEmptyResult(warning);
        Multimap<String, Artifact> availableArtifacts = this.getAvailableArtifacts(warning.getChainResultKey());
        BuildWarningQueue warningsPerRepo = this.createWarningsPerRepoContainer(warning);
        for (BuildWarning.Artifact artifact : warning.getArtifacts()) {
            log.debug((Object)("Processing warnings from " + artifact.getJobResultKey() + " artifact " + artifact.getArtifactDefinitionContext()));
            File destinationDirectory = BambooFileUtils.createTempDirectory("CodeWarnings");
            try {
                JsonReader jsonReader = new JsonReader((Reader)new FileReader(this.getJsonWithWarnings(artifact.getArtifactDefinitionContext(), destinationDirectory, artifact.getJobResultKey(), warning.getArtifactHandlerConfiguration(), availableArtifacts)));
                Throwable throwable = null;
                try {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        WarningAnnotation warningAnnotation = (WarningAnnotation)gson.fromJson(jsonReader, WarningAnnotation.class);
                        warningsPerRepo.add(warningAnnotation.getRepositoryId(), warningAnnotation);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonReader == null) continue;
                    if (throwable != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jsonReader.close();
                }
            }
            catch (BuildWarningSenderException ex) {
                log.info((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                BambooPathUtils.deleteQuietly((Path)destinationDirectory.toPath());
            }
        }
        stopwatch.stop();
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (int)60, (int)180, (int)600, (String)("Finished processing of build warnings for " + warning.getChainResultKey()));
        warningsPerRepo.flushAll();
    }

    private void handleEmptyResult(@NotNull BuildWarning warning) {
        log.debug((Object)"Send empty reports if required");
        for (Long repositoryId : warning.getRepositoryIds()) {
            BuildWarning.RepositoryNotificationInfo info = warning.getRepositoryNotificationInfo(repositoryId);
            if (!this.hasZeroWarnings(info.getSummary())) continue;
            BiConsumer<Long, Collection<WarningAnnotation>> flushHandler = this.getFlushHandler(warning);
            flushHandler.accept(info.getSummary().getRepositoryId(), Collections.emptyList());
        }
    }

    private boolean hasZeroWarnings(@NotNull BuildWarningSummary summary) {
        return summary.getHighPriorityCount() + summary.getNormalPriorityCount() + summary.getLowPriorityCount() == 0L;
    }

    private void removePreviousBuildWarnings(BuildWarning warning) {
        ImmutableChainResultsSummary resultsSummary = this.getImmutableChainResultsSummary(warning);
        if (resultsSummary == null) {
            return;
        }
        for (Long repositoryId : warning.getRepositoryIds()) {
            VcsRepositoryData repositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(repositoryId.longValue());
            if (repositoryData == null) continue;
            BuildWarning.RepositoryNotificationInfo repositoryNotificationInfo = warning.getRepositoryNotificationInfo(repositoryId);
            BambooRepositoryUtils.getRepositoryBuildWarningUpdater(repositoryId, this.vcsRepositoryManager, this.repositoryDefinitionManager, log).ifPresent(updater -> {
                for (String changeSet : repositoryNotificationInfo.getChangeSets()) {
                    this.removeBuildWarning(resultsSummary, repositoryData, changeSet, (VcsBuildWarningsUpdater)updater);
                }
            });
        }
    }

    @Nullable
    private ImmutableChainResultsSummary getImmutableChainResultsSummary(@NotNull BuildWarning warning) {
        ImmutableChainResultsSummary resultsSummary = (ImmutableChainResultsSummary)this.resultsSummaryManager.getResultsSummary(warning.getChainResultKey(), ChainResultsSummary.class);
        if (resultsSummary == null) {
            log.debug((Object)("Can't find chain result by key: " + warning.getChainResultKey()));
            return null;
        }
        return resultsSummary;
    }

    private void removeBuildWarning(ImmutableChainResultsSummary resultsSummary, VcsRepositoryData repositoryData, String changeSet, VcsBuildWarningsUpdater updater) {
        try {
            updater.deleteBuildWarnings(repositoryData, changeSet, resultsSummary);
        }
        catch (RepositoryException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    protected BuildWarningQueue createWarningsPerRepoContainer(@NotNull BuildWarning warning) {
        return new BuildWarningQueue(128, 1000, this.getFlushHandler(warning));
    }

    @VisibleForTesting
    @NotNull
    BiConsumer<Long, Collection<WarningAnnotation>> getFlushHandler(@NotNull BuildWarning buildWarning) {
        return (repositoryId, warnings) -> {
            log.debug((Object)("Flushing " + repositoryId + " for " + buildWarning.getChainResultKey()));
            VcsRepositoryData repo = this.repositoryDefinitionManager.getVcsRepositoryData(repositoryId.longValue());
            if (repo == null) {
                log.debug((Object)("Can't send warning data for repo with id=" + repositoryId + " because it was not found in DB"));
                return;
            }
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repo.getPluginKey());
            if (moduleDescriptor == null || !moduleDescriptor.supportsBuildWarnings()) {
                log.debug((Object)("Can't send warning data for repo " + repo.getName() + " (id=" + repositoryId + ") because it uses disabled plugin"));
                return;
            }
            VcsBuildWarningsUpdater buildWarningsUpdater = moduleDescriptor.getBuildWarningsUpdater();
            if (buildWarningsUpdater == null || !buildWarningsUpdater.supportsBuildWarnings(repo)) {
                log.debug((Object)("Can't send warning data for repo " + repo.getName() + " (id=" + repositoryId + ") because it doesn't support this feature"));
                return;
            }
            ImmutableChainResultsSummary resultsSummary = this.getImmutableChainResultsSummary(buildWarning);
            if (resultsSummary == null) {
                return;
            }
            BuildWarning.RepositoryNotificationInfo affectedRepoDetails = buildWarning.getRepositoryNotificationInfo((Long)repositoryId);
            if (affectedRepoDetails != null) {
                for (String changeSet : affectedRepoDetails.getChangeSets()) {
                    if (this.skipKeys.contains(this.getKey((Long)repositoryId, changeSet))) {
                        log.trace((Object)("skip " + changeSet));
                        continue;
                    }
                    try {
                        log.debug((Object)("Sending build warnings to " + repo));
                        boolean willAcceptMore = buildWarningsUpdater.sendBuildWarnings(repo, changeSet, resultsSummary, affectedRepoDetails.getSummary(), (Iterable)warnings);
                        if (willAcceptMore) continue;
                        log.debug((Object)String.format("Ignore future updates to %s (id=%s) and changeset %s", repo.getName(), repo.getId(), changeSet));
                        this.skipKeys.add(this.getKey((Long)repositoryId, changeSet));
                    }
                    catch (RepositoryException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
    }

    private String getKey(Long id, String changeSet) {
        return id + "@" + changeSet;
    }

    @NotNull
    private File getJsonWithWarnings(@NotNull ArtifactDefinitionContext artifactDefinitionContext, @NotNull File destinationDirectory, @NotNull PlanResultKey jobResultKey, @NotNull Map<String, String> artifactHandlerConfiguration, @NotNull Multimap<String, Artifact> chainResultArtifacts) {
        VariableSubstitutor variableSubstitutorForGlobalContext = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
        boolean success = (Boolean)this.customVariableContext.withVariableSubstitutor(variableSubstitutorForGlobalContext, () -> this.artifactManager.retrieve((BuildLogger)new NullBuildLogger(), jobResultKey, (ResultKey)jobResultKey, artifactDefinitionContext, "", artifactHandlerConfiguration, destinationDirectory, chainResultArtifacts));
        if (!success) {
            throw new BuildWarningSenderException(String.format("Unable to retrieve artifact for %s", jobResultKey));
        }
        return this.unzipWarnings(destinationDirectory);
    }

    @NotNull
    private File unzipWarnings(@NotNull File destinationDirectory) {
        try {
            File zipFile = this.getChildFileEndingWith(destinationDirectory, "zip");
            ArchiveUtils.extractArchive(ArchiverType.ZIP, zipFile, destinationDirectory);
            return this.getChildFileEndingWith(destinationDirectory, "json");
        }
        catch (IOException ex) {
            throw new BuildWarningSenderException(ex);
        }
    }

    @NotNull
    private File getChildFileEndingWith(@NotNull File destinationFile, @NotNull String ending) {
        File[] files = destinationFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(ending)) continue;
                return file;
            }
        }
        throw new BuildWarningSenderException(String.format("Cannot find file which ends with %s in %s", ending, destinationFile.getAbsolutePath()));
    }

    @NotNull
    private Multimap<String, Artifact> getAvailableArtifacts(@NotNull PlanResultKey chainResultKey) {
        ArrayListMultimap availableArtifacts = ArrayListMultimap.create();
        Collection artifactsByChainResultKey = this.artifactLinkDao.findArtifactsByChainResultKey(chainResultKey);
        artifactsByChainResultKey.stream().map(ArtifactLink::getArtifact).forEach(arg_0 -> BuildWarningSenderWorker.lambda$getAvailableArtifacts$3((Multimap)availableArtifacts, arg_0));
        return availableArtifacts;
    }

    private static /* synthetic */ void lambda$getAvailableArtifacts$3(Multimap availableArtifacts, MutableArtifact t) {
        availableArtifacts.put((Object)t.getLabel(), (Object)t);
    }
}

