/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.warning.BuildWarningSummaryCollationService;
import com.atlassian.bamboo.build.warning.WarningAnnotation;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.archive.ArchiveUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildWarningSummaryCollationServiceImpl
implements BuildWarningSummaryCollationService {
    private final String BUILD_WARNINGS_FILE = "buildWarnings_";
    private static final Logger log = Logger.getLogger(BuildWarningSummaryCollationServiceImpl.class);
    @Inject
    private HomeDirectoryLayout homeDirectoryLayout;
    @Inject
    private ArtifactManager artifactManager;
    @Inject
    private BuildLoggerManager buildLoggerManager;
    private Map<ResultKey, JsonWriter> writers = new ConcurrentHashMap<ResultKey, JsonWriter>();

    private void collateBuildWarnings(@NotNull TaskContext taskContext, @NotNull BuildWarningSummary warningSummary) {
        Optional<BuildWarningSummary> summaryForSameRepository = taskContext.getBuildContext().getBuildResult().getBuildWarningSummaries().stream().filter(summary -> Objects.equals(summary.getRepositoryId(), warningSummary.getRepositoryId())).findFirst();
        if (summaryForSameRepository.isPresent()) {
            summaryForSameRepository.get().append(warningSummary);
        } else {
            taskContext.getBuildContext().getBuildResult().getBuildWarningSummaries().add(warningSummary);
        }
    }

    public void appendWarningAnnotations(@NotNull TaskContext taskContext, @NotNull Iterable<WarningAnnotation> annotations, @NotNull Long associatedRepositoryId) throws IOException {
        long warningCountSoFar = this.totalWarningsCount(taskContext.getBuildContext());
        if (Iterables.size(annotations) > 0) {
            this.countWarningsPerRepository(annotations).forEach(ws -> this.collateBuildWarnings(taskContext, (BuildWarningSummary)ws));
        } else {
            this.collateBuildWarnings(taskContext, new BuildWarningSummary(associatedRepositoryId.longValue(), 0L, 0L, 0L));
        }
        if (this.maximumWarningCountReached(warningCountSoFar, taskContext.getBuildContext())) {
            return;
        }
        Gson gson = new Gson();
        File aggregationFile = this.aggregationFileForCommonContext(taskContext.getCommonContext());
        JsonWriter writer = this.writers.computeIfAbsent(taskContext.getCommonContext().getResultKey(), rk -> {
            try {
                JsonWriter writer1 = new JsonWriter((Writer)new FileWriter(aggregationFile, true));
                writer1.beginArray();
                return writer1;
            }
            catch (IOException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        });
        for (WarningAnnotation annotation : annotations) {
            gson.toJson(gson.toJsonTree((Object)annotation), writer);
            if (!this.maximumWarningCountReached(++warningCountSoFar, taskContext.getBuildContext())) continue;
            break;
        }
        writer.flush();
    }

    private boolean maximumWarningCountReached(long warningCountSoFar, @NotNull BuildContext taskContext) {
        boolean countExceeded;
        long maximumWarningCount = taskContext.getMaximumBuildWarningsCount();
        boolean bl = countExceeded = maximumWarningCount >= 0L && warningCountSoFar >= maximumWarningCount;
        if (countExceeded) {
            log.info((Object)"Maximum count of build warnings exceeded, no more warnings will be stored in the result file");
        }
        return countExceeded;
    }

    private long totalWarningsCount(@NotNull BuildContext taskContext) {
        return taskContext.getBuildResult().getBuildWarningSummaries().stream().mapToLong(bws -> bws.getHighPriorityCount() + bws.getLowPriorityCount() + bws.getNormalPriorityCount()).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishCollectedWarnings(@NotNull BuildContext buildContext) throws IOException {
        long warningCountSoFar = this.totalWarningsCount(buildContext);
        if (this.maximumWarningCountReached(warningCountSoFar, buildContext)) {
            this.buildLoggerManager.getLogger(buildContext.getResultKey()).addBuildLogEntry(String.format("Maximum build warnings count reached. %d out of %d warnings stored in the result file.", buildContext.getMaximumBuildWarningsCount(), warningCountSoFar));
        }
        if (this.writers.containsKey(buildContext.getResultKey())) {
            File archiveFile = this.aggregationArchiveFileForContext((CommonContext)buildContext);
            if (archiveFile.exists()) {
                BambooPathUtils.deleteQuietly((Path)archiveFile.toPath());
            }
            try {
                JsonWriter writer = this.writers.remove(buildContext.getResultKey());
                writer.endArray();
                writer.close();
                ArchiveUtils.compressFiles(ArchiverType.ZIP, Collections.singletonList(this.aggregationFileForCommonContext((CommonContext)buildContext)), archiveFile, this.aggregationArchiveFileForContext((CommonContext)buildContext).getParentFile());
                Map<String, String> artifactHandlerConfiguration = BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)buildContext);
                String artifactName = this.getUniqueArtifactName(buildContext);
                buildContext.getCurrentResult().getCustomBuildData().put(WARNINGS_ARTIFACT, artifactName);
                ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl(this.getUniqueArtifactName(buildContext), true, buildContext.getArtifactContext().getSecureToken());
                artifact.setLocation(this.getWarningsDirectory((CommonContext)buildContext).getAbsolutePath());
                artifact.setCopyPattern(this.aggregationArchiveNameForContext((CommonContext)buildContext));
                ArtifactPublishingResult publishingResult = this.artifactManager.publish(null, buildContext.getPlanResultKey(), archiveFile.getParentFile(), (ArtifactDefinitionContext)artifact, artifactHandlerConfiguration, 1);
                buildContext.getArtifactContext().addPublishingResult(publishingResult);
            }
            finally {
                BambooPathUtils.deleteQuietly((Path)archiveFile.toPath());
            }
        }
    }

    @NotNull
    private String getUniqueArtifactName(@NotNull BuildContext buildContext) {
        String name = "Build warnings for " + buildContext.getShortName();
        String suffix = "";
        int count = 0;
        Set artifactNames = buildContext.getArtifactContext().getDefinitionContexts().stream().map(ImmutableArtifactDefinitionBase::getName).collect(Collectors.toSet());
        while (artifactNames.contains(name + suffix)) {
            suffix = " " + ++count;
        }
        return name + suffix;
    }

    @NotNull
    public File aggregationFileForCommonContext(@NotNull CommonContext commonContext) {
        return new File(this.getWarningsDirectory(commonContext), this.aggregationJsonFileNameForContext(commonContext));
    }

    private File aggregationArchiveFileForContext(@NotNull CommonContext commonContext) {
        return new File(this.getWarningsDirectory(commonContext), this.aggregationArchiveNameForContext(commonContext));
    }

    @NotNull
    private String aggregationJsonFileNameForContext(@NotNull CommonContext commonContext) {
        return "buildWarnings_" + commonContext.getResultKey() + ".json";
    }

    @NotNull
    private String aggregationArchiveNameForContext(@NotNull CommonContext commonContext) {
        return this.getAggregationFileNameForContext(commonContext) + ".zip";
    }

    @NotNull
    private File getWarningsDirectory(@NotNull CommonContext commonContext) {
        File warningsDirectory = new File(this.homeDirectoryLayout.getTempDirectory(), "__warnings__");
        warningsDirectory.mkdirs();
        return warningsDirectory;
    }

    @NotNull
    private String getAggregationFileNameForContext(@NotNull CommonContext commonContext) {
        return "buildWarnings_" + commonContext.getResultKey();
    }

    @NotNull
    private Stream<BuildWarningSummary> countWarningsPerRepository(@NotNull Iterable<WarningAnnotation> warnings) {
        HashMap<Long, WarningCounters> counters = new HashMap<Long, WarningCounters>();
        block4: for (WarningAnnotation warning : warnings) {
            WarningCounters counter = counters.computeIfAbsent(warning.getRepositoryId(), l -> new WarningCounters());
            switch (warning.getSeverity()) {
                case LOW: {
                    ++counter.lowCount;
                    continue block4;
                }
                case HIGH: {
                    ++counter.highCount;
                    continue block4;
                }
            }
            ++counter.normalCount;
        }
        return counters.entrySet().stream().map(e -> new BuildWarningSummary(e.getKey() != null ? (Long)e.getKey() : -1L, ((WarningCounters)e.getValue()).highCount, ((WarningCounters)e.getValue()).normalCount, ((WarningCounters)e.getValue()).lowCount));
    }

    private static class WarningCounters {
        public long lowCount = 0L;
        public long normalCount = 0L;
        public long highCount = 0L;

        private WarningCounters() {
        }
    }
}

