/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.build.warning.BuildWarning;
import com.atlassian.bamboo.build.warning.BuildWarningSenderService;
import com.atlassian.bamboo.build.warning.BuildWarningSummaryCollationService;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryManager;
import com.atlassian.bamboo.utils.BambooRepositoryUtils;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SendBuildWarningsOnChainCompletedEventListener {
    private static final Logger log = Logger.getLogger(SendBuildWarningsOnChainCompletedEventListener.class);
    @Inject
    private BuildWarningSenderService buildWarningSenderService;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private BuildResultWarningSummaryManager buildResultWarningSummaryManager;
    @Inject
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private TransactionAndHibernateTemplate hibernateTemplate;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;
    private Cache<Long, Boolean> supportsBuildWarningReceiving;

    @PostConstruct
    private void postConstruct() {
        this.supportsBuildWarningReceiving = this.cacheManager.getCache(SendBuildWarningsOnChainCompletedEventListener.class.getName() + ".supportsBuildWarningReceiving.cache", (CacheLoader)new CacheLoader<Long, Boolean>(){

            @Nonnull
            public Boolean load(@Nonnull Long repositoryId) {
                return BambooRepositoryUtils.getRepositoryBuildWarningUpdater(repositoryId, SendBuildWarningsOnChainCompletedEventListener.this.vcsRepositoryManager, SendBuildWarningsOnChainCompletedEventListener.this.repositoryDefinitionManager, log).isPresent();
            }
        }, new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(100).build());
    }

    @EventListener
    public void onChainComplete(ChainCompletedEvent event) {
        PlanResultKey planResultKey = event.getPlanResultKey();
        this.hibernateTemplate.execute(session -> {
            Collection<BuildWarningSummary> chainWarningSummaries;
            ChainResultsSummary resultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class, ResultDataRead.FULL);
            if (resultsSummary != null && !(chainWarningSummaries = this.getBuildWarningSummaries(resultsSummary)).isEmpty()) {
                Collection<BuildWarning.Artifact> artifacts = this.getBuildWarningArtifacts(resultsSummary);
                if (!artifacts.isEmpty()) {
                    BuildWarning buildWarning = new BuildWarning(planResultKey, resultsSummary.isRebuild(), chainWarningSummaries, this.getLatestChanges(resultsSummary), this.getArtifactHandlerConfiguration(resultsSummary), artifacts);
                    boolean enqueued = this.buildWarningSenderService.enqueue(buildWarning);
                    if (!enqueued) {
                        log.warn((Object)("Couldn't enqueue " + buildWarning));
                    }
                } else {
                    log.info((Object)("No artifacts with build warnings were found for " + resultsSummary.getPlanResultKey()));
                }
            }
            return null;
        });
    }

    @NotNull
    private Collection<BuildWarningSummary> getBuildWarningSummaries(ChainResultsSummary resultsSummary) {
        return this.buildResultWarningSummaryManager.findByResultSummary(resultsSummary.getId()).stream().filter(summary -> summary.getRepositoryId() != -1L && (Boolean)this.supportsBuildWarningReceiving.get((Object)summary.getRepositoryId()) != false).collect(Collectors.toList());
    }

    @NotNull
    private Collection<BuildWarning.Artifact> getBuildWarningArtifacts(@NotNull ChainResultsSummary resultsSummary) {
        ArrayList<BuildWarning.Artifact> artifacts = new ArrayList<BuildWarning.Artifact>();
        for (ChainStageResult stageResult : resultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResult : stageResult.getBuildResults()) {
                Optional<String> artifactName = this.getArtifactName(buildResult);
                Optional<MutableArtifact> artifact = artifactName.map(artifactNameS -> {
                    Collection producedArtifacts = buildResult.getProducedArtifactLinks();
                    return producedArtifacts.stream().filter(t -> t.getArtifact().getLabel().equals(artifactNameS)).map(ArtifactLink::getArtifact).findFirst().orElse(null);
                });
                if (artifact.isPresent()) {
                    artifacts.add(new BuildWarning.Artifact(buildResult.getPlanResultKey(), artifact.get().getLabel()));
                    continue;
                }
                log.debug((Object)String.format("Cannot get build warnings artifact %s for result %s", artifactName.orElse("unknown artifact"), buildResult.getPlanResultKey()));
            }
        }
        return artifacts;
    }

    private Map<String, String> getArtifactHandlerConfiguration(ChainResultsSummary chainResultsSummary) {
        Map runtimeArtifactHandlerConfiguration = this.artifactHandlersService.getRuntimeConfiguration();
        BuildContextHelper.applyBuildDefinitionOverrides(runtimeArtifactHandlerConfiguration, chainResultsSummary.getImmutablePlan().getBuildDefinition());
        return runtimeArtifactHandlerConfiguration;
    }

    private Collection<BuildWarning.RepositoryChangeset> getLatestChanges(ChainResultsSummary resultsSummary) {
        PlanRepositoryDefinition repositoryData;
        HashMap<Long, BuildWarning.RepositoryChangeset> latestChanges = new HashMap<Long, BuildWarning.RepositoryChangeset>();
        resultsSummary.getRepositoryChangesets().forEach(changeSet -> latestChanges.computeIfAbsent(changeSet.getRepositoryData().getId(), id -> new BuildWarning.RepositoryChangeset((long)id, changeSet.getChangesetId())));
        MergeResultSummary mergeResult = resultsSummary.getMergeResult();
        if (mergeResult != null && mergeResult.getPushState() == MergeResultState.SUCCESS && (repositoryData = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)resultsSummary.getImmutablePlan())) != null && mergeResult.getMergeResultVcsKey() != null) {
            latestChanges.put(repositoryData.getId(), new BuildWarning.RepositoryChangeset(mergeResult.getIntegrationRepositoryId(), mergeResult.getMergeResultVcsKey()));
        }
        return latestChanges.values();
    }

    private Optional<String> getArtifactName(BuildResultsSummary buildResultsSummary) {
        String artifactName = (String)buildResultsSummary.getCustomBuildData().get(BuildWarningSummaryCollationService.WARNINGS_ARTIFACT);
        if (StringUtils.isBlank((CharSequence)artifactName)) {
            return Optional.empty();
        }
        return Optional.of(artifactName);
    }
}

