/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.configuration.Jdk;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultJdkManager
implements JdkManager {
    private static final Logger log = Logger.getLogger(DefaultJdkManager.class);
    private CapabilitySetManager capabilitySetManager;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;

    @NotNull
    public CapabilitySet addDefaultJdkToCapabilitySet(@NotNull CapabilitySet capabilitySet) {
        Jdk jdk = Jdk.discoverDefaultJdk();
        String defaultJdkCapability = "system.jdk.JDK";
        String javaMajorMinor = "system.jdk.JDK " + this.getShortJavaVersion(jdk.getLabel());
        capabilitySet.addCapability((Capability)new CapabilityImpl(javaMajorMinor, jdk.getHomeDirectory()), false);
        String javaMajorMinorPatch = jdk.getLabel();
        capabilitySet.addCapability((Capability)new CapabilityImpl("system.jdk.JDK " + javaMajorMinorPatch, jdk.getHomeDirectory()), false);
        if (capabilitySet.getCapability("system.jdk.JDK") == null) {
            capabilitySet.addCapability((Capability)new CapabilityImpl("system.jdk.JDK", jdk.getHomeDirectory()), false);
        }
        return capabilitySet;
    }

    @NotNull
    String getShortJavaVersion(@NotNull String longJavaVersion) {
        String[] parts = longJavaVersion.split("\\.");
        if (parts.length >= 2) {
            return parts[0] + "." + parts[1];
        }
        return longJavaVersion;
    }

    @NotNull
    public List<String> getJdkLabels() {
        HashSet<String> jdkLabels = new HashSet<String>();
        Collection capabilityKeys = this.capabilitySetManager.getSystemCapabilityKeys("jdk", this.elasticFunctionalityFacade.isElasticSupportEnabled());
        for (String capabilityKey : capabilityKeys) {
            String[] strings = capabilityKey.split("\\.", 3);
            if (strings.length != 3) continue;
            jdkLabels.add(strings[2]);
        }
        return Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).sortedCopy(jdkLabels);
    }

    @NotNull
    public String getDefaultJdkLabel() {
        Jdk jdk = Jdk.discoverDefaultJdk();
        return "JDK " + this.getShortJavaVersion(jdk.getLabel());
    }

    public void setCapabilitySetManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }
}

