/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.build.LogEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MavenLogHelper
implements Serializable {
    private static final Logger log = Logger.getLogger(MavenLogHelper.class);

    @NotNull
    public static List<String> parseErrorOutput(@NotNull Iterable<LogEntry> logsToParse) {
        return MavenLogHelper.parseErrorOutput(logsToParse, new ErrorMatcher());
    }

    @NotNull
    private static List<String> parseErrorOutput(Iterable<LogEntry> logsToParse, ErrorMatcher fatalMatcher) {
        MavenLogHelper.parseLogs(fatalMatcher, logsToParse);
        return fatalMatcher.getErrorLogs();
    }

    private static void parseLogs(ErrorMatcher matcher, Iterable<LogEntry> logsToParse) {
        String previousLog = null;
        for (LogEntry logEntry : logsToParse) {
            String currentLog = logEntry.getUnstyledLog();
            matcher.match(previousLog, currentLog);
            previousLog = currentLog;
        }
    }

    private static class ErrorMatcher {
        private boolean matched;
        private final List<String> errorLogs = new ArrayList<String>();

        private ErrorMatcher() {
        }

        public void match(String previousLog, String currentLog) {
            if (this.matched) {
                if (!this.isEnd(previousLog, currentLog)) {
                    this.errorLogs.add(previousLog);
                } else {
                    this.matched = false;
                }
            } else if (this.isStart(currentLog)) {
                if (previousLog != null) {
                    this.errorLogs.add(previousLog);
                }
                this.matched = true;
            }
        }

        @NotNull
        public List<String> getErrorLogs() {
            return this.errorLogs;
        }

        private boolean isEnd(String previousLog, String currentLog) {
            return previousLog != null && "[INFO] ------------------------------------------------------------------------".equals(previousLog) && currentLog != null && currentLog.startsWith("[INFO] Total time: ");
        }

        private boolean isStart(String currentLog) {
            return "[ERROR] FATAL ERROR".equals(currentLog) || "[ERROR] BUILD ERROR".equals(currentLog) || "[ERROR] BUILD FAILURE".equals(currentLog);
        }
    }
}

