/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public class ImmutableRemoteAgentAuthentication
implements Comparable<RemoteAgentAuthentication>,
RemoteAgentAuthentication {
    private final long id;
    private final String ip;
    private final UUID uuid;
    private final boolean approved;
    private final Set<String> ipPatterns;

    public ImmutableRemoteAgentAuthentication(@NotNull UUID uuid, @NotNull String ip) {
        this(uuid, ip, false);
    }

    public ImmutableRemoteAgentAuthentication(@NotNull UUID uuid, @NotNull String ip, boolean approved) {
        this.id = -1L;
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.uuid = (UUID)Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        this.approved = approved;
        this.ipPatterns = RemoteAgentAuthentications.ipStringToSet(ip);
    }

    public ImmutableRemoteAgentAuthentication(RemoteAgentAuthenticationEntity entity) {
        this.id = entity.getId();
        this.ip = (String)Preconditions.checkNotNull((Object)entity.getIp(), (Object)"ip");
        this.uuid = (UUID)Preconditions.checkNotNull((Object)entity.getUuid(), (Object)"uuid");
        this.approved = entity.isApproved();
        this.ipPatterns = RemoteAgentAuthentications.ipStringToSet(this.ip);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public boolean isApproved() {
        return this.approved;
    }

    @Override
    public Set<String> getIpPatterns() {
        return this.ipPatterns;
    }

    public boolean matches(@NotNull String ip) {
        return RemoteAgentAuthentications.matching(ip).apply((Object)this);
    }

    public boolean matches(UUID uuid, String ip) {
        return RemoteAgentAuthentications.matching(uuid, ip).apply((Object)this);
    }

    @Override
    public int compareTo(RemoteAgentAuthentication other) {
        return new CompareToBuilder().append((Object)this.getIp(), (Object)other.getIp()).append((Object)this.getUuid(), (Object)other.getUuid()).append(this.isApproved(), other.isApproved()).toComparison();
    }

    public boolean equals(Object o) {
        if (!ImmutableRemoteAgentAuthentication.class.isInstance(o)) {
            return false;
        }
        ImmutableRemoteAgentAuthentication other = (ImmutableRemoteAgentAuthentication)o;
        return new EqualsBuilder().append((Object)this.getIp(), (Object)other.getIp()).append((Object)this.getUuid(), (Object)other.getUuid()).append(this.isApproved(), other.isApproved()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(21, 37).append((Object)this.getIp()).append((Object)this.getUuid()).append(this.isApproved()).toHashCode();
    }

    public long getId() {
        return this.id;
    }
}

