/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.atlassian.bamboo.core.BambooEntityObject;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="AGENT_AUTHENTICATION")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class RemoteAgentAuthenticationImpl
extends BambooEntityObject
implements RemoteAgentAuthenticationEntity {
    private String ip;
    private UUID uuid;
    private boolean isApproved;
    private Set<String> ipPatterns;

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setIp(@NotNull String ip) {
        this.ip = ip;
        this.ipPatterns = RemoteAgentAuthentications.ipStringToSet(ip);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUuidAsString() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    @Override
    public void setUuidAsString(String uuidAsString) {
        this.uuid = uuidAsString != null ? UUID.fromString(uuidAsString) : null;
    }

    @Override
    public boolean isApproved() {
        return this.isApproved;
    }

    @Override
    public void setApproved(boolean isApproved) {
        this.isApproved = isApproved;
    }

    @Override
    public Set<String> getIpPatterns() {
        return this.ipPatterns;
    }

    @Override
    public int compareTo(RemoteAgentAuthenticationEntity other) {
        return new CompareToBuilder().append((Object)this.getIp(), (Object)other.getIp()).append((Object)this.getUuid(), (Object)other.getUuid()).append(this.isApproved(), other.isApproved()).toComparison();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteAgentAuthenticationEntity other = (RemoteAgentAuthenticationEntity)o;
        return new EqualsBuilder().append((Object)this.getIp(), (Object)other.getIp()).append((Object)this.getUuid(), (Object)other.getUuid()).append(this.isApproved(), other.isApproved()).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.getIp(), this.getUuid(), this.isApproved());
    }
}

