/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue;

import com.atlassian.bamboo.buildqueue.ImmutableRemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationImpl;
import com.atlassian.bamboo.buildqueue.dao.RemoteAgentAuthenticationDao;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.security.auth.trustedapps.AtlassianIPMatcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class RemoteAgentAuthentications {
    private RemoteAgentAuthentications() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Function<RemoteAgentAuthentication, String> getUuidAsString() {
        return input -> input.getUuid().toString();
    }

    public static Predicate<RemoteAgentAuthentication> matching(final @NotNull String requestIps) {
        return new Predicate<RemoteAgentAuthentication>(){
            private final Set<String> requestIpSet;
            {
                this.requestIpSet = RemoteAgentAuthentications.ipStringToSet(requestIps);
            }

            public boolean apply(RemoteAgentAuthentication existingAuth) {
                if (!existingAuth.isApproved()) {
                    return existingAuth.getIpPatterns().containsAll(this.requestIpSet);
                }
                AtlassianIPMatcher ipMatcher = new AtlassianIPMatcher(existingAuth.getIpPatterns());
                for (String ip : this.requestIpSet) {
                    if (ipMatcher.match(ip)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Predicate<RemoteAgentAuthentication> matching(@NotNull UUID uuid) {
        return input -> input.getUuid().equals(uuid);
    }

    public static Predicate<RemoteAgentAuthentication> matching(@NotNull UUID uuid, @NotNull String ip) {
        return Predicates.and(RemoteAgentAuthentications.matching(uuid), RemoteAgentAuthentications.matching(ip));
    }

    public static Predicate<RemoteAgentAuthentication> matchingUuidOf(@NotNull Iterable<RemoteAgentAuthentication> authentications) {
        Set uuids = (Set)BambooIterables.stream(authentications).map(RemoteAgentAuthentication::getUuid).collect(CollectorsUtil.toImmutableSet());
        return input -> input.getUuid() != null && uuids.contains(input.getUuid());
    }

    public static Predicate<RemoteAgentAuthentication> isApproved() {
        return RemoteAgentAuthentication::isApproved;
    }

    public static Predicate<RemoteAgentAuthentication> isPending() {
        return Predicates.not(RemoteAgentAuthentications.isApproved());
    }

    public static Function<RemoteAgentAuthenticationEntity, ImmutableRemoteAgentAuthentication> fromEntity() {
        return ImmutableRemoteAgentAuthentication::new;
    }

    public static java.util.function.Function<RemoteAgentAuthenticationEntity, ImmutableRemoteAgentAuthentication> fromEntityJdk() {
        return ImmutableRemoteAgentAuthentication::new;
    }

    public static Function<RemoteAgentAuthentication, RemoteAgentAuthenticationEntity> toEntity(RemoteAgentAuthenticationDao agentAuthenticationDao) {
        return input -> {
            if (input instanceof RemoteAgentAuthenticationEntity) {
                return (RemoteAgentAuthenticationEntity)input;
            }
            if (input instanceof ImmutableRemoteAgentAuthentication && input.getId() != -1L) {
                return (RemoteAgentAuthenticationEntity)agentAuthenticationDao.findById(input.getId(), RemoteAgentAuthenticationImpl.class);
            }
            RemoteAgentAuthenticationImpl newEntity = new RemoteAgentAuthenticationImpl();
            newEntity.setIp(input.getIp());
            newEntity.setUuid(input.getUuid());
            newEntity.setApproved(input.isApproved());
            return newEntity;
        };
    }

    @NotNull
    public static Set<String> ipStringToSet(@NotNull String ip) {
        return Sets.newHashSet((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)ip));
    }
}

