/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMap;
import org.jetbrains.annotations.NotNull;

public class AgentAssignmentHelper {
    private AgentAssignmentHelper() {
    }

    public static boolean isAssignmentCheckPassed(AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult) {
        return agentAssignmentCheckResult == AgentAssignmentMap.AgentAssignmentCheckResult.NO_AGENT_ASSIGNMENTS || agentAssignmentCheckResult == AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
    }

    public static abstract class ExecutableHandler {
        protected abstract void handleDeploymentProjectAssignment(AgentAssignment var1);

        protected abstract void handleEnvironmentAssignment(@NotNull AgentAssignment var1);

        protected abstract void handleJobAssignment(@NotNull AgentAssignment var1);

        protected abstract void handlePlanAssignment(@NotNull AgentAssignment var1);

        protected abstract void handleProjectAssignment(@NotNull AgentAssignment var1);

        public void call(@NotNull AgentAssignment agentAssignment) {
            AgentAssignment.ExecutableType executableType = agentAssignment.getExecutableType();
            switch (executableType) {
                case DEPLOYMENT_PROJECT: {
                    this.handleDeploymentProjectAssignment(agentAssignment);
                    break;
                }
                case ENVIRONMENT: {
                    this.handleEnvironmentAssignment(agentAssignment);
                    break;
                }
                case JOB: {
                    this.handleJobAssignment(agentAssignment);
                    break;
                }
                case PLAN: {
                    this.handlePlanAssignment(agentAssignment);
                    break;
                }
                case PROJECT: {
                    this.handleProjectAssignment(agentAssignment);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown executable type: " + executableType);
                }
            }
        }
    }
}

