/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMap;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.project.Project;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentAssignmentMapImpl
implements AgentAssignmentMap {
    @NotNull
    private final CachedPlanManager cachedPlanManager;
    @NotNull
    private final DeploymentProjectService deploymentProjectService;
    private final LoadingCache<AgentAssignmentService.AgentAssignmentExecutor, Set<AgentAssignmentService.AgentAssignmentExecutable>> executorToExecutable = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<AgentAssignmentService.AgentAssignmentExecutor, Set<AgentAssignmentService.AgentAssignmentExecutable>>(){

        public Set<AgentAssignmentService.AgentAssignmentExecutable> load(AgentAssignmentService.AgentAssignmentExecutor key) throws Exception {
            return new HashSet<AgentAssignmentService.AgentAssignmentExecutable>();
        }
    });
    private final LoadingCache<AgentAssignmentService.AgentAssignmentExecutable, Set<AgentAssignmentService.AgentAssignmentExecutor>> executableToExecutor = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<AgentAssignmentService.AgentAssignmentExecutable, Set<AgentAssignmentService.AgentAssignmentExecutor>>(){

        public Set<AgentAssignmentService.AgentAssignmentExecutor> load(AgentAssignmentService.AgentAssignmentExecutable key) throws Exception {
            return new HashSet<AgentAssignmentService.AgentAssignmentExecutor>();
        }
    });
    private final LoadingCache<Long, Optional<Long>> environmentIdToProjectId = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, Optional<Long>>(){

        public Optional<Long> load(@NotNull Long key) throws Exception {
            DeploymentProject deploymentProject = AgentAssignmentMapImpl.this.deploymentProjectService.getDeploymentProjectForEnvironment(key.longValue());
            if (deploymentProject == null) {
                return Optional.empty();
            }
            return Optional.of(deploymentProject.getId());
        }
    });

    public AgentAssignmentMapImpl(Iterable<AgentAssignment> agentAssignments, @NotNull CachedPlanManager cachedPlanManager, @NotNull DeploymentProjectService deploymentProjectService) {
        this.cachedPlanManager = cachedPlanManager;
        this.deploymentProjectService = deploymentProjectService;
        for (AgentAssignment agentAssignment : agentAssignments) {
            AgentAssignmentService.AgentAssignmentExecutor executor = new AgentAssignmentService.AgentAssignmentExecutor(agentAssignment.getId(), agentAssignment.getExecutorType(), agentAssignment.getExecutorId());
            AgentAssignmentService.AgentAssignmentExecutable executable = new AgentAssignmentService.AgentAssignmentExecutable(agentAssignment.getId(), agentAssignment.getExecutableType(), agentAssignment.getExecutableId());
            ((Set)this.executorToExecutable.getUnchecked((Object)executor)).add(executable);
            ((Set)this.executableToExecutor.getUnchecked((Object)executable)).add(executor);
        }
    }

    public Set<AgentAssignmentService.AgentAssignmentExecutable> forExecutors(Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
        HashSet<AgentAssignmentService.AgentAssignmentExecutable> executables = new HashSet<AgentAssignmentService.AgentAssignmentExecutable>();
        for (AgentAssignmentService.AgentAssignmentExecutor executor : executors) {
            executables.addAll((Collection)this.executorToExecutable.getUnchecked((Object)executor));
        }
        return executables;
    }

    public Set<AgentAssignmentService.AgentAssignmentExecutor> forExecutables(@NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables) {
        HashSet<AgentAssignmentService.AgentAssignmentExecutor> executors = new HashSet<AgentAssignmentService.AgentAssignmentExecutor>();
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)executable));
        }
        return executors;
    }

    public AgentAssignmentMap.AgentAssignmentCheckResult checkAssignmentRequirements(@Nullable Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables, Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
        if (executables == null) {
            return AgentAssignmentMap.AgentAssignmentCheckResult.NO_AGENT_ASSIGNMENTS;
        }
        HashSet<AgentAssignmentService.AgentAssignmentExecutor> executorsForExecutable = new HashSet<AgentAssignmentService.AgentAssignmentExecutor>();
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            executorsForExecutable.addAll((Collection)this.executableToExecutor.getUnchecked((Object)executable));
            if (!executorsForExecutable.isEmpty()) continue;
            switch (executable.getExecutableType()) {
                case JOB: {
                    this.addExecutorsForJob(executorsForExecutable, executable);
                    break;
                }
                case PLAN: {
                    this.addExecutorsForChain(executorsForExecutable, executable);
                    break;
                }
                case PROJECT: {
                    break;
                }
                case ENVIRONMENT: {
                    this.addExecutorsForEnvironment(executorsForExecutable, executable);
                    break;
                }
            }
        }
        HashSet executablesForExecutors = new HashSet();
        for (AgentAssignmentService.AgentAssignmentExecutor executor : executors) {
            executablesForExecutors.addAll((Collection)this.executorToExecutable.getUnchecked((Object)executor));
        }
        if (executorsForExecutable.isEmpty() && executablesForExecutors.isEmpty()) {
            return AgentAssignmentMap.AgentAssignmentCheckResult.NO_AGENT_ASSIGNMENTS;
        }
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            ImmutableJob job;
            if (executable.getExecutableType() == AgentAssignment.ExecutableType.JOB && (job = (ImmutableJob)this.cachedPlanManager.getPlanById(executable.getExecutableId(), ImmutableJob.class)) != null) {
                for (AgentAssignmentService.AgentAssignmentExecutable assignment : executablesForExecutors) {
                    switch (assignment.getExecutableType()) {
                        case JOB: {
                            ImmutableJob masterJob;
                            ImmutableJob immutableJob = masterJob = job.hasMaster() ? job.getMaster() : job;
                            if (assignment.getExecutableId() != masterJob.getId()) break;
                            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
                        }
                        case PLAN: {
                            ImmutableChain chain;
                            ImmutableChain immutableChain = chain = job.hasMaster() ? job.getMaster().getParent() : job.getParent();
                            if (assignment.getExecutableId() != chain.getId()) break;
                            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
                        }
                        case PROJECT: {
                            Project project = job.getProject();
                            if (assignment.getExecutableId() != project.getId()) break;
                            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
                        }
                    }
                }
            }
            if (executable.getExecutableType() == AgentAssignment.ExecutableType.ENVIRONMENT) {
                for (AgentAssignmentService.AgentAssignmentExecutable assignment : executablesForExecutors) {
                    switch (assignment.getExecutableType()) {
                        case DEPLOYMENT_PROJECT: {
                            Long deploymentProjectId = this.getDeploymentProjectId(executable);
                            if (deploymentProjectId == null || deploymentProjectId.longValue() != assignment.getExecutableId()) break;
                            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
                        }
                    }
                }
            }
            if (!executablesForExecutors.contains(executable)) continue;
            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
        }
        if (executorsForExecutable.isEmpty()) {
            return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_EXCLUSIVELY_ASSIGNED_ELSEWHERE;
        }
        return AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_DOES_NOT_MEET_ASSIGNMENT_REQUIREMENTS;
    }

    private void addExecutorsForEnvironment(Set<AgentAssignmentService.AgentAssignmentExecutor> executors, AgentAssignmentService.AgentAssignmentExecutable executableEnvironment) {
        Long deploymentProjectId = this.getDeploymentProjectId(executableEnvironment);
        if (deploymentProjectId != null) {
            AgentAssignmentService.AgentAssignmentExecutable projectExecutable = new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.DEPLOYMENT_PROJECT, deploymentProjectId.longValue());
            executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)projectExecutable));
        }
    }

    @Nullable
    private Long getDeploymentProjectId(AgentAssignmentService.AgentAssignmentExecutable executableEnvironment) {
        return executableEnvironment.getExecutableGroupId() != null ? executableEnvironment.getExecutableGroupId() : (Long)((Optional)this.environmentIdToProjectId.getUnchecked((Object)executableEnvironment.getExecutableId())).orElse(null);
    }

    private void addExecutorsForChain(Set<AgentAssignmentService.AgentAssignmentExecutor> executors, AgentAssignmentService.AgentAssignmentExecutable executableChain) {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanById(executableChain.getExecutableId(), ImmutableChain.class);
        if (chain != null) {
            Project project = chain.getProject();
            AgentAssignmentService.AgentAssignmentExecutable projectExecutable = new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PROJECT, project.getId());
            executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)projectExecutable));
        }
    }

    private void addExecutorsForJob(Set<AgentAssignmentService.AgentAssignmentExecutor> executors, AgentAssignmentService.AgentAssignmentExecutable executableJob) {
        ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanByIdNotThrowing(executableJob.getExecutableId(), ImmutableJob.class);
        if (job == null) {
            return;
        }
        if (job.getMasterIdIfExists().isPresent()) {
            AgentAssignmentService.AgentAssignmentExecutable jobExecutable = new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.JOB, ((Long)job.getMasterIdIfExists().get()).longValue());
            executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)jobExecutable));
        }
        ImmutableChain chain = job.hasMaster() ? job.getMaster().getParent() : job.getParent();
        Project project = job.getProject();
        AgentAssignmentService.AgentAssignmentExecutable chainExecutable = new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PLAN, chain.getId());
        executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)chainExecutable));
        AgentAssignmentService.AgentAssignmentExecutable projectExecutable = new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PROJECT, project.getId());
        executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)projectExecutable));
    }
}

