/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.dao.AgentAssignmentDao;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMap;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMapImpl;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.agent.AgentAssignmentsUpdatedEvent;
import com.atlassian.bamboo.exception.AccessDeniedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CacheLoadContextSupport;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.v2.build.agent.AgentAssignmentImpl;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.support.TransactionTemplate;

public class AgentAssignmentServiceImpl
implements AgentAssignmentService {
    private static final Logger log = Logger.getLogger(AgentAssignmentServiceImpl.class);
    private final AgentAssignmentDao agentAssignmentDao;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @Inject
    private SessionFactory sessionFactory;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CachedPlanManager cachedPlanManager;
    @Lazy
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Lazy
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final EnvironmentService environmentService;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final CapabilitySetManager capabilitySetManager;
    @NotNull
    private final CapabilityRequirementsMatcher capabilityRequirementsMatcher;
    @NotNull
    private final AuditLogService auditLogService;
    @Lazy
    @Inject
    private AgentManager agentManager;
    @Inject
    @Lazy
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    private final ResettableLazyReference<AgentAssignmentMap> agentAssignmentMap = new ResettableLazyReference<AgentAssignmentMap>(){

        protected AgentAssignmentMap create() {
            return CacheLoadContextSupport.load(AgentAssignmentServiceImpl.this.transactionTemplate, AgentAssignmentServiceImpl.this.sessionFactory, () -> new AgentAssignmentMapImpl(AgentAssignmentServiceImpl.this.agentAssignmentDao.findAll(), AgentAssignmentServiceImpl.this.cachedPlanManager, AgentAssignmentServiceImpl.this.deploymentProjectService));
        }
    };

    public AgentAssignmentServiceImpl(@NotNull AgentAssignmentDao agentAssignmentDao, @NotNull AuditLogService auditLogService, @NotNull TransactionTemplate transactionTemplate, @NotNull ProjectManager projectManager, @NotNull CachedPlanManager cachedPlanManager, @NotNull TextProvider textProvider, @NotNull EnvironmentService environmentService, @NotNull EventPublisher eventPublisher, @NotNull CapabilitySetManager capabilitySetManager, @NotNull CapabilityRequirementsMatcher capabilityRequirementsMatcher) {
        this.agentAssignmentDao = agentAssignmentDao;
        this.auditLogService = auditLogService;
        this.transactionTemplate = transactionTemplate;
        this.projectManager = projectManager;
        this.cachedPlanManager = cachedPlanManager;
        this.textProvider = textProvider;
        this.environmentService = environmentService;
        this.eventPublisher = eventPublisher;
        this.capabilitySetManager = capabilitySetManager;
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
    }

    @NotNull
    public AgentAssignment saveAgentAssignment(@NotNull AgentAssignment.ExecutorType executorType, long executorId, @NotNull AgentAssignment.ExecutableType executableType, long entityId) throws WebValidationException, AccessDeniedException {
        AgentAssignmentImpl agentAssignment = new AgentAssignmentImpl();
        agentAssignment.setExecutorId(executorId);
        agentAssignment.setExecutorType(executorType);
        agentAssignment.setExecutableId(entityId);
        agentAssignment.setExecutableType(executableType);
        this.validateAgentAssignment(agentAssignment);
        AgentAssignment save = this.agentAssignmentDao.save((AgentAssignment)agentAssignment);
        this.agentAssignmentMap.reset();
        this.logAssignmentUpdate(executableType, entityId, executorType, executorId, true);
        return save;
    }

    public void deleteExecutableAssignments(@NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutable> agentAssignments) throws AccessDeniedException {
        agentAssignments.forEach(this::validateDeletePermissions);
        if (agentAssignments.iterator().hasNext()) {
            Set<AgentAssignment> affectedExecutors = BambooIterables.stream(agentAssignments).map(agentAssignmentExecutor -> this.agentAssignmentDao.getAgentAssignment(agentAssignmentExecutor.getId())).filter(Objects::nonNull).collect(Collectors.toSet());
            this.agentAssignmentDao.removeAll(agentAssignments);
            this.agentAssignmentMap.reset();
            affectedExecutors.forEach(item -> this.logAssignmentUpdate(item.getExecutableType(), item.getExecutableId(), item.getExecutorType(), item.getExecutorId(), false));
            this.eventPublisher.publish((Object)new AgentAssignmentsUpdatedEvent(this));
        }
    }

    public void deleteAssignment(AgentAssignment.ExecutorType executorType, long executorId, AgentAssignment.ExecutableType executableType, long entityId) throws AccessDeniedException {
        List<AgentAssignmentService.AgentAssignmentExecutor> executors = Collections.singletonList(AgentAssignmentServiceHelper.asExecutor((AgentAssignment.ExecutorType)executorType, (long)executorId));
        List<AgentAssignmentService.AgentAssignmentExecutable> itemsForRemoval = this.getAgentAssignments().forExecutors(executors).stream().filter(executable -> executable.getExecutableType().equals((Object)executableType) && executable.getExecutableId() == entityId).collect(Collectors.toList());
        itemsForRemoval.forEach(this::validateDeletePermissions);
        if (!itemsForRemoval.isEmpty()) {
            this.agentAssignmentDao.removeAll(itemsForRemoval);
            this.agentAssignmentMap.reset();
            this.logAssignmentUpdate(executableType, entityId, executorType, executorId, false);
        }
    }

    public void deleteExecutorAssignments(@NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutor> agentAssignments) {
        if (agentAssignments.iterator().hasNext()) {
            Set<AgentAssignment> affectedExecutables = BambooIterables.stream(agentAssignments).map(agentAssignmentExecutor -> this.agentAssignmentDao.getAgentAssignment(agentAssignmentExecutor.getId())).filter(Objects::nonNull).collect(Collectors.toSet());
            this.agentAssignmentDao.removeAll(agentAssignments);
            this.agentAssignmentMap.reset();
            affectedExecutables.forEach(item -> this.logAssignmentUpdate(item.getExecutableType(), item.getExecutableId(), item.getExecutorType(), item.getExecutorId(), false));
            this.eventPublisher.publish((Object)new AgentAssignmentsUpdatedEvent(this));
        }
    }

    public AgentAssignmentMap getAgentAssignments() {
        return (AgentAssignmentMap)this.agentAssignmentMap.get();
    }

    public boolean isCapabilitiesMatch(BuildAgent agent, ImmutableJob job) {
        RequirementSet requirementSet = job.getEffectiveRequirementSet();
        return this.isCapabilitiesMatch((ImmutableRequirementSet)requirementSet, agent);
    }

    public boolean isCapabilitiesMatch(ElasticImageConfiguration image, ImmutableJob job) {
        RequirementSet requirementSet = job.getEffectiveRequirementSet();
        return this.isCapabilitiesMatch((ImmutableRequirementSet)requirementSet, image);
    }

    public boolean isCapabilitiesMatch(BuildAgent agent, long environmentId) {
        RequirementSet requirementSet = this.environmentService.getEnvironmentRequirementSet(environmentId);
        return this.isCapabilitiesMatch((ImmutableRequirementSet)requirementSet, agent);
    }

    public boolean isCapabilitiesMatch(ElasticImageConfiguration image, long environmentid) {
        RequirementSet requirementSet = this.environmentService.getEnvironmentRequirementSet(environmentid);
        return this.isCapabilitiesMatch((ImmutableRequirementSet)requirementSet, image);
    }

    private boolean isCapabilitiesMatch(ImmutableRequirementSet requirementSet, BuildAgent buildAgent) {
        CapabilitySet capabilitySet = CapabilitySetProvider.getAgentCapabilitySet(buildAgent);
        if (capabilitySet != null) {
            ReadOnlyCapabilitySet readOnlyCapabilitySet = buildAgent instanceof LocalBuildAgent ? this.capabilitySetManager.getCombinedCapabilitySet(capabilitySet, this.capabilitySetManager.getSharedLocalCapabilitySet()) : this.capabilitySetManager.getCombinedCapabilitySet(capabilitySet, this.capabilitySetManager.getSharedRemoteCapabilitySet());
            return this.capabilityRequirementsMatcher.matches(readOnlyCapabilitySet, requirementSet);
        }
        return false;
    }

    private boolean isCapabilitiesMatch(ImmutableRequirementSet requirementSet, ElasticImageConfiguration image) {
        ImageCapabilitySet capabilitySet = image.getCapabilitySet();
        return this.capabilityRequirementsMatcher.matches((ReadOnlyCapabilitySet)capabilitySet, requirementSet);
    }

    private void validateAgentAssignment(AgentAssignment agentAssignment) throws WebValidationException, AccessDeniedException {
        long entityId = agentAssignment.getExecutableId();
        switch (agentAssignment.getExecutableType()) {
            case PROJECT: {
                Project project = this.projectManager.getProjectById(entityId);
                BambooValidationUtils.validate(project != null, () -> this.textProvider.getText("agents.assignment.error.project.not.found", Collections.singletonList(String.valueOf(entityId))));
                this.validateUserHasProjectAdminPermissions(project);
                break;
            }
            case PLAN: {
                ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanById(entityId, ImmutableChain.class);
                BambooValidationUtils.validate(plan != null, () -> this.textProvider.getText("agents.assignment.error.plan.not.found", Collections.singletonList(String.valueOf(entityId))));
                this.validateUserHasPlanAdminPermissions(plan);
                break;
            }
            case JOB: {
                ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanById(entityId, ImmutableJob.class);
                BambooValidationUtils.validate(job != null, () -> this.textProvider.getText("agents.assignment.error.job.not.found", Collections.singletonList(String.valueOf(entityId))));
                this.validateUserHasPlanAdminPermissions(job.getParent());
                break;
            }
            case DEPLOYMENT_PROJECT: {
                DeploymentProject deploymentProject = this.deploymentProjectService.getDeploymentProject(entityId);
                BambooValidationUtils.validate(deploymentProject != null, () -> this.textProvider.getText("agents.assignment.error.deployment.project.not.found", Collections.singletonList(String.valueOf(entityId))));
                this.validateUserHasDeploymentProjectAdminPermission(deploymentProject);
                break;
            }
            case ENVIRONMENT: {
                Environment environment = this.environmentService.getEnvironment(entityId);
                BambooValidationUtils.validate(environment != null, () -> this.textProvider.getText("agents.assignment.error.deployment.environment.not.found", Collections.singletonList(String.valueOf(entityId))));
                this.validateUserHasEnvironmentAdminPermission(environment);
            }
        }
    }

    private void validateUserHasEnvironmentAdminPermission(Environment environment) {
        if (!environment.getOperations().isCanEdit()) {
            throw new AccessDeniedException(this.textProvider.getText("agents.assignment.error.deployment.environment.no.permissions"));
        }
    }

    private void validateUserHasDeploymentProjectAdminPermission(DeploymentProject deploymentProject) {
        if (!deploymentProject.getOperations().isCanEdit()) {
            throw new AccessDeniedException(this.textProvider.getText("agents.assignment.error.deployment.project.no.permissions"));
        }
    }

    private void validateUserHasPlanAdminPermissions(ImmutableChain plan) {
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, (ImmutablePlan)plan)) {
            throw new AccessDeniedException(this.textProvider.getText("agents.assignment.error.plan.no.permissions"));
        }
    }

    private void validateUserHasProjectAdminPermissions(@NotNull Project project) {
        if (!this.bambooPermissionManager.hasProjectPermission((Permission)BambooPermission.ADMINISTRATION, project)) {
            throw new AccessDeniedException(this.textProvider.getText("agents.assignment.error.project.no.permissions"));
        }
    }

    private void validateDeletePermissions(AgentAssignmentService.AgentAssignmentExecutable agentAssignment) {
        switch (agentAssignment.getExecutableType()) {
            case PROJECT: {
                Project project = this.projectManager.getProjectById(agentAssignment.getExecutableId());
                if (project == null) break;
                this.validateUserHasProjectAdminPermissions(project);
                break;
            }
            case PLAN: {
                ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanById(agentAssignment.getExecutableId(), ImmutableChain.class);
                if (plan == null) break;
                this.validateUserHasPlanAdminPermissions(plan);
                break;
            }
            case JOB: {
                ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanById(agentAssignment.getExecutableId(), ImmutableJob.class);
                if (job == null) break;
                this.validateUserHasPlanAdminPermissions(job.getParent());
                break;
            }
            case DEPLOYMENT_PROJECT: {
                DeploymentProject deploymentProject = this.deploymentProjectService.getDeploymentProject(agentAssignment.getExecutableId());
                if (deploymentProject == null) break;
                this.validateUserHasDeploymentProjectAdminPermission(deploymentProject);
                break;
            }
            case ENVIRONMENT: {
                Environment environment = this.environmentService.getEnvironment(agentAssignment.getExecutableId());
                if (environment == null) break;
                this.validateUserHasEnvironmentAdminPermission(environment);
            }
        }
    }

    @VisibleForTesting
    void logAssignmentUpdate(@Nullable AgentAssignment.ExecutableType executableType, @Nullable Long executableId, @Nullable AgentAssignment.ExecutorType executorType, @Nullable Long executorId, boolean added) {
        String executorDescription = executorType == null || executorId == null ? this.textProvider.getText("agents.assignment.audit.all.agents") : this.getExecutorLabel(executorType, executorId);
        String executableDescription = executableType == null || executableId == null ? this.textProvider.getText("agents.assignment.audit.all.executables") : this.getExecutableLabel(executableType, executableId);
        String action = added ? this.textProvider.getText("agents.assignment.audit.all.dedicated") : this.textProvider.getText("agents.assignment.audit.all.unassigned");
        this.logAtPlanLevelIfApplicable(executableType, executableId, executorDescription, action);
        this.logAtDeploymentProjectLevelIfApplicable(executableType, executableId, executorDescription, action);
        this.auditLogService.log(String.format("%s %s %s", executorDescription, action, executableDescription));
    }

    private void logAtPlanLevelIfApplicable(@Nullable AgentAssignment.ExecutableType executableType, @Nullable Long executableId, String executorDescription, String action) {
        if ((executableType == AgentAssignment.ExecutableType.PLAN || executableType == AgentAssignment.ExecutableType.JOB) && executableId != null) {
            Optional<PlanKey> executableKey;
            Optional<PlanKey> planKey;
            if (executableType == AgentAssignment.ExecutableType.PLAN) {
                executableKey = planKey = Optional.ofNullable(this.cachedPlanManager.getPlanById(executableId.longValue(), ImmutableChain.class)).map(PlanIdentifier::getPlanKey);
            } else {
                Optional<ImmutablePlan> jobById = Optional.ofNullable(this.cachedPlanManager.getPlanById(executableId.longValue(), ImmutableJob.class));
                executableKey = jobById.map(PlanIdentifier::getPlanKey);
                planKey = jobById.map(ImmutableJob::getParent).map(PlanIdentifier::getPlanKey);
            }
            planKey.ifPresent(key -> this.auditLogService.log(String.format("%s %s %s", executorDescription, action, executableKey.orElse((PlanKey)key)), (Key)key, AuditLogEntityType.PLAN));
        }
    }

    private void logAtDeploymentProjectLevelIfApplicable(@Nullable AgentAssignment.ExecutableType executableType, @Nullable Long executableId, String executorDescription, String action) {
        if ((executableType == AgentAssignment.ExecutableType.DEPLOYMENT_PROJECT || executableType == AgentAssignment.ExecutableType.ENVIRONMENT) && executableId != null) {
            Optional<DeploymentKeyImpl> entityKey;
            if (executableType == AgentAssignment.ExecutableType.DEPLOYMENT_PROJECT) {
                entityKey = Optional.of(new DeploymentKeyImpl(String.valueOf(executableId)));
            } else {
                Optional<Environment> environment = Optional.ofNullable(this.environmentService.getEnvironment(executableId.longValue()));
                entityKey = environment.map(InternalEnvironment::getDeploymentProjectId).map(projectId -> new DeploymentKeyImpl(projectId + "-" + executableId));
            }
            entityKey.ifPresent(key -> this.auditLogService.log(String.format("%s %s", executorDescription, action), (Key)key, AuditLogEntityType.DEPLOYMENT_PROJECT));
        }
    }

    @NotNull
    private String getExecutableLabel(@NotNull AgentAssignment.ExecutableType executableType, @NotNull Long executableId) {
        switch (executableType) {
            case PROJECT: {
                Project project = this.projectManager.getProjectById(executableId.longValue());
                if (project == null) break;
                return executableType.getLabel() + " " + project.getName() + " (" + project.getKey() + ")";
            }
            case PLAN: {
                ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanById(executableId.longValue(), ImmutableChain.class);
                if (plan == null) break;
                return executableType.getLabel() + " " + plan.getName() + " (" + plan.getPlanKey() + ")";
            }
            case JOB: {
                ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanById(executableId.longValue(), ImmutableJob.class);
                if (job == null) break;
                return executableType.getLabel() + " " + job.getName() + " (" + job.getPlanKey() + ")";
            }
            case DEPLOYMENT_PROJECT: {
                DeploymentProject deploymentProject = this.deploymentProjectService.getDeploymentProject(executableId.longValue());
                if (deploymentProject == null) break;
                return executableType.getLabel() + " " + deploymentProject.getName() + " (" + executableId + ")";
            }
            case ENVIRONMENT: {
                Environment environment = this.environmentService.getEnvironment(executableId.longValue());
                DeploymentProject deploymentProjectbyEnv = this.deploymentProjectService.getDeploymentProject(executableId.longValue());
                if (environment == null || deploymentProjectbyEnv == null) break;
                return executableType.getLabel() + " " + deploymentProjectbyEnv.getName() + " - " + environment.getName() + " (" + environment.getKey() + ")";
            }
        }
        return executableType.getLabel() + "(" + executableId + ")";
    }

    @NotNull
    private String getExecutorLabel(@NotNull AgentAssignment.ExecutorType executorType, @NotNull Long executorId) {
        if (executorType == AgentAssignment.ExecutorType.AGENT) {
            BuildAgent agent = this.agentManager.getAgent(executorId.longValue());
            return "Agent " + (agent == null ? "" : agent.getName() + "(" + executorId + ")");
        }
        ElasticImageConfiguration configurationById = this.elasticImageConfigurationManager.getElasticImageConfigurationById(executorId.longValue());
        return "Image " + (configurationById == null ? "" : configurationById.getConfigurationName() + "(" + executorId + ")");
    }
}

