/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.ImmutableRemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.security.auth.trustedapps.AtlassianIPMatcher;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ApprovedAuthenticationIpsCache {
    private static final Logger log = Logger.getLogger(ApprovedAuthenticationIpsCache.class);
    private final ResettableLazyReference<Predicate<String>> approvedAuthenticationIpPredicate;
    private final LoadingCache<InetAddress, Boolean> approvedAuthenticationIpsCache;

    public ApprovedAuthenticationIpsCache(final @NotNull Supplier<Collection<ImmutableRemoteAgentAuthentication>> approvedAuthenticationsSupplier, @NotNull Duration agentHeartbeatInterval) {
        this.approvedAuthenticationIpPredicate = new ResettableLazyReference<Predicate<String>>(){

            protected Predicate<String> create() throws Exception {
                Set ipPatterns = ((Collection)approvedAuthenticationsSupplier.get()).stream().map(RemoteAgentAuthentication::getIpPatterns).flatMap(Collection::stream).collect(Collectors.toSet());
                return !ipPatterns.isEmpty() ? arg_0 -> ((AtlassianIPMatcher)new AtlassianIPMatcher(ipPatterns)).match(arg_0) : ip -> false;
            }
        };
        this.approvedAuthenticationIpsCache = CacheBuilder.newBuilder().expireAfterAccess(2L * agentHeartbeatInterval.toNanos(), TimeUnit.NANOSECONDS).maximumSize(1000L).build(CacheLoader.from(inetAddress -> ((Predicate)this.approvedAuthenticationIpPredicate.get()).test(inetAddress.getHostAddress())));
    }

    public void reset() {
        this.approvedAuthenticationIpPredicate.reset();
        this.approvedAuthenticationIpsCache.invalidateAll();
    }

    public boolean isAuthenticatedAgentIp(@NotNull InetAddress inetAddress) {
        try {
            return (Boolean)this.approvedAuthenticationIpsCache.get((Object)inetAddress);
        }
        catch (ExecutionException e) {
            log.warn((Object)"Exception occurred when verifying IP address", (Throwable)e);
            return false;
        }
    }
}

