/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableAgentsMatrixImpl
implements ExecutableAgentsMatrix {
    private static final Logger log = Logger.getLogger(ExecutableAgentsMatrixImpl.class);
    private final SortedSet<BuildAgent> buildAgents = new TreeSet<BuildAgent>();
    private final SortedSetMultimap<String, BuildAgent> agentMap = TreeMultimap.create();
    private final Multimap<String, ElasticImageConfiguration> imageMap = HashMultimap.create();
    private final List<ElasticImageConfiguration> imageMatches = new ArrayList<ElasticImageConfiguration>();
    private int requirementCount;
    private final Set<ImmutableRequirement> requirementsMatchingNoAgents = new HashSet<ImmutableRequirement>();
    private final Set<ImmutableRequirement> requirementsMatchingNoImages = new HashSet<ImmutableRequirement>();
    private boolean elasticBambooEnabled;
    private final List<ElasticImageConfiguration> dedicatedNonMatchingImages = new ArrayList<ElasticImageConfiguration>();
    private final SortedSet<BuildAgent> dedicatedNonMatchingAgents = new TreeSet<BuildAgent>();

    public void put(@NotNull String key, @NotNull BuildAgent value) {
        this.agentMap.put((Object)key, (Object)value);
    }

    @Nullable
    public Collection<BuildAgent> getBuildAgents(@NotNull String key) {
        return this.agentMap.get((Object)key);
    }

    @NotNull
    public SortedSet<BuildAgent> getBuildAgents() {
        return this.buildAgents;
    }

    @NotNull
    public Collection<BuildAgent> getOnlineEnabledBuildAgents() {
        return Collections2.filter(this.buildAgents, BuildAgentPredicates::isActiveAndEnabled);
    }

    public void addBuildAgent(@NotNull BuildAgent buildAgent) {
        this.buildAgents.add(buildAgent);
    }

    public void addBuildAgents(@NotNull Collection<BuildAgent> buildAgents) {
        this.buildAgents.addAll(buildAgents);
    }

    public void addRequirementWithNoAgentMatch(@NotNull ImmutableRequirement requirement) {
        this.requirementsMatchingNoAgents.add(requirement);
    }

    public void addRequirementWithNoImageMatch(@NotNull ImmutableRequirement requirement) {
        this.requirementsMatchingNoImages.add(requirement);
    }

    @NotNull
    public Set<ImmutableRequirement> getRequirementsWithNoMatches() {
        if (this.elasticBambooEnabled) {
            return Sets.intersection(this.requirementsMatchingNoAgents, this.requirementsMatchingNoImages);
        }
        return this.requirementsMatchingNoAgents;
    }

    public void setElasticBambooEnabled(boolean elasticBambooEnabled) {
        this.elasticBambooEnabled = elasticBambooEnabled;
    }

    public boolean isElasticBambooEnabled() {
        return this.elasticBambooEnabled;
    }

    public int getRequirementCount() {
        return this.requirementCount;
    }

    public void setRequirementCount(int requirementCount) {
        this.requirementCount = requirementCount;
    }

    @NotNull
    public List<ElasticImageConfiguration> getImageMatches() {
        return this.imageMatches;
    }

    public void addImageMatch(@NotNull ElasticImageConfiguration imageMatch) {
        this.imageMatches.add(imageMatch);
    }

    @Nullable
    public Collection<ElasticImageConfiguration> getImageFromMatrix(@NotNull String requirementKey) {
        return this.imageMap.get((Object)requirementKey);
    }

    public void addImageToMatrix(@NotNull String requirementKey, @NotNull ElasticImageConfiguration image) {
        this.imageMap.put((Object)requirementKey, (Object)image);
    }

    public void addDedicatedNonMatchingImage(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        this.dedicatedNonMatchingImages.add(elasticImageConfiguration);
    }

    public void addDedicatedNonMatchingBuildAgent(@NotNull BuildAgent buildAgent) {
        this.dedicatedNonMatchingAgents.add(buildAgent);
    }

    @NotNull
    public SortedSet<BuildAgent> getDedicatedNonMatchingBuildAgents() {
        return this.dedicatedNonMatchingAgents;
    }

    @NotNull
    public List<ElasticImageConfiguration> getDedicatedNonMatchingImages() {
        return this.dedicatedNonMatchingImages;
    }
}

