/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.ImmutableRemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.atlassian.bamboo.buildqueue.dao.RemoteAgentAuthenticationDao;
import com.atlassian.bamboo.buildqueue.manager.ApprovedAuthenticationIpsCache;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.event.agent.AgentAuthorisationEvent;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.net.InetAddresses;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteAgentAuthenticationManagerImpl
implements RemoteAgentAuthenticationManager {
    private static final Logger log = Logger.getLogger(RemoteAgentAuthenticationManagerImpl.class);
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final RemoteAgentAuthenticationDao agentAuthenticationDao;
    private final EventPublisher eventPublisher;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Cache<UUID, ImmutableRemoteAgentAuthentication> pendingAuthentications;
    private final ResettableLazyReference<Collection<ImmutableRemoteAgentAuthentication>> approvedAuthentications;
    private final ApprovedAuthenticationIpsCache approvedAuthenticationIpsCache;

    @VisibleForTesting
    RemoteAgentAuthenticationManagerImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, final RemoteAgentAuthenticationDao agentAuthenticationDao, EventPublisher eventPublisher, Duration agentHeartbeatInterval, Duration pendingDuration) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.agentAuthenticationDao = agentAuthenticationDao;
        this.eventPublisher = eventPublisher;
        this.pendingAuthentications = CacheBuilder.newBuilder().expireAfterWrite(pendingDuration.toNanos(), TimeUnit.NANOSECONDS).maximumSize(500L).build();
        this.approvedAuthentications = new ResettableLazyReference<Collection<ImmutableRemoteAgentAuthentication>>(){

            protected Collection<ImmutableRemoteAgentAuthentication> create() throws Exception {
                return new ConcurrentLinkedQueue<ImmutableRemoteAgentAuthentication>((Collection)agentAuthenticationDao.getAllAuthentications().stream().map(RemoteAgentAuthentications.fromEntityJdk()).collect(CollectorsUtil.toImmutableList()));
            }
        };
        this.approvedAuthenticationIpsCache = new ApprovedAuthenticationIpsCache(() -> this.approvedAuthentications.get(), agentHeartbeatInterval);
    }

    public RemoteAgentAuthenticationManagerImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, RemoteAgentAuthenticationDao agentAuthenticationDao, EventPublisher eventPublisher, int agentHeartbeatIntervalSeconds) {
        this(administrationConfigurationAccessor, administrationConfigurationPersister, agentAuthenticationDao, eventPublisher, Duration.ofSeconds(agentHeartbeatIntervalSeconds), Duration.ofDays(1L));
    }

    @Override
    public boolean isRemoteAgentAuthenticationEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isRemoteAgentAuthenticationEnabled();
    }

    @Override
    public void setRemoteAgentAuthenticationEnabled(boolean isAuthenticationEnabled) throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        if (administrationConfiguration.isRemoteAgentAuthenticationEnabled() != isAuthenticationEnabled) {
            this.lock.writeLock().lock();
            try {
                administrationConfiguration.setRemoteAgentAuthenticationEnabled(isAuthenticationEnabled);
                this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
                this.pendingAuthentications.invalidateAll();
                this.approvedAuthentications.reset();
                this.approvedAuthenticationIpsCache.reset();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    @NotNull
    public Iterable<RemoteAgentAuthentication> getAllAuthentications() {
        return this.allAsList();
    }

    @Override
    @NotNull
    public Iterable<RemoteAgentAuthentication> getAuthentications(Predicate<RemoteAgentAuthentication> filter) {
        return Iterables.filter(this.getAllAuthentications(), filter);
    }

    @NotNull
    private ImmutableList<RemoteAgentAuthentication> allAsList() {
        this.lock.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.builder().addAll((Iterable)Ordering.natural().immutableSortedCopy(this.pendingAuthentications.asMap().values())).addAll((Iterable)Ordering.natural().immutableSortedCopy((Iterable)this.approvedAuthentications.get())).build();
            return immutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public RemoteAgentAuthentication getAuthentication(UUID uuid, String ip) {
        return this.allAsList().reverse().stream().filter(arg_0 -> RemoteAgentAuthentications.matching(uuid, ip).apply(arg_0)).findFirst().orElse(null);
    }

    @Override
    public RemoteAgentAuthentication getAuthentication(UUID uuid) {
        return this.allAsList().reverse().stream().filter(arg_0 -> RemoteAgentAuthentications.matching(uuid).apply(arg_0)).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Pair<RemoteAgentAuthentication, Boolean> getOrCreatePendingAuthentication(@NotNull UUID uuid, @NotNull String ip) {
        Preconditions.checkNotNull((Object)ip, (Object)"ip");
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        this.lock.writeLock().lock();
        try {
            RemoteAgentAuthentication existingApproved = ((Collection)this.approvedAuthentications.get()).stream().filter(arg_0 -> RemoteAgentAuthentications.matching(uuid, ip).apply(arg_0)).findFirst().orElse(null);
            if (existingApproved != null) {
                Pair pair = Pair.pair((Object)existingApproved, (Object)true);
                return pair;
            }
            ImmutableRemoteAgentAuthentication existingPending = (ImmutableRemoteAgentAuthentication)this.pendingAuthentications.getIfPresent((Object)uuid);
            if (existingPending != null && existingPending.matches(ip)) {
                Pair pair = Pair.pair((Object)existingPending, (Object)true);
                return pair;
            }
            ImmutableRemoteAgentAuthentication newPending = new ImmutableRemoteAgentAuthentication(uuid, ip);
            this.pendingAuthentications.put((Object)uuid, (Object)newPending);
            Pair pair = Pair.pair((Object)newPending, (Object)false);
            return pair;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void approveAuthentications(@NotNull Iterable<RemoteAgentAuthentication> authentications) {
        this.lock.writeLock().lock();
        try {
            this.pendingAuthentications.invalidateAll(Iterables.transform(authentications, RemoteAgentAuthentication::getUuid));
            ImmutableList entitiesToApprove = ImmutableList.copyOf((Iterable)Iterables.transform(authentications, RemoteAgentAuthentications.toEntity(this.agentAuthenticationDao)));
            this.agentAuthenticationDao.approve((Iterable<RemoteAgentAuthenticationEntity>)entitiesToApprove);
            this.approvedAuthentications.reset();
            this.approvedAuthenticationIpsCache.reset();
            for (int i = 0; i < entitiesToApprove.size(); ++i) {
                this.eventPublisher.publish((Object)new AgentAuthorisationEvent(this, true));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeAgentAuthentications(@NotNull Iterable<RemoteAgentAuthentication> authentications) {
        ImmutableList toRevoke = ImmutableList.copyOf((Iterable)Iterables.filter(authentications, RemoteAgentAuthentications.isApproved()));
        if (toRevoke.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.agentAuthenticationDao.deleteAll(Collections2.transform((Collection)toRevoke, RemoteAgentAuthentications.toEntity(this.agentAuthenticationDao)));
            ((Collection)this.approvedAuthentications.get()).removeAll(Collections2.filter((Collection)((Collection)this.approvedAuthentications.get()), RemoteAgentAuthentications.matchingUuidOf((Iterable<RemoteAgentAuthentication>)toRevoke)));
            this.approvedAuthenticationIpsCache.reset();
            for (int i = 0; i < toRevoke.size(); ++i) {
                this.eventPublisher.publish((Object)new AgentAuthorisationEvent(this, false));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIp(@NotNull UUID uuid, @NotNull String newIp) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        Preconditions.checkNotNull((Object)newIp, (Object)"newIp");
        this.lock.writeLock().lock();
        try {
            ImmutableRemoteAgentAuthentication old = (ImmutableRemoteAgentAuthentication)Iterables.find((Iterable)((Iterable)this.approvedAuthentications.get()), RemoteAgentAuthentications.matching(uuid), null);
            if (old == null || newIp.equals(old.getIp())) {
                return;
            }
            RemoteAgentAuthenticationEntity entity = (RemoteAgentAuthenticationEntity)RemoteAgentAuthentications.toEntity(this.agentAuthenticationDao).apply((Object)old);
            entity.setIp(newIp);
            this.agentAuthenticationDao.save(entity);
            ((Collection)this.approvedAuthentications.get()).remove(old);
            ((Collection)this.approvedAuthentications.get()).add(new ImmutableRemoteAgentAuthentication(entity));
            this.approvedAuthenticationIpsCache.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isAuthenticatedAgentIp(@NotNull String ip) {
        try {
            return this.isAuthenticatedAgentIp(InetAddresses.forString((String)ip));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Invalid IP address: " + ip));
            return false;
        }
    }

    @Override
    public boolean isAuthenticatedAgentIp(@NotNull InetAddress inetAddress) {
        return this.approvedAuthenticationIpsCache.isAuthenticatedAgentIp(inetAddress);
    }
}

