/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.caching.conversation;

import com.atlassian.bamboo.caching.conversation.Conversation;
import com.atlassian.bamboo.caching.conversation.ConversationStorageService;
import com.atlassian.bamboo.expirables.ExpiryHandler;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.utils.expirables.GuavaCacheLazyExpiryHandler;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class ConversationStorageServiceImpl
implements ConversationStorageService {
    private static final Duration EXPIRATION_TIME = Duration.ofHours(1L);
    private final Random random = new Random();
    private final Cache<Integer, Conversation<?>> cache = CacheBuilder.newBuilder().expireAfterAccess(EXPIRATION_TIME.toMillis(), TimeUnit.MILLISECONDS).build();

    public ConversationStorageServiceImpl(ExpiryTicker expiryTicker) {
        expiryTicker.register((ExpiryHandler)new GuavaCacheLazyExpiryHandler(this.cache));
    }

    @NotNull
    public synchronized <T> Conversation<T> createConversation(@NotNull T initialValue) {
        int conversationId = this.generateConversationId();
        Conversation conversation = new Conversation(conversationId, initialValue);
        this.cache.put((Object)conversationId, (Object)conversation);
        return conversation;
    }

    @NotNull
    public <T> Optional<Conversation<T>> getConversation(int conversationId, @NotNull Class<T> valueClass) {
        Conversation conversation = (Conversation)this.cache.getIfPresent((Object)conversationId);
        if (conversation != null) {
            Object value = conversation.getValue();
            Preconditions.checkState((boolean)Objects.equals(value.getClass(), valueClass), (String)"Value stored in conversation %s was not of type %s (actual class of stored object: %s)", (Object[])new Object[]{conversationId, valueClass.getCanonicalName(), value.getClass().getCanonicalName()});
            return Optional.of(conversation);
        }
        return Optional.empty();
    }

    public void deleteConversation(int conversationId) {
        this.cache.invalidate((Object)conversationId);
    }

    private int generateConversationId() {
        int conversationId;
        while (this.conversationExists(conversationId = this.random.nextInt(Integer.MAX_VALUE))) {
        }
        return conversationId;
    }

    private boolean conversationExists(int conversationId) {
        return this.cache.getIfPresent((Object)conversationId) != null;
    }
}

