/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.capability;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilityDao;
import com.atlassian.bamboo.capability.CapabilityManager;
import com.atlassian.bamboo.event.CapabilityRenamedEvent;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.RequirementUtils;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementPlanMapping;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class CapabilityManagerImpl
implements CapabilityManager {
    private static final Logger log = Logger.getLogger(CapabilityManagerImpl.class);
    @Lazy
    @Inject
    private AgentManager agentManager;
    @Lazy
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private BuildDefinitionManager buildDefinitionManager;
    private CapabilityDao capabilityDao;
    private CapabilitySetManager capabilitySetManager;

    public void renameCapability(@NotNull CapabilityType capabilityType, final @NotNull String oldCapabilityKey, @NotNull String newCapabilityLabel, final boolean override) {
        final String newCapabilityKey = capabilityType.getNewKeyFromLabel(oldCapabilityKey, newCapabilityLabel);
        List agentIds = this.capabilityDao.getAgentIdsFromKey(oldCapabilityKey);
        Iterator iterator = agentIds.iterator();
        while (iterator.hasNext()) {
            long agentId = (Long)iterator.next();
            BuildAgent agent = this.agentManager.getAgent(agentId);
            if (agent == null) continue;
            PipelineDefinition pipelineDefinition = agent.getDefinition();
            pipelineDefinition.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    throw new IllegalArgumentException("Elastic agent's capabilities should be manipulated via its image");
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                    Capability capabilityToMove = this.removeCapability(capabilitySet, newCapabilityKey, oldCapabilityKey, override);
                    if (capabilityToMove != null) {
                        log.info((Object)(capabilityToMove + " capability being moved"));
                        CapabilityManagerImpl.this.agentManager.savePipeline((PipelineDefinition)pipelineDefinition);
                    }
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                    Capability capabilityToMove = this.removeCapability(capabilitySet, newCapabilityKey, oldCapabilityKey, override);
                    if (capabilityToMove != null) {
                        log.info((Object)(capabilityToMove + " capability being moved"));
                        CapabilityManagerImpl.this.agentManager.savePipeline((PipelineDefinition)pipelineDefinition);
                    }
                }

                private Capability removeCapability(CapabilitySet capabilitySet, String newCapabilityKey2, String oldCapabilityKey2, boolean override2) {
                    Capability result = null;
                    if (capabilitySet != null) {
                        result = CapabilityManagerImpl.this.updateCapability(newCapabilityKey2, capabilitySet, oldCapabilityKey2, override2);
                    }
                    return result;
                }
            });
        }
        CapabilitySet localCapabilitySet = this.capabilitySetManager.getSharedLocalCapabilitySet();
        this.updateCapability(newCapabilityKey, localCapabilitySet, oldCapabilityKey, override);
        this.capabilitySetManager.saveCapabilitySet(localCapabilitySet);
        CapabilitySet remoteCapabilitySet = this.capabilitySetManager.getSharedRemoteCapabilitySet();
        this.updateCapability(newCapabilityKey, remoteCapabilitySet, oldCapabilityKey, override);
        this.capabilitySetManager.saveCapabilitySet(remoteCapabilitySet);
        List requirementPlanMappings = this.capabilityDao.getRequirementsFromKey(oldCapabilityKey);
        for (RequirementPlanMapping requirementPlanMapping : requirementPlanMappings) {
            Buildable plan = (Buildable)requirementPlanMapping.getRequirementAware().getWrappedObject();
            RequirementSet requirementSet = plan.getRequirementSet();
            boolean requirementUpdated = RequirementUtils.updateRequirement(requirementSet, newCapabilityKey, oldCapabilityKey, override);
            if (!requirementUpdated) continue;
            BuildDefinition buildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(plan.getPlanKey());
            List taskDefinitions = buildDefinition.getTaskDefinitions();
            String oldCapabilityLabel = capabilityType.getLabel(oldCapabilityKey);
            String keyToReplace = capabilityType.getCapabilityTypeSpecificTaskConfigurationKey();
            Optional<List<TaskDefinition>> newTaskDefs = TaskConfigurationUtils.replaceCapabilityLabelInTasks(taskDefinitions, keyToReplace, oldCapabilityLabel, newCapabilityLabel, oldCapabilityKey, newCapabilityKey);
            newTaskDefs.ifPresent(arg_0 -> ((BuildDefinition)buildDefinition).setTaskDefinitions(arg_0));
            this.buildDefinitionManager.savePlanAndDefinition((Plan)plan, buildDefinition);
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publish((Object)new CapabilityRenamedEvent(capabilityType, oldCapabilityKey, newCapabilityLabel, override));
        }
    }

    public void removeCapability(@NotNull Long agentId, @NotNull String capabilityKey) {
        this.removeCapabilities(agentId, Collections.singletonList(capabilityKey));
    }

    public void removeCapabilities(@NotNull Long agentId, final @NotNull Collection<String> capabilityKeys) {
        BuildAgent buildAgent = this.agentManager.getAgent(agentId.longValue());
        if (buildAgent == null) {
            log.warn((Object)("Requested removal of capability on a non existing agent " + agentId));
            return;
        }
        PipelineDefinition agent = buildAgent.getDefinition();
        agent.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                throw new IllegalArgumentException("Elastic agent has no capability to remove");
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                if (capabilitySet != null) {
                    capabilityKeys.forEach(arg_0 -> ((CapabilitySet)capabilitySet).removeCapability(arg_0));
                }
                CapabilityManagerImpl.this.agentManager.savePipeline((PipelineDefinition)pipelineDefinition);
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                if (capabilitySet != null) {
                    capabilityKeys.forEach(arg_0 -> ((CapabilitySet)capabilitySet).removeCapability(arg_0));
                }
                CapabilityManagerImpl.this.agentManager.savePipeline((PipelineDefinition)pipelineDefinition);
            }
        });
    }

    private Capability updateCapability(String newCapabilityKey, CapabilitySet capabilitySet, String oldCapabilityKey, boolean override) {
        Capability capabilityToMove = capabilitySet.getCapability(oldCapabilityKey);
        if (capabilityToMove != null) {
            Capability capabilityInTheWay = capabilitySet.getCapability(newCapabilityKey);
            if (capabilityInTheWay == null) {
                capabilityToMove.setKey(newCapabilityKey);
            } else if (override) {
                capabilitySet.removeCapability(newCapabilityKey);
                capabilityToMove.setKey(newCapabilityKey);
            } else {
                capabilitySet.removeCapability(oldCapabilityKey);
            }
            return capabilityToMove;
        }
        log.warn((Object)("Unable to find " + oldCapabilityKey + " to move."));
        return null;
    }

    public void setCapabilityDao(CapabilityDao capabilityDao) {
        this.capabilityDao = capabilityDao;
    }

    public void setCapabilitySetManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }
}

