/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.capability;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;

public class CapabilitySetProvider {
    private CapabilitySetProvider() {
    }

    public static CapabilitySet getAgentCapabilitySet(PipelineDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Null definition has been provided.");
        }
        MyPipelineDefinitionVisitor definitionVisitor = new MyPipelineDefinitionVisitor();
        definition.accept((PipelineDefinitionVisitor)definitionVisitor);
        return definitionVisitor.getCapabilitySet();
    }

    public static CapabilitySet getAgentCapabilitySet(BuildAgent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Incorrect agent has been provided.");
        }
        return CapabilitySetProvider.getAgentCapabilitySet(agent.getDefinition());
    }

    private static class MyPipelineDefinitionVisitor
    implements PipelineDefinitionVisitor {
        private CapabilitySet capabilitySet;

        private MyPipelineDefinitionVisitor() {
        }

        public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
            ElasticImageConfiguration elasticImageConfiguration = pipelineDefinition.getElasticImageConfiguration();
            this.capabilitySet = elasticImageConfiguration.getCapabilitySet();
        }

        public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            this.capabilitySet = pipelineDefinition.getCapabilitySet();
        }

        public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
            this.capabilitySet = pipelineDefinition.getCapabilitySet();
        }

        public CapabilitySet getCapabilitySet() {
            return this.capabilitySet;
        }
    }
}

