/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.capability;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityConfigurationManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultCapabilityConfigurationManager
implements CapabilityConfigurationManager {
    private static final Logger log = Logger.getLogger(DefaultCapabilityConfigurationManager.class);
    static final String BANDANA_KEY_PREFIX = DefaultCapabilityConfigurationManager.class.getCanonicalName() + ":";
    private final BandanaManager bandanaManager;

    public DefaultCapabilityConfigurationManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @NotNull
    public Configuration getConfiguration(@NotNull String capabilityKey) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_PREFIX + capabilityKey);
        if (o instanceof Configuration) {
            return (Configuration)o;
        }
        if (o == null) {
            return ConfigUtils.newConfiguration();
        }
        throw new RuntimeException("Object of class " + o.getClass() + " was read instead of Configuration");
    }

    public void setConfiguration(@NotNull String capabilityKey, @NotNull Configuration configuration) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_PREFIX + capabilityKey, (Object)configuration);
    }
}

