/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.chains.BuildContextFactory;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineHelper;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.repository.AbstractRepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContextBuilder;
import com.atlassian.bamboo.variable.VariableContextSnapshot;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class BuildContextFactoryImpl
implements BuildContextFactory {
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private BranchIntegrationService branchIntegrationService;
    @Inject
    private BuildContextBuilderFactory buildContextBuilderFactory;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private TaskManager taskManager;
    @Lazy
    @Inject
    private TestQuarantineManager testQuarantineManager;
    @Inject
    private VariableDefinitionManager variableDefinitionManager;
    @Inject
    private VariableContextBaselineDao variableContextBaselineDao;
    @Inject
    private TextProvider textProvider;
    @Inject
    private SecureTokenService secureTokenService;

    @NotNull
    public Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> createBuildContextsForJobs(@NotNull ImmutableChain chain, @NotNull BuildContext parentBuildContext) {
        return this.createBuildContextForJobsInternal(chain, null, parentBuildContext, PlanExecutionConfig.PlanExecutionType.REGULAR);
    }

    public void updateBuildContextWithChanges(BuildContext contextToUpdate, BuildChanges newBuildChanges) {
        contextToUpdate.setBuildChanges((BuildChanges)new BuildChangesImpl(newBuildChanges));
    }

    public boolean canRestartOrContinueBuild(@NotNull ImmutableChain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull PlanExecutionConfig planExecutionConfig) {
        if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN) {
            return true;
        }
        ArrayList<ChainStageResult> stages = new ArrayList<ChainStageResult>();
        planExecutionConfig.build();
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            if (!planExecutionConfig.isScheduledForExecution(chainStageResult.getName())) continue;
            stages.add(chainStageResult);
        }
        if (stages.isEmpty()) {
            return false;
        }
        return this.findNonExistentJobsForRestartOrContinueBuild(chain, chainResultsSummary, planExecutionConfig, stages).isEmpty();
    }

    private List<PlanKey> findNonExistentJobsForRestartOrContinueBuild(@NotNull ImmutableChain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull PlanExecutionConfig planExecutionConfig, @NotNull List<ChainStageResult> stagesToExecute) {
        if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN) {
            return Collections.emptyList();
        }
        ArrayList<PlanKey> nonExistentJobs = new ArrayList<PlanKey>();
        List chainJobs = chain.getAllJobs();
        for (ChainStageResult chainStageResult : stagesToExecute) {
            ArrayList resultVariablesFromCurrentStage = new ArrayList();
            for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                ImmutableJob plan = chainJobs.stream().filter(PlanPredicates.hasEqualPlanKey(buildResultsSummary.getPlanKey())).findFirst().orElse(null);
                if (!buildResultsSummary.isSuccessful()) {
                    if (plan != null && !plan.isMarkedForDeletion()) continue;
                    nonExistentJobs.add(buildResultsSummary.getPlanKey());
                    continue;
                }
                if (planExecutionConfig.getPlanExecutionType() != PlanExecutionConfig.PlanExecutionType.RESTART || !buildResultsSummary.isSuccessful() || !chainStageResult.isFinal() || !buildResultsSummary.isSuccessful() || plan != null && !plan.isMarkedForDeletion()) continue;
                nonExistentJobs.add(buildResultsSummary.getPlanKey());
            }
        }
        return nonExistentJobs;
    }

    @NotNull
    public Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> createBuildContextsForJobs(@NotNull ImmutableChain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull BuildContext parentBuildContext, @NotNull PlanExecutionConfig planExecutionConfig) {
        return this.createBuildContextForJobsInternal(chain, chainResultsSummary, parentBuildContext, planExecutionConfig.getPlanExecutionType());
    }

    @NotNull
    private Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> createBuildContextForJobsInternal(@NotNull ImmutableChain chain, @Nullable ChainResultsSummary chainResultsSummary, @NotNull BuildContext parentBuildContext, PlanExecutionConfig.PlanExecutionType planExecutionType) {
        LinkedHashMap<ImmutableChainStage, Map<ImmutableJob, BuildContext>> stageToJobMap = new LinkedHashMap<ImmutableChainStage, Map<ImmutableJob, BuildContext>>();
        for (ImmutableChainStage chainStage : chain.getStages()) {
            Map buildContextsForJobs = chainStage.getJobs().stream().filter(j -> !j.isSuspendedFromBuilding() && !j.isMarkedForDeletion()).collect(Collectors.toMap(job -> job, job -> this.createBuildContext(parentBuildContext, (ImmutableJob)job, (ResultsSummary)chainResultsSummary, planExecutionType, null), BambooCollectors.throwingMerger(), LinkedHashMap::new));
            stageToJobMap.put(chainStage, buildContextsForJobs);
        }
        return stageToJobMap;
    }

    @NotNull
    public Collection<BuildContext> createBuildContextsForRestartedOrContinuedBuild(@NotNull ImmutableChain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull BuildContext parentBuildContext, @NotNull PlanExecutionConfig planExecutionConfig) {
        ArrayList<ChainStageResult> stages = new ArrayList<ChainStageResult>();
        planExecutionConfig.build();
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            if (!planExecutionConfig.isScheduledForExecution(chainStageResult.getName())) continue;
            stages.add(chainStageResult);
        }
        if (stages.isEmpty()) {
            throw new IllegalStateException(this.textProvider.getText("build.context.factory.nothing.to.run"));
        }
        List<PlanKey> nonExistentJobs = this.findNonExistentJobsForRestartOrContinueBuild(chain, chainResultsSummary, planExecutionConfig, stages);
        if (!nonExistentJobs.isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ");
            nonExistentJobs.forEach(p -> joiner.add(p.getKey()));
            throw new IllegalStateException(this.textProvider.getText("build.context.factory.jobs.missing") + " " + joiner.toString());
        }
        ArrayList<BuildContext> contexts = new ArrayList<BuildContext>();
        this.resultsSummaryManager.logVariablesForSubstitution(parentBuildContext, (ResultsSummary)chainResultsSummary);
        List chainJobs = chain.getAllJobs();
        boolean restartableStageFound = false;
        ArrayList<VariableContextSnapshot> resultVariablesFromPreviousStage = null;
        for (ChainStageResult chainStageResult : stages) {
            boolean currentStageIsRestartable = false;
            ArrayList<VariableContextSnapshot> resultVariablesFromCurrentStage = new ArrayList<VariableContextSnapshot>();
            for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                ImmutableJob plan = chainJobs.stream().filter(PlanPredicates.hasEqualPlanKey(buildResultsSummary.getPlanKey())).findFirst().orElse(null);
                if (plan == null || plan.isMarkedForDeletion() || plan.isSuspendedFromBuilding()) continue;
                if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN || !buildResultsSummary.isSuccessful()) {
                    contexts.add(this.createBuildContext(parentBuildContext, plan, (ResultsSummary)buildResultsSummary, planExecutionConfig.getPlanExecutionType(), resultVariablesFromPreviousStage));
                    currentStageIsRestartable = true;
                    continue;
                }
                if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RESTART && restartableStageFound) {
                    if (!chainStageResult.isFinal() || !buildResultsSummary.isSuccessful()) continue;
                    contexts.add(this.createBuildContext(parentBuildContext, plan, (ResultsSummary)buildResultsSummary, planExecutionConfig.getPlanExecutionType(), resultVariablesFromPreviousStage));
                    continue;
                }
                if (planExecutionConfig.getPlanExecutionType() != PlanExecutionConfig.PlanExecutionType.RESTART || !buildResultsSummary.isSuccessful()) continue;
                Iterables.addAll(resultVariablesFromCurrentStage, (Iterable)buildResultsSummary.getResultVariables());
            }
            if (restartableStageFound || planExecutionConfig.getPlanExecutionType() != PlanExecutionConfig.PlanExecutionType.RESTART || !currentStageIsRestartable) continue;
            resultVariablesFromPreviousStage = resultVariablesFromCurrentStage;
            restartableStageFound = true;
        }
        return contexts;
    }

    @NotNull
    public BuildRepositoryChanges cloneBuildRepositoryChanges(@NotNull BuildRepositoryChanges buildRepositoryChanges) {
        return new BuildRepositoryChangesImpl(buildRepositoryChanges);
    }

    @NotNull
    public BuildRepositoryChanges buildChangesUnion(@NotNull BuildRepositoryChanges a, @NotNull BuildRepositoryChanges b) {
        BuildRepositoryChangesImpl union = new BuildRepositoryChangesImpl(a.getRepositoryId());
        union.getChanges().addAll(a.getChanges());
        union.getChanges().addAll(b.getChanges());
        union.setVcsRevisionKey(StringUtils.defaultString((String)b.getVcsRevisionKey(), (String)a.getVcsRevisionKey()));
        return union;
    }

    @NotNull
    private BuildContext createBuildContext(@NotNull BuildContext parentBuildContext, @NotNull ImmutableJob job, @Nullable ResultsSummary resultsSummary, @Nullable PlanExecutionConfig.PlanExecutionType executionType, @Nullable List<VariableContextSnapshot> resultVariablesFromPreviousStage) {
        SecureToken secureToken = this.secureTokenService.generate((Key)parentBuildContext.getBuildKey());
        List definitions = this.artifactSubscriptionManager.prepareArtifactDefinitionContexts(job, parentBuildContext, secureToken);
        List subscriptionsOfThisJob = this.artifactSubscriptionManager.prepareSubscriptionContexts(job, parentBuildContext, secureToken);
        Set<PlanRepositoryDefinition> jobRepositories = this.getJobRepositories(job);
        BuildChangesImpl buildChanges = new BuildChangesImpl(parentBuildContext.getBuildChanges());
        TriggerReason triggerReason = parentBuildContext.getTriggerReason().getChildTriggerReason(parentBuildContext, (ImmutablePlan)job);
        VariableContextBuilder variableContextBuilder = this.variableDefinitionManager.createVariableContextBuilder();
        ImmutableMap.Builder customBuildDataBuilder = ImmutableMap.builder();
        if (resultsSummary == null) {
            Map parentManualVariables = this.variableDefinitionManager.getSimpleVariableMapByType(parentBuildContext.getVariableContext(), VariableType.MANUAL);
            variableContextBuilder.addFromVariableContext(parentBuildContext.getVariableContext()).addPlanVariables((ImmutablePlan)job).addManualVariables(parentManualVariables);
        } else {
            VariableContextBaseline variableContextBaseline;
            Long variableContextBaselineId = resultsSummary.getVariableContextBaselineId();
            if (variableContextBaselineId != null && (variableContextBaseline = this.variableContextBaselineDao.getVariableContextBaseline(variableContextBaselineId.longValue())) != null) {
                variableContextBuilder.addFromSubstitutionContext((Iterable)variableContextBaseline.getVariables());
            }
            variableContextBuilder.addManualAndResultVariablesFromContext(parentBuildContext.getVariableContext());
            if (!CollectionUtils.isEmpty(resultVariablesFromPreviousStage)) {
                variableContextBuilder.addFromSubstitutionContext(resultVariablesFromPreviousStage);
            }
            triggerReason.updateCustomData((BambooCustomDataAware)resultsSummary);
            TestQuarantineHelper.remove((Map)resultsSummary.getCustomBuildData());
            customBuildDataBuilder.putAll(resultsSummary.getCustomBuildData());
        }
        boolean isQuarantineEnabled = this.administrationConfigurationAccessor.getAdministrationConfiguration().getQuarantineConfiguration().isEnabled();
        List currentlyQuarantinedTests = isQuarantineEnabled ? this.testQuarantineManager.getCurrentlyQuarantinedTests(job) : Collections.emptyList();
        TestQuarantineHelper.put((ImmutableMap.Builder)customBuildDataBuilder, (List)currentlyQuarantinedTests);
        Map runtimeArtifactHandlerConfiguration = this.artifactHandlersService.getRuntimeConfiguration();
        BuildDefinition buildDefinition = job.getBuildDefinition();
        buildDefinition.setBranchIntegrationConfiguration(parentBuildContext.getBuildDefinition().getBranchIntegrationConfiguration());
        ArtifactContextImpl artifactContext = new ArtifactContextImpl(secureToken, definitions, subscriptionsOfThisJob, this.featureManager.getBuildArtifactSizeLimit(), runtimeArtifactHandlerConfiguration);
        return this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)job).triggerReason(triggerReason).buildDefinition(buildDefinition).buildChanges((BuildChanges)buildChanges).parentBuildContext(parentBuildContext).artifactContext((ArtifactContext)artifactContext).variableContext(variableContextBuilder.buildContext()).customBuildData((Map)customBuildDataBuilder.build()).planRepositoryDefinitionMap(this.branchIntegrationService.getPlanRepositoryDefinitionMap((ImmutablePlan)job)).isOnceOff(parentBuildContext.isOnceOff()).isCustomBuild(parentBuildContext.isCustomBuild()).relevantRepositories(jobRepositories).build();
    }

    private Set<PlanRepositoryDefinition> getJobRepositories(ImmutableJob job) {
        HashSet<PlanRepositoryDefinition> relevantRepositories = new HashSet<PlanRepositoryDefinition>();
        for (TaskDefinition checkoutTask : BambooPluginUtils.filterTasks(job.getBuildDefinition().getTaskDefinitions(), "com.atlassian.bamboo.plugins.vcs:task.vcs.checkout")) {
            if (!checkoutTask.isEnabled()) continue;
            TaskModuleDescriptor taskDescriptor = (TaskModuleDescriptor)Preconditions.checkNotNull((Object)this.taskManager.getTaskDescriptor("com.atlassian.bamboo.plugins.vcs:task.vcs.checkout"), (Object)"Plugin com.atlassian.bamboo.plugins.vcs:task.vcs.checkout not found");
            AbstractRepositoryAwareTaskConfigurator taskConfigurator = (AbstractRepositoryAwareTaskConfigurator)Preconditions.checkNotNull((Object)taskDescriptor.getTaskConfigurator(), (Object)"Configurator for plugin com.atlassian.bamboo.plugins.vcs:task.vcs.checkout not found");
            relevantRepositories.addAll(taskConfigurator.getPlanRepositoriesUsedByTask(checkoutTask, job));
        }
        return relevantRepositories;
    }
}

