/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.progressbar.ProgressBar;
import com.atlassian.bamboo.progressbar.ProgressBarImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class BuildExecutionImpl
implements BuildExecution {
    private static final Logger log = Logger.getLogger(BuildExecutionImpl.class);
    private final StageExecution stageExecution;
    private final ChainBuildState buildState;

    BuildExecutionImpl(StageExecution stageExecution, ChainBuildState buildState) {
        this.stageExecution = stageExecution;
        this.buildState = buildState;
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.buildState.getBuildContext().getPlanResultKey();
    }

    public boolean isBuilding() {
        return this.buildState.isDispatched();
    }

    public boolean isCompleted() {
        return this.buildState.isFinalized();
    }

    public boolean isSuccessful() {
        return this.buildState.isSuccessful();
    }

    @NotNull
    public BuildState getBuildState() {
        return this.buildState.getState();
    }

    @NotNull
    public BuildContext getBuildContext() {
        return this.buildState.getBuildContext();
    }

    @NotNull
    public StageExecution getStageExecution() {
        return this.stageExecution;
    }

    @NotNull
    public BuildIdentifier getBuildIdentifier() {
        return this.buildState.getBuildContext();
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        return this.buildState.getBuildContext().getTriggerReason();
    }

    @NotNull
    public BuildChanges getBuildChanges() {
        return this.buildState.getBuildContext().getBuildChanges();
    }

    public Date getQueueTime() {
        return null;
    }

    public Date getStartTime() {
        return null;
    }

    public long getAverageDuration() {
        return this.buildState.getAverageDuration();
    }

    public long getElapsedTime() {
        return 0L;
    }

    @NotNull
    public ProgressBar getProgressBar() {
        return new ProgressBarImpl((ExecutionStatus)this);
    }

    public <T> T getConfigObject(String key, Class<T> aClass) {
        Object o = this.buildState.getBuildContext().getBuildDefinition().getConfigObjects().get(key);
        if (o != null) {
            Object t = Narrow.to(o, aClass);
            if (t == null) {
                throw new IllegalArgumentException("Could not get configuration object '" + key + "' of type '" + o.getClass() + "' as '" + aClass + "'");
            }
            return (T)t;
        }
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.stageExecution).append((Object)this.buildState).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildExecutionImpl)) {
            return false;
        }
        BuildExecutionImpl rhs = (BuildExecutionImpl)o;
        return new EqualsBuilder().append((Object)this.stageExecution, (Object)rhs.stageExecution).append((Object)this.buildState, (Object)rhs.buildState).isEquals();
    }
}

