/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class ChainBuildStateImpl
implements ChainBuildState {
    private static final Logger log = Logger.getLogger(ChainBuildStateImpl.class);
    private final BuildContext buildContext;
    private volatile BuildState finalState;
    private volatile ChainBuildState.State state = ChainBuildState.State.WAITING;
    private final StageState stageState;
    private long averageDuration;

    public ChainBuildStateImpl(@NotNull BuildContext buildContext, @NotNull StageState stageState, long averageDuration) {
        this.buildContext = buildContext;
        this.stageState = stageState;
        this.averageDuration = averageDuration;
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.buildContext.getPlanResultKey();
    }

    @NotNull
    public StageState getStageState() {
        return this.stageState;
    }

    public void markAsDispatched() {
        if (this.state != ChainBuildState.State.WAITING) {
            throw new IllegalStateException("State cannot transition from " + this.state + " to " + ChainBuildState.State.DISPATCHED);
        }
        this.state = ChainBuildState.State.DISPATCHED;
    }

    public void markAsFinalized(BuildState buildState) {
        this.state = ChainBuildState.State.FINALIZED;
        this.finalState = buildState;
        log.debug((Object)("Build " + this.getPlanResultKey() + " has been finalized. Success: " + Boolean.toString(this.isSuccessful())));
    }

    public boolean isWaiting() {
        return this.state == ChainBuildState.State.WAITING;
    }

    public boolean isDispatched() {
        return this.state == ChainBuildState.State.DISPATCHED;
    }

    public boolean isFinalized() {
        return this.state == ChainBuildState.State.FINALIZED;
    }

    public boolean isSuccessful() {
        return this.finalState != null && this.finalState == BuildState.SUCCESS;
    }

    public boolean isFailed() {
        return this.finalState != null && this.finalState == BuildState.FAILED;
    }

    public BuildState getState() {
        return this.finalState == null ? BuildState.UNKNOWN : this.finalState;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    @NotNull
    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public void addResultVariablesFromPreviousStages(Map<String, VariableDefinitionContext> resultVariables) {
        if (!resultVariables.isEmpty()) {
            HashMap<String, VariableDefinitionContext> variables = new HashMap<String, VariableDefinitionContext>();
            variables.putAll(this.getBuildContext().getVariableContext().getOriginalVariables());
            variables.putAll(resultVariables);
            this.getBuildContext().setVariableContext((VariableContext)new VariableContextImpl(variables));
        }
    }

    public void setPublishedChainArtifactsInfo(@NotNull Multimap<String, Artifact> publishedChainArtifacts) {
        this.getBuildContext().getArtifactContext().setSharedArtifactsFromPreviousStages(publishedChainArtifacts);
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.getPlanResultKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChainBuildStateImpl)) {
            return false;
        }
        ChainBuildStateImpl rhs = (ChainBuildStateImpl)o;
        return new EqualsBuilder().append((Object)this.getPlanResultKey(), (Object)rhs.getPlanResultKey()).isEquals();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("finalState", (Object)this.finalState).toString();
    }
}

