/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.ExecutionContext;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.progressbar.ProgressBar;
import com.atlassian.bamboo.progressbar.ProgressBarImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainExecutionImpl
implements ChainExecution {
    private static final Logger log = Logger.getLogger(ChainExecutionImpl.class);
    private final ChainState chainState;
    private final Map<StageState, StageExecution> stageExecutions;
    private final ProgressBar progressBar;

    ChainExecutionImpl(ChainState chainState, Map<StageState, StageExecution> stageExecutions) {
        this.chainState = chainState;
        this.stageExecutions = stageExecutions;
        this.progressBar = new ProgressBarImpl((ExecutionStatus)this);
    }

    @NotNull
    public BuildIdentifier getBuildIdentifier() {
        return this.chainState.getBuildContext();
    }

    @NotNull
    public BuildChanges getBuildChanges() {
        return this.chainState.getBuildContext().getBuildChanges();
    }

    @NotNull
    public String getName() {
        return this.chainState.getName();
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.chainState.getPlanResultKey();
    }

    @NotNull
    public List<StageExecution> getStages() {
        return ImmutableList.copyOf(this.stageExecutions.values());
    }

    public boolean isCompleted() {
        return this.chainState.isCompleted();
    }

    public boolean isSuccessful() {
        return this.chainState.isSuccessful();
    }

    public boolean isFailed() {
        return this.chainState.isFailed();
    }

    public boolean isStopping() {
        return this.chainState.isStopping();
    }

    public boolean isStopRequested() {
        return this.chainState.isStopRequested();
    }

    @NotNull
    public ExecutionContext getExecutionContext() {
        return this.chainState.getExecutionContext();
    }

    @NotNull
    public Date getQueueTime() {
        return this.chainState.getQueueTime();
    }

    public Date getStartTime() {
        return this.chainState.getStartDate();
    }

    public long getElapsedTime() {
        return this.chainState.getElapsedTime();
    }

    public long getAverageDuration() {
        return this.chainState.getAverageDuration();
    }

    @Nullable
    public StageExecution getCurrentStage() {
        StageState stageState = this.chainState.getCurrentStage();
        if (stageState != null) {
            return this.stageExecutions.get(stageState);
        }
        return null;
    }

    @NotNull
    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        return this.chainState.getBuildContext().getTriggerReason();
    }

    public <T> T getConfigObject(String key, Class<T> aClass) {
        Object o = this.chainState.getBuildContext().getBuildDefinition().getConfigObjects().get(key);
        if (o != null) {
            Object t = Narrow.to(o, aClass);
            if (t == null) {
                throw new IllegalArgumentException("Could not get configuration object '" + key + "' of type '" + o.getClass() + "' as '" + aClass + "'");
            }
            return (T)t;
        }
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.chainState).append((Object)this.getPlanResultKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChainExecutionImpl)) {
            return false;
        }
        ChainExecutionImpl rhs = (ChainExecutionImpl)o;
        return new EqualsBuilder().append((Object)this.chainState, (Object)rhs.chainState).append((Object)this.getPlanResultKey(), (Object)rhs.getPlanResultKey()).isEquals();
    }
}

