/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.ConditionalBuildDetectionAction;
import com.atlassian.bamboo.build.PlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.build.UnconditionalBuildDetectionAction;
import com.atlassian.bamboo.build.UserInitiatedBuildDetectionAction;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.test.TriggerConditionsAwareBuildDetectionAction;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.BuildContextFactory;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.BuildExecutionImpl;
import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionImpl;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainExecutionRequestResult;
import com.atlassian.bamboo.chains.ChainExecutionRequestResultImpl;
import com.atlassian.bamboo.chains.ChainPluginSupport;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.ChainStateCreationRequestResult;
import com.atlassian.bamboo.chains.ChainStateCreationRequestResultImpl;
import com.atlassian.bamboo.chains.ChainStateFactory;
import com.atlassian.bamboo.chains.ChainStateResult;
import com.atlassian.bamboo.chains.JobExecutionManager;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.StageExecutionImpl;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.chains.XStreamChainStatePersisterImpl;
import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummaryImpl;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.event.BuildFinishedEvent;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.event.ChainDeletedEvent;
import com.atlassian.bamboo.event.ChainStartedEvent;
import com.atlassian.bamboo.event.FailedStageRestartEvent;
import com.atlassian.bamboo.event.HibernateEventListenerAspect;
import com.atlassian.bamboo.event.JobCompletedEvent;
import com.atlassian.bamboo.event.ManualStageResumedEvent;
import com.atlassian.bamboo.event.StageCompletedEvent;
import com.atlassian.bamboo.event.StoppedOnManualStageEvent;
import com.atlassian.bamboo.event.TrustedKeyVerificationFailedEvent;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persister.XStreamObjectPersister;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionConfigImpl;
import com.atlassian.bamboo.plan.PlanExecutionLockService;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanStatePersisterService;
import com.atlassian.bamboo.plan.TriggerableInternalKeyImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.plan.branch.MergeResult;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryBranchDeletedException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.DebugUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoint;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoints;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.CopyOnWriteMap;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

@ServerSideOnly
public class ChainExecutionManagerImpl
implements ChainExecutionManager {
    private static final Logger log = Logger.getLogger(ChainExecutionManagerImpl.class);
    public static final String MERGE_DIR = "mergeWorkspace";
    private static final String CHAIN_STATE_DIRECTORY = "chain-state";
    @Inject
    @Lazy
    private ArtifactLinkManager artifactLinkManager;
    @Inject
    @Lazy
    private ChainResultManager chainResultManager;
    private final PlanStatePersisterService planStatePersisterService;
    private final JobExecutionManager buildContextExecutor;
    private final ChainStateFactory chainStateFactory;
    private final BuildContextFactory buildContextFactory;
    private final EventPublisher eventPublisher;
    private final ChainPluginSupport chainPluginSupport;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final AuthorCreatorService authorCreatorService;
    private final ResultsSummaryManager resultsSummaryManager;
    private final CustomVariableContext customVariableContext;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final ConcurrentMap<PlanResultKey, ChainState> chainStateMap = CopyOnWriteMap.builder().newHashMap();
    private final Function<PlanResultKey, ManagedLock> chainStateLock = ManagedLocks.weakManagedLockFactory();
    private final BuildDirectoryManager buildDirectoryManager;
    private final VcsBranchIntegrationHelper branchIntegrationHelper;
    private final PlanExecutionLockService planExecutionLockService;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private final StorageTagService storageTagService;
    private final XStreamObjectPersister<PlanResultKey, ChainState> chainStatePersister;
    private final CachedPlanManager cachedPlanManager;
    private final PlanBranchPullRequestService planBranchPullRequestService;

    public ChainExecutionManagerImpl(PlanStatePersisterService planStatePersisterService, JobExecutionManager buildContextExecutor, ChainStateFactory chainStateFactory, BuildContextFactory buildContextFactory, EventPublisher eventPublisher, ChainPluginSupport chainPluginSupport, ErrorUpdateHandler errorUpdateHandler, AuthorCreatorService authorCreatorService, ResultsSummaryManager resultsSummaryManager, BuildDirectoryManager buildDirectoryManager, VcsBranchIntegrationHelper branchIntegrationHelper, CustomVariableContext customVariableContext, PlanExecutionLockService planExecutionLockService, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, XStreamFactory xStreamFactory, CachedPlanManager cachedPlanManager, VcsRepositoryManager vcsRepositoryManager, StorageTagService storageTagService, PlanBranchPullRequestService planBranchPullRequestService) {
        this.planStatePersisterService = planStatePersisterService;
        this.buildContextExecutor = buildContextExecutor;
        this.chainStateFactory = chainStateFactory;
        this.buildContextFactory = buildContextFactory;
        this.eventPublisher = eventPublisher;
        this.chainPluginSupport = chainPluginSupport;
        this.errorUpdateHandler = errorUpdateHandler;
        this.authorCreatorService = authorCreatorService;
        this.resultsSummaryManager = resultsSummaryManager;
        this.buildDirectoryManager = buildDirectoryManager;
        this.branchIntegrationHelper = branchIntegrationHelper;
        this.customVariableContext = customVariableContext;
        this.planExecutionLockService = planExecutionLockService;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.cachedPlanManager = cachedPlanManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.storageTagService = storageTagService;
        this.planBranchPullRequestService = planBranchPullRequestService;
        File chainStateDirectory = new File(SystemDirectory.getServerStateDirectory(), CHAIN_STATE_DIRECTORY);
        this.chainStatePersister = new XStreamChainStatePersisterImpl(xStreamFactory.createCompactXStream(), BambooFileUtils.createDirectorySupplier(chainStateDirectory));
    }

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @NotNull
    public ChainExecutionRequestResult start(@NotNull ImmutableChain chain, @NotNull ConditionalBuildDetectionAction buildDetectionAction) {
        return this.tryStartChainState(chain, errors -> this.createNewChainState(chain, (BuildDetectionAction)buildDetectionAction, errors, () -> ((ConditionalBuildDetectionAction)buildDetectionAction).createBuildContext()));
    }

    @NotNull
    public ChainExecutionRequestResult delayedStart(final @NotNull ImmutableChain chain, final @NotNull UnconditionalBuildDetectionAction buildDetectionAction, final @NotNull ChainState chainState) {
        return this.tryStartChainState(chain, new ChainStateProvider(){

            @Override
            @Nullable
            public ChainState getChainState(ErrorCollection errors) throws Exception {
                BuildContext buildContext = chainState.getBuildContext();
                try {
                    BuildChanges buildChanges = buildDetectionAction.performDelayedChangeDetection(buildContext);
                    if (!errors.hasAnyErrors() && buildChanges != null) {
                        buildContext.setBuildChanges(buildChanges);
                        Map stageToJobMap = ChainExecutionManagerImpl.this.buildContextFactory.createBuildContextsForJobs(chain, buildContext);
                        ChainExecutionManagerImpl.this.createMissingAuthors(stageToJobMap);
                        ChainExecutionManagerImpl.this.resultsSummaryManager.updateResultSummaryWithBuildChanges(buildContext);
                        for (ChainBuildState jobState : chainState.getChainBuildStates()) {
                            if (jobState == null) continue;
                            BuildContext jobBuildContext = jobState.getBuildContext();
                            ChainExecutionManagerImpl.this.buildContextFactory.updateBuildContextWithChanges(jobBuildContext, buildContext.getBuildChanges());
                            ChainExecutionManagerImpl.this.resultsSummaryManager.updateResultSummaryWithBuildChanges(jobBuildContext);
                        }
                        return chainState;
                    }
                    return null;
                }
                catch (HostKeyVerificationException e) {
                    this.handleHostKeyVerificationException(errors, buildContext, e);
                    throw e;
                }
                catch (RepositoryBranchDeletedException e) {
                    PlanResultKey planResultKey = buildContext.getPlanResultKey();
                    ChainExecutionManagerImpl.this.stop(planResultKey);
                    return null;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof HostKeyVerificationException) {
                        this.handleHostKeyVerificationException(errors, buildContext, (HostKeyVerificationException)e.getCause());
                        throw e;
                    }
                    PlanResultKey planResultKey = buildContext.getPlanResultKey();
                    ChainExecutionManagerImpl.this.logException(ChainExecutionManagerImpl.this.getI18nResolver().getText("chain.execution.error", new Serializable[]{planResultKey}), e, buildContext, errors);
                    ChainExecutionManagerImpl.this.stop(planResultKey);
                    throw e;
                }
            }

            private void handleHostKeyVerificationException(ErrorCollection errors, BuildContext buildContext, HostKeyVerificationException e) {
                PlanResultKey planResultKey = buildContext.getPlanResultKey();
                TrustedKey trustedKey = e.getTrustedKey();
                if (trustedKey == null) {
                    ChainExecutionManagerImpl.this.logException(ChainExecutionManagerImpl.this.getI18nResolver().getText("chain.execution.error.host.key.verification", new Serializable[]{planResultKey}), (Exception)((Object)e), buildContext, errors);
                } else {
                    HashMap<String, String> exceptionDetails = new HashMap<String, String>();
                    exceptionDetails.put("host", trustedKey.getHost());
                    exceptionDetails.put("key", trustedKey.getKey());
                    ChainExecutionManagerImpl.this.logException(ChainExecutionManagerImpl.this.getI18nResolver().getText("chain.execution.error.host.key.verification", new Serializable[]{planResultKey}), (Exception)((Object)e), exceptionDetails, buildContext, errors);
                }
                ChainExecutionManagerImpl.this.stop(planResultKey);
                ChainExecutionManagerImpl.this.eventPublisher.publish((Object)new TrustedKeyVerificationFailedEvent(this));
            }
        });
    }

    private I18nResolver getI18nResolver() {
        return (I18nResolver)ComponentAccessor.I18N_RESOLVER.get();
    }

    @NotNull
    private ChainExecutionRequestResult tryStartChainState(@NotNull ImmutableChain chain, ChainStateProvider chainStateProvider) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ChainExecution chainExecution = null;
        ChainState chainState = null;
        try {
            chainState = chainStateProvider.getChainState((ErrorCollection)errors);
        }
        catch (Throwable e) {
            PlanKey planKey = chain.getPlanKey();
            this.logException("Plan '" + planKey + "' could not be started. Exception: " + e.getMessage(), e, planKey, (ErrorCollection)errors);
            InvalidRepositoryException.handleInvalidRepositoryIfAppropriate(planKey, e, (ErrorCollection)errors, this.eventPublisher, null);
        }
        if (chainState != null) {
            this.saveState(chainState);
            PlanResultKey planResultKey = chainState.getPlanResultKey();
            if (!errors.hasAnyErrors()) {
                try {
                    if (!chainState.getBuildContext().isOnceOff()) {
                        this.planVcsRevisionHistoryService.markBuildStarted(chainState.getBuildContext());
                    }
                    chainExecution = this.createChainExecution(chainState);
                    this.chainPluginSupport.chainStarted(chainExecution, chainState.getBuildContext());
                    this.eventPublisher.publish((Object)new ChainStartedEvent(this, chainState.getPlanResultKey(), chainState.getBuildContext()));
                    this.execute(chainState);
                }
                catch (Exception e) {
                    this.logException("Plan '" + planResultKey + "' started but a fatal error occurred", e, chainState.getBuildContext(), (ErrorCollection)errors);
                    this.stop(planResultKey);
                }
            } else {
                log.info((Object)errors.addErrorMessage("Plan '" + chain.getKey() + "' did not start. Errors found"));
                this.stop(planResultKey);
            }
        } else {
            log.debug((Object)errors.addErrorMessage("Plan '" + chain.getKey() + "' did not start"));
        }
        return new ChainExecutionRequestResultImpl((ErrorCollection)errors, chainExecution);
    }

    private void clearAllChainExecutionsForPlanKey(@NotNull PlanKey planKey) {
        ImmutableSet running = ImmutableSet.copyOf(this.chainStateMap.keySet());
        for (PlanResultKey runningForChain : running.stream().filter(input -> input.getPlanKey().equals((Object)planKey)).collect(Collectors.toList())) {
            this.chainStateMap.remove(runningForChain);
            this.removeSavedState(runningForChain);
            File serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory((ResultKey)runningForChain);
            BambooPathUtils.deleteQuietly((Path)serverSideWorkingDir.toPath());
        }
    }

    @EventListener
    public void onChainRemoved(@NotNull ChainDeletedEvent chainDeletedEvent) {
        this.clearAllChainExecutionsForPlanKey(chainDeletedEvent.getPlanKey());
    }

    @EventListener
    public void onVcsSyncStartedTimingPoint(@NotNull BuildTimingPoints.VcsSyncStarted event) {
        DebugUtils.logTimingPoint("onVcsSyncStartedTimingPoint", (BuildTimingPoint)event, log);
        ChainState chainState = this.findReferenceForJobResultKey(event.getPlanResultKey());
        if (chainState != null) {
            chainState.setStartDate(new Date());
            this.chainResultManager.updateStateToInProgress(chainState.getBuildContext().getPlanResultKey(), chainState.getStartDate());
        }
    }

    @EventListener
    public void onExecutionStartedTimingPoint(@NotNull BuildTimingPoints.ExecutionStarted event) {
        DebugUtils.logTimingPoint("onExecutionStartedTimingPoint", (BuildTimingPoint)event, log);
        ChainState chainState = this.findReferenceForJobResultKey(event.getPlanResultKey());
        if (chainState != null) {
            chainState.setStartDate(new Date());
            this.chainResultManager.updateStateToInProgress(chainState.getBuildContext().getPlanResultKey(), chainState.getStartDate());
        }
    }

    @EventListener
    @HibernateEventListenerAspect
    public void onBuildFinished(final BuildFinishedEvent buildFinishedEvent) {
        final PlanResultKey jobResultKey = buildFinishedEvent.getPlanResultKey();
        final BuildContext buildContext = buildFinishedEvent.getBuildContext();
        final ChainState chainState = this.findReferenceForJobResultKey(jobResultKey);
        if (chainState != null) {
            PlanKey chainKey = PlanKeys.getChainKeyFromJobKey((PlanKey)jobResultKey.getPlanKey());
            ImmutablePlan chain = this.cachedPlanManager.getPlanByKey(chainKey);
            if (chain == null) {
                this.clearAllChainExecutionsForPlanKey(chainKey);
                return;
            }
            this.chainStateLock.apply(jobResultKey).withLock(new Runnable(){

                @Override
                public void run() {
                    final ChainBuildState buildState = chainState.getChainBuildState(jobResultKey);
                    ChainExecution chainExecution = ChainExecutionManagerImpl.this.createChainExecution(chainState);
                    if (buildState != null) {
                        StageExecution stageExecution = ChainExecutionManagerImpl.this.getStageExecution(chainExecution, buildState.getStageState());
                        BuildExecution buildExecution = ChainExecutionManagerImpl.this.getBuildExecution(stageExecution, buildState);
                        ChainExecutionManagerImpl.this.chainPluginSupport.buildCompleted(buildExecution);
                    }
                    ((ManagedLock)ChainExecutionManagerImpl.this.chainStateLock.apply(chainState.getPlanResultKey())).withLock(new Runnable(){

                        @Override
                        public void run() {
                            int numberOfFailedJobs = ChainExecutionManagerImpl.this.getNumberOfPreviouslyFailedJobs(chainState);
                            if (buildState != null) {
                                buildState.markAsFinalized(buildFinishedEvent.getBuildState());
                                if (buildContext != null) {
                                    chainState.updateVariableContext(buildContext.getVariableContext());
                                }
                            }
                            ChainExecutionManagerImpl.this.eventPublisher.publish((Object)new JobCompletedEvent(this, jobResultKey, buildFinishedEvent.getBuildState(), buildFinishedEvent.getLifeCycleState(), numberOfFailedJobs));
                            ChainExecutionManagerImpl.this.saveState(chainState);
                            ChainExecutionManagerImpl.this.execute(chainState);
                        }
                    });
                }
            });
        }
    }

    @NotNull
    public ChainStateCreationRequestResult createChainStateNoDetection(@NotNull ImmutableChain chain, @NotNull UnconditionalBuildDetectionAction buildDetectionAction) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ChainState chainState = null;
        try {
            chainState = this.createNewChainState(chain, (BuildDetectionAction)buildDetectionAction, (ErrorCollection)errors, () -> ((UnconditionalBuildDetectionAction)buildDetectionAction).generateResultWithoutChanges());
            if (chainState == null || errors.hasAnyErrors()) {
                String notStartedMessage = "Plan '" + chain.getKey() + "' did not start";
                errors.addErrorMessage(notStartedMessage);
            }
        }
        catch (Throwable e) {
            PlanKey planKey = chain.getPlanKey();
            this.logException("Plan '" + planKey + "' could not be started. " + e.getMessage(), e, planKey, (ErrorCollection)errors);
        }
        return new ChainStateCreationRequestResultImpl((ErrorCollection)errors, chainState);
    }

    @Nullable
    private ChainState createNewChainState(@NotNull ImmutableChain chain, @NotNull BuildDetectionAction buildDetectionAction, @NotNull ErrorCollection errors, @NotNull BuildDetectionResultCreationCallback buildDetectionResultCreationCallback) throws IOException {
        boolean stopExecution;
        TriggerConditionsAwareBuildDetectionAction triggerAware = (TriggerConditionsAwareBuildDetectionAction)Narrow.downTo((Object)buildDetectionAction, TriggerConditionsAwareBuildDetectionAction.class);
        if (triggerAware != null && (stopExecution = this.chainPluginSupport.shouldStopExecution(chain, triggerAware.getTriggerConditionsConfiguration()))) {
            String notStartedMessage = "Plan '" + chain.getKey() + "' did not start. A plugin requested that it be stopped";
            log.debug((Object)notStartedMessage);
            errors.addErrorMessage(notStartedMessage);
            return null;
        }
        PlanExecutionConfig planExecutionConfig = null;
        UserInitiatedBuildDetectionAction userInitiatedBuildDetectionAction = (UserInitiatedBuildDetectionAction)Narrow.to((Object)buildDetectionAction, UserInitiatedBuildDetectionAction.class);
        if (userInitiatedBuildDetectionAction != null) {
            planExecutionConfig = userInitiatedBuildDetectionAction.getPlanExecutionConfig();
        }
        BuildDetectionResult buildDetectionResult = buildDetectionResultCreationCallback.createBuildDetectionResult();
        errors.addErrorCollection(buildDetectionResult.getErrorCollection());
        BuildContext chainBuildContext = buildDetectionResult.getBuildContext();
        if (chainBuildContext != null) {
            ChainStateResult chainResultState;
            this.addCustomBuildData(chain, chainBuildContext);
            try {
                if (planExecutionConfig == null || planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.ENFORCE_MANUAL_AS_AUTOMATIC || planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.REGULAR) {
                    Map stageToJobMap = this.buildContextFactory.createBuildContextsForJobs(chain, chainBuildContext);
                    this.createMissingAuthors(stageToJobMap);
                    if (planExecutionConfig == null) {
                        planExecutionConfig = new PlanExecutionConfigImpl(PlanExecutionConfig.PlanExecutionType.REGULAR);
                    }
                    planExecutionConfig.setChain(chain).build();
                    chainResultState = this.chainResultManager.create(chainBuildContext, stageToJobMap, (Collection)planExecutionConfig.getStagesToExecute());
                } else {
                    ChainResultsSummary chainResultSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainBuildContext.getPlanResultKey(), ChainResultsSummary.class);
                    if (chainResultSummary == null) {
                        throw new IllegalArgumentException("Unable to find Result Summary for:" + chainBuildContext.getPlanResultKey());
                    }
                    if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN) {
                        Map stageToJobMap = this.buildContextFactory.createBuildContextsForJobs(chain, chainResultSummary, chainBuildContext, planExecutionConfig);
                        chainResultState = this.chainResultManager.updateForRerunBuild(chainBuildContext, stageToJobMap, planExecutionConfig);
                    } else {
                        Collection buildContexts = this.buildContextFactory.createBuildContextsForRestartedOrContinuedBuild(chain, chainResultSummary, chainBuildContext, planExecutionConfig);
                        chainResultState = this.chainResultManager.updateForContinuedBuild(chainBuildContext, buildContexts, planExecutionConfig);
                    }
                }
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                errors.addErrorMessage(ex.getMessage());
                log.error((Object)"", (Throwable)ex);
                return null;
            }
            errors.addErrorCollection(chainResultState.getErrors());
            if (!errors.hasAnyErrors()) {
                ChainState chainState = this.chainStateFactory.create((PlanIdentifier)chain, planExecutionConfig, chainBuildContext, chainResultState);
                this.registerChainStateReference(chainState);
                return chainState;
            }
            log.debug((Object)("Errors found. " + chain.getPlanKey() + " not built"));
            return null;
        }
        log.debug((Object)("No changes found. " + chain.getPlanKey() + " not built"));
        return null;
    }

    private void addCustomBuildData(@NotNull ImmutableChain chain, BuildContext chainBuildContext) {
        Map customBuildData = chainBuildContext.getBuildResult().getCustomBuildData();
        customBuildData.put("plan.storageTag", this.storageTagService.getChainStorageTag(chain.getPlanKey()).toString());
        if (chain instanceof ImmutableChainBranch) {
            log.debug((Object)"Chain is chain branch. Check if it has PR");
            Optional pullRequestOpt = this.planBranchPullRequestService.findForChainBranch(chain.getPlanKey());
            if (pullRequestOpt.isPresent()) {
                log.debug((Object)"Found PR, adding it to custom build data");
                VcsPullRequest pullRequest = ((PlanBranchPullRequest)pullRequestOpt.get()).getVcsPullRequest();
                customBuildData.put("repository.pr.key", pullRequest.getKey());
                customBuildData.put("repository.pr.sourceBranch", pullRequest.getSource());
                customBuildData.put("repository.pr.targetBranch", pullRequest.getTarget());
            } else {
                log.debug((Object)("No pr found for branch " + chain.getPlanKey()));
            }
        }
    }

    private void createMissingAuthors(Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> stageToJobMap) {
        HashSet<AuthorContext> authors = new HashSet<AuthorContext>();
        for (Map<ImmutableJob, BuildContext> jobBuildContextMap : stageToJobMap.values()) {
            for (Map.Entry<ImmutableJob, BuildContext> entry : jobBuildContextMap.entrySet()) {
                BuildContext context = entry.getValue();
                for (CommitContext commit : context.getBuildChanges().getChanges()) {
                    authors.add(commit.getAuthorContext());
                }
            }
        }
        this.authorCreatorService.createMissingAuthors(authors);
    }

    private void execute(final @NotNull ChainState chainState) {
        this.chainStateLock.apply(chainState.getPlanResultKey()).withLock(new Runnable(){

            @Override
            public void run() {
                StageState lastCurrentStage = chainState.getCurrentStage();
                StageState possibleNextState = chainState.getNextStage();
                ChainExecution chainExecution = ChainExecutionManagerImpl.this.createChainExecution(chainState);
                BranchIntegrationConfiguration branchIntegrationConfiguration = chainState.getBuildContext().getBuildDefinition().getBranchIntegrationConfiguration();
                if (lastCurrentStage == null && branchIntegrationConfiguration.isEnabled()) {
                    log.info((Object)"Doing the merge before the first stage");
                    ChainExecutionManagerImpl.this.doVcsMerge(chainState);
                    if (chainState.isFailed()) {
                        StageState currentStage = lastCurrentStage;
                        chainState.finishStopping();
                        ChainExecutionManagerImpl.this.finaliseChainStateIfChainExecutionHasCompleted(chainState, chainExecution, currentStage);
                        return;
                    }
                }
                if (lastCurrentStage == null && possibleNextState == null) {
                    if (!chainState.isGoingToStopAtManualStage() && chainState.isSuccessful() && branchIntegrationConfiguration.isEnabled() && branchIntegrationConfiguration.isPushEnabled()) {
                        ChainExecutionManagerImpl.this.pushTheMergedCommit(chainState, branchIntegrationConfiguration.getStrategy());
                    }
                    StageState currentStage = lastCurrentStage;
                    chainState.finishStopping();
                    ChainExecutionManagerImpl.this.finaliseChainStateIfChainExecutionHasCompleted(chainState, chainExecution, currentStage);
                    return;
                }
                if (lastCurrentStage == null) {
                    StageState currentStage = chainState.proceedToNextStage(ChainExecutionManagerImpl.this.artifactLinkManager.findArtifactsByChainResultKey(chainState.getPlanResultKey()), true);
                    ChainExecutionManagerImpl.this.dispatchBuildsInCurrentStage(currentStage, chainExecution, chainState, lastCurrentStage);
                } else if (lastCurrentStage.isCompleted()) {
                    StageExecution stageExecution = ChainExecutionManagerImpl.this.getStageExecution(chainExecution, lastCurrentStage);
                    PlanKey planKey = chainExecution.getPlanResultKey().getPlanKey();
                    ImmutableChain chain = (ImmutableChain)ChainExecutionManagerImpl.this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class);
                    if (chain != null) {
                        StageState currentStage;
                        boolean endthis;
                        String stageName = stageExecution.getName();
                        ImmutableChainStage stageDefinition = chain.getStages().stream().filter(input -> input.getName().equalsIgnoreCase(stageName)).findFirst().orElse(null);
                        ChainExecutionManagerImpl.this.chainPluginSupport.stageCompleted(stageExecution, lastCurrentStage.getChainStageResultId().longValue(), chainState.getBuildContext());
                        ChainExecutionManagerImpl.this.eventPublisher.publish((Object)new StageCompletedEvent(ChainExecutionManagerImpl.this, chainExecution, stageExecution, stageDefinition));
                        boolean bl = endthis = possibleNextState == null;
                        if (!endthis) {
                            currentStage = chainState.proceedToNextStage(ChainExecutionManagerImpl.this.artifactLinkManager.findArtifactsByChainResultKey(chainState.getPlanResultKey()), lastCurrentStage.isSuccessful());
                            if (currentStage == null) {
                                endthis = true;
                            } else {
                                ChainExecutionManagerImpl.this.dispatchBuildsInCurrentStage(currentStage, chainExecution, chainState, lastCurrentStage);
                            }
                        }
                        if (endthis) {
                            if (lastCurrentStage.isSuccessful() && chainState.isGoingToStopAtManualStage()) {
                                ChainExecutionManagerImpl.this.eventPublisher.publish((Object)new StoppedOnManualStageEvent(ChainExecutionManagerImpl.this, chainExecution, stageExecution));
                                ChainExecutionManagerImpl.this.chainPluginSupport.stoppedOnManualStage(stageExecution, lastCurrentStage.getChainStageResultId().longValue(), chainState.getBuildContext());
                            }
                            if (!chainState.isGoingToStopAtManualStage() && chainState.isSuccessful() && branchIntegrationConfiguration.isEnabled() && branchIntegrationConfiguration.isPushEnabled()) {
                                ChainExecutionManagerImpl.this.pushTheMergedCommit(chainState, branchIntegrationConfiguration.getStrategy());
                            }
                            currentStage = lastCurrentStage;
                            chainState.finishStopping();
                            ChainExecutionManagerImpl.this.finaliseChainStateIfChainExecutionHasCompleted(chainState, chainExecution, currentStage);
                            return;
                        }
                    } else {
                        ChainExecutionManagerImpl.this.clearAllChainExecutionsForPlanKey(planKey);
                        return;
                    }
                }
                ChainExecutionManagerImpl.this.saveState(chainState);
            }
        });
    }

    private int getNumberOfPreviouslyFailedJobs(ChainState chainState) {
        int failedJobs = 0;
        for (StageState stageState : chainState.getStages()) {
            for (ChainBuildState chainBuildState : stageState.getBuilds()) {
                if (!chainBuildState.isFailed()) continue;
                ++failedJobs;
            }
        }
        return failedJobs;
    }

    public void stop(@NotNull PlanResultKey planResultKey) {
        ChainState stateReference = (ChainState)this.chainStateMap.get(planResultKey);
        this.stop(stateReference);
    }

    public void stop(@NotNull PlanKey planKey) {
        for (ChainState stateReference : this.getChainStateReferencesForPlanKey(planKey)) {
            this.stop(stateReference);
        }
    }

    private void stop(final @Nullable ChainState chainState) {
        if (chainState != null) {
            log.debug((Object)("Stopping " + chainState.getPlanResultKey()));
            PlanResultKey planResultKey = chainState.getPlanResultKey();
            this.chainStateLock.apply(planResultKey).withLock(new Runnable(){

                @Override
                public void run() {
                    chainState.markAsStopping();
                    boolean atLeastOneBuildStoppedOrUnqueued = false;
                    for (ChainBuildState buildState : chainState.getChainBuildStates()) {
                        PlanResultKey buildResultKey = buildState.getPlanResultKey();
                        boolean buildStoppedOrUnqueued = ChainExecutionManagerImpl.this.buildContextExecutor.requestStop(buildResultKey);
                        atLeastOneBuildStoppedOrUnqueued |= buildStoppedOrUnqueued;
                        if (!buildState.isWaiting() || buildStoppedOrUnqueued) continue;
                        buildState.markAsFinalized(BuildState.UNKNOWN);
                    }
                    if (!atLeastOneBuildStoppedOrUnqueued) {
                        chainState.finishStopping();
                        ChainExecutionManagerImpl.this.finaliseChainStateIfChainExecutionHasCompleted(chainState);
                    }
                }
            });
        }
    }

    public boolean isActive(@NotNull PlanKey planKey) {
        return !this.getChainStateReferencesForPlanKey(planKey).isEmpty();
    }

    public boolean isExecuting(@NotNull PlanKey planKey) {
        Collection<ChainState> chainStates = this.getChainStateReferencesForPlanKey(planKey);
        for (ChainState chainState : chainStates) {
            if (chainState.getStartDate() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isExecuting(@NotNull PlanResultKey planResultKey) {
        ChainState chainState = (ChainState)this.chainStateMap.get(planResultKey);
        return chainState != null && chainState.getStartDate() != null;
    }

    @NotNull
    public List<ChainExecution> getExecutingChains(@NotNull PlanKey planKey) {
        ArrayList<ChainExecution> chainExecutions = new ArrayList<ChainExecution>();
        for (ChainState chainState : this.getChainStateReferencesForPlanKey(planKey)) {
            chainExecutions.add(this.createChainExecution(chainState));
        }
        return chainExecutions;
    }

    @Nullable
    public ChainExecution getChainExecution(@NotNull PlanResultKey planResultKey) {
        ChainState chainState = (ChainState)this.chainStateMap.get(planResultKey);
        if (chainState != null) {
            return this.createChainExecution(chainState);
        }
        return null;
    }

    @Nullable
    public BuildExecution getJobExecution(@NotNull PlanResultKey planResultKey) {
        ChainState chainState = this.findReferenceForJobResultKey(planResultKey);
        if (chainState != null) {
            ChainExecution chainExecution = this.createChainExecution(chainState);
            for (StageExecution se : chainExecution.getStages()) {
                for (BuildExecution be : se.getBuilds()) {
                    if (!be.getPlanResultKey().equals((Object)planResultKey)) continue;
                    return be;
                }
            }
        }
        return null;
    }

    public int numberOfChainsExecuting(@NotNull PlanKey planKey) {
        return this.getChainStateReferencesForPlanKey(planKey).size();
    }

    public void logChainExecutionState() {
        if (log.isTraceEnabled()) {
            for (Map.Entry result : this.chainStateMap.entrySet()) {
                PlanResultKey resultKey = (PlanResultKey)result.getKey();
                ChainState chainState = (ChainState)result.getValue();
                log.trace((Object)("Plan: " + resultKey + ", state: " + (chainState.isCompleted() ? "Completed" : "Running")));
            }
        } else {
            log.debug((Object)("There are still " + this.chainStateMap.size() + " plans executing."));
        }
    }

    public int numberOfChainsExecuting() {
        return this.chainStateMap.size();
    }

    public Set<PlanResultKey> restoreState(Set<PlanResultKey> chainResultsToRestore) {
        HashSet<PlanResultKey> result = new HashSet<PlanResultKey>();
        for (Pair pair : this.chainStatePersister.loadAndRemoveAll()) {
            if (!chainResultsToRestore.contains(pair.getFirst())) continue;
            try {
                HashSet<PlanResultKey> newResults = new HashSet<PlanResultKey>();
                ChainState chainState = (ChainState)pair.getSecond();
                for (StageState stageState : chainState.getStages()) {
                    for (ChainBuildState buildState : stageState.getBuilds()) {
                        if (buildState.isFinalized()) continue;
                        ResultsSummary rs = this.resultsSummaryManager.getResultsSummary(buildState.getPlanResultKey());
                        if (rs == null) {
                            log.warn((Object)("Build " + buildState.getPlanResultKey() + " in progress but not in db"));
                            buildState.markAsFinalized(BuildState.FAILED);
                            continue;
                        }
                        if (LifeCycleState.isFinalized((LifeCycleState)rs.getLifeCycleState())) {
                            BuildState effectiveState = rs.getBuildState() == BuildState.SUCCESS ? BuildState.UNKNOWN : rs.getBuildState();
                            log.info((Object)("Build " + buildState.getPlanResultKey() + " in progress but finished in db. Updating runtime state to " + effectiveState));
                            buildState.markAsFinalized(effectiveState);
                            if (rs.getBuildState() != BuildState.SUCCESS) continue;
                            this.resultsSummaryManager.updateLifeCycleState(rs, LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
                            continue;
                        }
                        if (LifeCycleState.isPending((LifeCycleState)rs.getLifeCycleState()) && buildState.isDispatched()) continue;
                        newResults.add(buildState.getPlanResultKey());
                    }
                }
                this.chainStateMap.put((PlanResultKey)pair.getFirst(), chainState);
                this.eventPublisher.publish((Object)new ChainStartedEvent(this, chainState.getPlanResultKey(), chainState.getBuildContext()));
                this.execute((ChainState)pair.getSecond());
                result.addAll(newResults);
            }
            catch (Exception e) {
                this.logException("State of plan '" + pair.getFirst() + "' was being restored but a fatal error occurred", e, ((ChainState)pair.getSecond()).getBuildContext(), (ErrorCollection)new SimpleErrorCollection());
                this.stop((PlanResultKey)pair.getFirst());
            }
        }
        return result;
    }

    private void dispatchBuildsInCurrentStage(StageState currentStage, ChainExecution chainExecution, ChainState chainState, StageState lastCurrentStage) {
        if (currentStage != null) {
            this.planStatePersisterService.persistChainState(chainState);
            StageExecution stageExecution = this.getStageExecution(chainExecution, currentStage);
            if (currentStage.isWaiting()) {
                if (lastCurrentStage == null) {
                    if (chainState.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RESTART) {
                        this.chainPluginSupport.failedStageRestarted(stageExecution, chainState.getBuildContext());
                        this.eventPublisher.publish((Object)new FailedStageRestartEvent(this, chainExecution, stageExecution));
                    } else if (chainState.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.CONTINUE) {
                        this.chainPluginSupport.manualStageResumed(stageExecution, chainState.getBuildContext());
                        this.eventPublisher.publish((Object)new ManualStageResumedEvent(this, chainExecution, stageExecution));
                    }
                }
                this.chainPluginSupport.stageStarted(stageExecution, chainState.getBuildContext());
            }
            for (ChainBuildState buildState : this.getExecutableChainBuildStates(currentStage)) {
                this.chainPluginSupport.buildStarted(stageExecution, buildState.getBuildContext());
                buildState.markAsDispatched();
                log.info((Object)("Build " + buildState.getPlanResultKey() + " has been dispatched"));
                buildState.getBuildContext().getVariableContext().addLocalVariable("buildFailed", Boolean.toString(chainState.isFailed()));
                this.buildContextExecutor.requestExecution(buildState.getBuildContext());
            }
        }
    }

    private void registerChainStateReference(ChainState chainState) {
        PlanResultKey resultKey = chainState.getPlanResultKey();
        log.debug((Object)("registerChainStateReference " + resultKey));
        this.chainStateMap.putIfAbsent(resultKey, chainState);
    }

    private void finaliseChainStateIfChainExecutionHasCompleted(ChainState chainState) {
        StageState currentStage = chainState.getCurrentStage();
        ChainExecution chainExecution = this.createChainExecution(chainState);
        this.finaliseChainStateIfChainExecutionHasCompleted(chainState, chainExecution, currentStage);
    }

    private void doVcsMerge(ChainState chainState) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext((CommonContext)chainState.getBuildContext());
        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, this.doVcsMergeRunnable(chainState));
    }

    private Runnable doVcsMergeRunnable(ChainState chainState) {
        return () -> {
            log.debug((Object)"Performing VCS Merge");
            BuildContext buildContext = chainState.getBuildContext();
            BranchIntegrationConfiguration branchIntegrationConfiguration = chainState.getBuildContext().getBuildDefinition().getBranchIntegrationConfiguration();
            MergeResultSummaryImpl mergeResult = new MergeResultSummaryImpl(branchIntegrationConfiguration.getStrategy());
            if (branchIntegrationConfiguration.isPushEnabled()) {
                mergeResult.setPushState(MergeResultState.TO_BE_ATTEMPTED);
            } else {
                mergeResult.setPushState(MergeResultState.NOT_ATTEMPTED);
            }
            chainState.setMergeResult((MergeResultSummary)mergeResult);
            PlanRepositoryDefinition defaultRepositoryDef = BuildContextHelper.getDefaultPlanRepositoryDefinition(buildContext);
            if (defaultRepositoryDef == null) {
                mergeResult.setMergeState(MergeResultState.FAILED);
                mergeResult.setFailureReason("No default repository specified - check your configuration.");
            } else {
                VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDef.getPluginKey());
                if (moduleDescriptor == null || !moduleDescriptor.supportsMerging()) {
                    mergeResult.setMergeState(MergeResultState.FAILED);
                    mergeResult.setFailureReason("Default repository does not support merging - check your configuration.");
                } else {
                    mergeResult.setMergeState(MergeResultState.IN_PROGRESS);
                    PlanResultKey planResultKey = buildContext.getPlanResultKey();
                    File mergeDir = new File(this.buildDirectoryManager.getServerSideTaskWorkingDirectory((ResultKey)planResultKey), MERGE_DIR);
                    try {
                        mergeDir.mkdirs();
                        BuildChanges buildChanges = buildContext.getBuildChanges();
                        VcsBranch integrationBranch = this.branchIntegrationHelper.getIntegrationVcsBranch(buildContext);
                        mergeResult.setIntegrationRepositoryBranchName(this.customVariableContext.substituteString(integrationBranch.getName()));
                        mergeResult.setIntegrationBranchVcsKey(buildChanges.getIntegrationBranchVcsRevision());
                        mergeResult.setIntegrationRepositoryId(buildChanges.getIntegrationRepositoryId());
                        mergeResult.setBranchTargetVcsKey(buildChanges.getVcsRevisionKey(defaultRepositoryDef.getId()));
                        mergeResult.setBranchName(this.customVariableContext.substituteString(defaultRepositoryDef.getBranch().getVcsBranch().getName()));
                        MergeResult tmp = this.branchIntegrationHelper.merge(buildContext, (VcsRepositoryData)defaultRepositoryDef, moduleDescriptor, integrationBranch, mergeDir, null);
                        mergeResult.setMergeState(MergeResultState.SUCCESS);
                        mergeResult.setEmptyMerge(tmp.isEmptyMerge());
                        chainState.setMergeWorkingCopy(tmp.getMergeWorkingCopy());
                    }
                    catch (Exception e) {
                        mergeResult.setMergeState(MergeResultState.FAILED);
                        RepositoryException repositoryException = (RepositoryException)((Object)((Object)Narrow.downTo((Object)e, RepositoryException.class)));
                        if (repositoryException != null) {
                            String stderr = repositoryException.getStderr() != null ? repositoryException.getStderr() : e.getMessage();
                            String message = "Merge command error: " + stderr;
                            mergeResult.setFailureReason(message);
                            log.warn((Object)message);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Showing full stack trace", (Throwable)e);
                            }
                        } else {
                            String message = "Exception during merge: " + e.getMessage();
                            mergeResult.setFailureReason(message);
                            log.warn((Object)message, (Throwable)e);
                        }
                        log.warn((Object)("Unable to merge " + planResultKey + " merge result: " + (Object)((Object)mergeResult)));
                    }
                    finally {
                        if (MergeResultState.SUCCESS != mergeResult.getMergeState()) {
                            BambooPathUtils.deleteQuietly((Path)mergeDir.toPath());
                        }
                    }
                }
            }
            if (MergeResultState.SUCCESS != mergeResult.getMergeState()) {
                log.error((Object)("Failed to merge for plan-result: " + chainState.getPlanResultKey() + ". " + mergeResult.getFailureReason()));
                chainState.getBuildContext().getBuildResult().addBuildErrors((List)Lists.newArrayList((Object[])new String[]{mergeResult.getFailureReason()}));
            }
        };
    }

    private void pushTheMergedCommit(ChainState chainState, BranchIntegrationStrategy strategy) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext((CommonContext)chainState.getBuildContext());
        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, this.pushTheMergedCommitRunnable(chainState, strategy));
    }

    private Runnable pushTheMergedCommitRunnable(final ChainState chainState, final BranchIntegrationStrategy strategy) {
        return () -> {
            final PlanResultKey planResultKey = chainState.getPlanResultKey();
            BuildContext buildContext = chainState.getBuildContext();
            final MergeResultSummary mergeResult = chainState.getMergeResult();
            Preconditions.checkState((mergeResult != null ? 1 : 0) != 0, (Object)"Merge result should not be null");
            Preconditions.checkState((chainState.getMergeWorkingCopy() != null ? 1 : 0) != 0, (Object)"Merge working copy should not be null");
            if (MergeResultState.SUCCESS == mergeResult.getMergeState() && !mergeResult.isEmptyMerge()) {
                mergeResult.setPushState(MergeResultState.IN_PROGRESS);
                try {
                    PlanRepositoryDefinition repositoryToPushTo;
                    PlanRepositoryDefinition defaultRepositoryDef = BuildContextHelper.getDefaultPlanRepositoryDefinition(buildContext);
                    long integrationRepositoryId = buildContext.getBuildChanges().getIntegrationRepositoryId();
                    PlanRepositoryDefinition integrationRepositoryDef = (PlanRepositoryDefinition)buildContext.getVcsRepositoryMap().get(integrationRepositoryId);
                    PlanRepositoryDefinition planRepositoryDefinition = repositoryToPushTo = strategy == BranchIntegrationStrategy.GATE_KEEPER ? integrationRepositoryDef : defaultRepositoryDef;
                    if (repositoryToPushTo == null) {
                        mergeResult.setPushState(MergeResultState.FAILED);
                        mergeResult.setFailureReason("Target repository not specified - check your configuration.");
                    } else {
                        final VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryToPushTo.getPluginKey());
                        if (moduleDescriptor != null && moduleDescriptor.supportsRemoteUpdates()) {
                            String commitRevision = (String)this.planExecutionLockService.lock((TriggerableInternalKey)new TriggerableInternalKeyImpl(planResultKey.getPlanKey()), AcquisitionPolicy.IMMEDIATE, (Callable)new Callable<String>(){

                                @Override
                                public String call() throws Exception {
                                    String commitSuffix = strategy == BranchIntegrationStrategy.BRANCH_UPDATER ? " (from " + mergeResult.getIntegrationRepositoryBranchName() + ":" + mergeResult.getIntegrationBranchVcsKey() + ")" : (strategy == BranchIntegrationStrategy.GATE_KEEPER ? " (from " + mergeResult.getBranchName() + ":" + mergeResult.getBranchTargetVcsKey() + ")" : "");
                                    String commitMessage = ChainExecutionManagerImpl.this.branchIntegrationHelper.getIntegrationCommitMessage(null) + commitSuffix;
                                    UpdatingVcsWorkingCopyManager remoteUpdater = (UpdatingVcsWorkingCopyManager)Narrow.downTo((Object)moduleDescriptor.getWorkingCopyManager(), UpdatingVcsWorkingCopyManager.class);
                                    VcsWorkingCopy workingCopyAfterCommit = remoteUpdater.commitLocal(chainState.getMergeWorkingCopy(), (VcsRepositoryData)repositoryToPushTo, commitMessage);
                                    VcsWorkingCopy workingCopyAfterPush = remoteUpdater.updateRemote(workingCopyAfterCommit, (VcsRepositoryData)repositoryToPushTo, commitMessage);
                                    ChainExecutionManagerImpl.this.planVcsRevisionHistoryService.markChangeDetectionCompleted(planResultKey.getPlanKey(), planResultKey.getBuildNumber(), new PlanVcsRevisionData(workingCopyAfterPush.getCurrentRevisionKey(), null), repositoryToPushTo.getId());
                                    return workingCopyAfterPush.getCurrentRevisionKey();
                                }
                            });
                            mergeResult.setMergeResultVcsKey(commitRevision);
                            mergeResult.setPushState(MergeResultState.SUCCESS);
                        } else {
                            mergeResult.setPushState(MergeResultState.FAILED);
                            mergeResult.setFailureReason("Target repository does not support pushing - check your configuration.");
                        }
                    }
                }
                catch (Exception e) {
                    mergeResult.setPushState(MergeResultState.FAILED);
                    RepositoryException repositoryException = (RepositoryException)((Object)((Object)Narrow.downTo((Object)e, RepositoryException.class)));
                    if (repositoryException != null && !StringUtils.isBlank((CharSequence)repositoryException.getStderr())) {
                        mergeResult.setFailureReason("Push command error: " + repositoryException.getStderr());
                    } else {
                        mergeResult.setFailureReason("Exception during push: " + e.getMessage());
                    }
                    String errorMessage = "Unable to push " + planResultKey + " merge result: " + mergeResult;
                    log.warn((Object)("Exception during push: " + e.getMessage()));
                    log.warn((Object)errorMessage);
                }
                finally {
                    BambooPathUtils.deleteQuietly((Path)chainState.getMergeWorkingCopy().getPath().toPath());
                }
                if (MergeResultState.FAILED == mergeResult.getPushState()) {
                    log.error((Object)("Failed to push for plan-result: " + planResultKey + ". " + mergeResult.getFailureReason()));
                    chainState.getBuildContext().getBuildResult().addBuildErrors((List)Lists.newArrayList((Object[])new String[]{mergeResult.getFailureReason()}));
                }
            } else {
                mergeResult.setPushState(MergeResultState.NOT_REQUIRED);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finaliseChainStateIfChainExecutionHasCompleted(ChainState chainState, ChainExecution chainExecution, StageState currentStage) {
        if (currentStage == null || currentStage.isCompleted()) {
            PlanResultKey planResultKey = chainState.getPlanResultKey();
            log.info((Object)("Plan " + planResultKey + ": " + chainState.getName() + " has finished executing"));
            try {
                this.planStatePersisterService.persistChainState(chainState);
            }
            finally {
                this.chainStateMap.remove(planResultKey);
                this.removeSavedState(planResultKey);
                this.chainPluginSupport.chainCompleted(chainExecution, chainState.getBuildContext());
                File serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory((ResultKey)chainState.getPlanResultKey());
                BambooPathUtils.deleteQuietly((Path)serverSideWorkingDir.toPath());
                this.eventPublisher.publish((Object)new ChainCompletedEvent(this, chainExecution, chainState.getBuildContext()));
            }
        } else {
            this.saveState(chainState);
        }
    }

    @NotNull
    private Collection<ChainBuildState> getExecutableChainBuildStates(@NotNull StageState stageState) {
        LinkedList<ChainBuildState> buildStates = new LinkedList<ChainBuildState>();
        for (ChainBuildState buildState : stageState.getBuilds()) {
            if (!buildState.isWaiting()) continue;
            buildStates.add(buildState);
        }
        Collections.reverse(buildStates);
        return buildStates;
    }

    @NotNull
    private ChainExecution createChainExecution(@NotNull ChainState chainState) {
        StageState stageState;
        LinkedHashMap<StageState, StageExecution> stageExecutions = new LinkedHashMap<StageState, StageExecution>();
        ChainExecutionImpl chainExecution = new ChainExecutionImpl(chainState, stageExecutions);
        boolean firstStage = true;
        Iterator iterator = chainState.getStages().iterator();
        while (iterator.hasNext() && (!(stageState = (StageState)iterator.next()).isManual() || firstStage)) {
            StageExecution stageExecution = this.getStageExecution(chainExecution, stageState);
            stageExecutions.put(stageState, stageExecution);
            firstStage = false;
        }
        return chainExecution;
    }

    @NotNull
    private StageExecution getStageExecution(@NotNull ChainExecution chainExecution, @NotNull StageState stageState) {
        LinkedList<BuildExecution> buildExecutions = new LinkedList<BuildExecution>();
        StageExecutionImpl stageExecution = new StageExecutionImpl(stageState, chainExecution, buildExecutions);
        for (ChainBuildState buildState : stageState.getBuilds()) {
            BuildExecution buildExecution = this.getBuildExecution(stageExecution, buildState);
            buildExecutions.add(buildExecution);
        }
        return stageExecution;
    }

    @NotNull
    private BuildExecution getBuildExecution(@NotNull StageExecution stageExecution, @NotNull ChainBuildState chainBuildState) {
        return new BuildExecutionImpl(stageExecution, chainBuildState);
    }

    @Nullable
    private ChainState findReferenceForJobResultKey(@NotNull PlanResultKey planResultKey) {
        for (ChainState chainState : this.chainStateMap.values()) {
            if (chainState.getChainBuildState(planResultKey) == null) continue;
            return chainState;
        }
        return null;
    }

    @NotNull
    private Collection<ChainState> getChainStateReferencesForPlanKey(@NotNull PlanKey planKey) {
        return Collections2.filter(this.chainStateMap.values(), input -> input.getPlanResultKey().getPlanKey().equals((Object)planKey));
    }

    private void logException(String msg, Exception e, BuildContext buildContext, ErrorCollection errors) {
        this.logException(msg, e, null, buildContext, errors);
    }

    private void logException(String msg, Exception e, @Nullable Map<String, String> errorDetails, BuildContext buildContext, ErrorCollection errors) {
        log.error((Object)msg, (Throwable)e);
        this.errorUpdateHandler.recordError((ResultKey)buildContext.getPlanResultKey(), errors.addErrorMessage(msg), (Throwable)e, errorDetails);
        buildContext.getErrorCollection().addErrorMessages(errors.getErrorMessages());
    }

    private void logException(String msg, Throwable e, PlanKey planKey, ErrorCollection errors) {
        log.error((Object)msg, e);
        this.errorUpdateHandler.recordError((Key)planKey, errors.addErrorMessage(msg), e);
    }

    private void saveState(ChainState state) {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            this.chainStateLock.apply(state.getPlanResultKey()).withLock(() -> this.chainStatePersister.save((Object)state, true));
        }
    }

    private void removeSavedState(PlanResultKey key) {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            this.chainStateLock.apply(key).withLock(() -> this.chainStatePersister.remove((Key)key));
        }
    }

    private static interface ChainStateProvider {
        @Nullable
        public ChainState getChainState(ErrorCollection var1) throws Exception;
    }

    private static interface BuildDetectionResultCreationCallback {
        public BuildDetectionResult createBuildDetectionResult();
    }
}

