/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultDescriptor;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainFilteredTestResults
implements FilteredTestResults<TestClassResultDescriptor> {
    private static final Logger log = Logger.getLogger(ChainFilteredTestResults.class);
    private final ChainResultsSummary chainResultsSummary;
    private final int pageNumber;
    private final int pageSize;
    private Multimap<TestClassResultDescriptor, TestCaseResult> newFailedTests;
    private Multimap<TestClassResultDescriptor, TestCaseResult> existingFailedTests;
    private Multimap<TestClassResultDescriptor, TestCaseResult> fixedTests;
    private Multimap<TestClassResultDescriptor, TestCaseResult> allFailedTests;
    private Multimap<TestClassResultDescriptor, TestCaseResult> quarantinedTests;
    private Multimap<TestClassResultDescriptor, TestCaseResult> skippedTests;
    private TestsManager testsManager;
    private TestQuarantineManager testQuarantineManager;

    private ChainFilteredTestResults(TestsManager testsManager, TestQuarantineManager testQuarantineManager, ChainResultsSummary chainResultsSummary, int pageNumber, int pageSize) {
        this.testsManager = testsManager;
        this.testQuarantineManager = testQuarantineManager;
        this.chainResultsSummary = chainResultsSummary;
        this.pageNumber = pageNumber;
        if (pageSize == 0) {
            log.warn((Object)"Unbounded query for test results - capping at 100");
            this.pageSize = 100;
        } else {
            this.pageSize = pageSize;
        }
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getNewFailedTests() {
        if (this.newFailedTests == null) {
            List results = this.getTestsManager().getTestsForChainResultByDeltaState(this.chainResultsSummary, TestDeltaState.BROKEN, this.pageNumber * this.pageSize, this.pageSize);
            this.newFailedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.newFailedTests;
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getFixedTests() {
        if (this.fixedTests == null) {
            List results = this.getTestsManager().getTestsForChainResultByDeltaState(this.chainResultsSummary, TestDeltaState.FIXED, this.pageNumber * this.pageSize, this.pageSize);
            this.fixedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.fixedTests;
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getExistingFailedTests() {
        if (this.existingFailedTests == null) {
            List results = this.getTestsManager().getTestsForChainResultByDeltaState(this.chainResultsSummary, TestDeltaState.FAILING, this.pageNumber * this.pageSize, this.pageSize);
            this.existingFailedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.existingFailedTests;
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getAllFailedTests() {
        if (this.allFailedTests == null) {
            List results = this.getTestsManager().getTestsForChainResultByState(this.chainResultsSummary, TestState.FAILED, this.pageNumber * this.pageSize, this.pageSize);
            this.allFailedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.allFailedTests;
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getQuarantinedTests() {
        if (this.quarantinedTests == null) {
            List results = this.getTestQuarantineManager().getQuarantinedTestsListForChainResult(this.chainResultsSummary);
            this.quarantinedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.quarantinedTests;
    }

    @NotNull
    public Multimap<TestClassResultDescriptor, TestCaseResult> getSkippedTests() {
        if (this.skippedTests == null) {
            List results = this.getTestsManager().getTestsForChainResultByState(this.chainResultsSummary, TestState.SKIPPED, this.pageNumber * this.pageSize, this.pageSize);
            this.skippedTests = ChainFilteredTestResults.aggregateResults(results);
        }
        return this.skippedTests;
    }

    @NotNull
    public List<TestCaseResult> getAllFailedTestList() {
        return new LinkedList<TestCaseResult>(this.getAllFailedTests().values());
    }

    @NotNull
    public List<TestCaseResult> getSkippedTestList() {
        return new LinkedList<TestCaseResult>(this.getSkippedTests().values());
    }

    @NotNull
    private static Multimap<TestClassResultDescriptor, TestCaseResult> aggregateResults(List<TestCaseResult> testCaseResults) {
        LinkedHashMultimap results = LinkedHashMultimap.create();
        TestClassResultDescriptorImpl lastDescriptor = null;
        for (TestCaseResult testCaseResult : testCaseResults) {
            TestClassResult testClassResult = testCaseResult.getTestClassResult();
            if (testClassResult.getName() == null) continue;
            if (lastDescriptor == null || !lastDescriptor.getName().equals(testClassResult.getName())) {
                lastDescriptor = new TestClassResultDescriptorImpl(testClassResult.getName(), testClassResult.getShortName());
            }
            results.put((Object)lastDescriptor, (Object)testCaseResult);
        }
        return results;
    }

    @Deprecated
    public TestsManager getTestsManager() {
        if (this.testsManager == null) {
            this.testsManager = (TestsManager)ContainerManager.getComponent((String)"testsManager");
        }
        return this.testsManager;
    }

    @Deprecated
    public TestQuarantineManager getTestQuarantineManager() {
        if (this.testQuarantineManager == null) {
            this.testQuarantineManager = (TestQuarantineManager)ContainerManager.getComponent((String)"testQuarantineManager");
        }
        return this.testQuarantineManager;
    }

    @Nullable
    public static ChainFilteredTestResults newInstance(TestsManager testsManager, TestQuarantineManager testQuarantineManager, ChainResultsSummary chainResultsSummary, int pageNumber, int pageSize) {
        if (!LifeCycleState.isFinalized((LifeCycleState)chainResultsSummary.getLifeCycleState())) {
            return null;
        }
        return new ChainFilteredTestResults(testsManager, testQuarantineManager, chainResultsSummary, pageNumber, pageSize);
    }

    static final class TestClassResultDescriptorImpl
    implements TestClassResultDescriptor {
        private final String name;
        private final String shortName;

        TestClassResultDescriptorImpl(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

