/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinitionImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;

public class ChainPluginSupportHelper {
    private static final Logger log = Logger.getLogger(ChainPluginSupportHelper.class);

    private ChainPluginSupportHelper() {
    }

    public static void prepareRuntimeTaskData(CommonContext commonContext, TaskManager taskManager, ErrorUpdateHandler errorUpdateHandler) {
        commonContext.getRuntimeTaskDefinitions().stream().filter(TaskIdentifier::isEnabled).filter(RuntimeTaskDefinitionImpl.class::isInstance).map(RuntimeTaskDefinitionImpl.class::cast).forEach(taskDefinition -> {
            TaskModuleDescriptor taskDescriptor = taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
            if (taskDescriptor != null) {
                try {
                    TaskTestResultsSupport taskTestResultsSupport;
                    RuntimeTaskDataProvider runtimeConfigurator = taskDescriptor.getRuntimeTaskDataProvider();
                    if (runtimeConfigurator != null) {
                        taskDefinition.setRuntimeContext(runtimeConfigurator.populateRuntimeTaskData((TaskDefinition)taskDefinition, commonContext));
                        taskDefinition.setRuntimeData(runtimeConfigurator.createRuntimeTaskData((RuntimeTaskDefinition)taskDefinition, commonContext));
                    }
                    if ((taskTestResultsSupport = (TaskTestResultsSupport)Narrow.downTo((Object)taskDescriptor.getTaskConfigurator(), TaskTestResultsSupport.class)) != null) {
                        taskDefinition.setProducesTestResults(taskTestResultsSupport.taskProducesTestResults((TaskDefinition)taskDefinition));
                    }
                }
                catch (Throwable e) {
                    ResultKey resultKey = commonContext.getResultKey();
                    log.error((Object)("Task context data provider failed:" + e));
                    errorUpdateHandler.recordError(resultKey, taskDefinition.getPluginKey(), e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void processRuntimeTaskData(CommonContext commonContext, TaskManager taskManager, ErrorUpdateHandler errorUpdateHandler) {
        Preconditions.checkNotNull((Object)taskManager, (Object)"task manager is null");
        if (CollectionUtils.isEmpty((Collection)commonContext.getRuntimeTaskDefinitions())) {
            return;
        }
        for (RuntimeTaskDefinition taskDefinition : commonContext.getRuntimeTaskDefinitions()) {
            String pluginKey = ((RuntimeTaskDefinition)Preconditions.checkNotNull((Object)taskDefinition, (Object)"task definition is null")).getPluginKey();
            TaskModuleDescriptor taskDescriptor = taskManager.getTaskDescriptor(pluginKey);
            if (taskDescriptor == null) continue;
            try {
                RuntimeTaskDataProvider runtimeConfigurator = taskDescriptor.getRuntimeTaskDataProvider();
                if (runtimeConfigurator == null) continue;
                try {
                    runtimeConfigurator.processRuntimeTaskData(taskDefinition, commonContext);
                }
                catch (IncompatibleClassChangeError e) {
                    runtimeConfigurator.processRuntimeTaskData((TaskDefinition)taskDefinition, commonContext);
                }
            }
            catch (Throwable e) {
                ResultKey resultKey = commonContext.getResultKey();
                log.error((Object)("Task context data provider cleanup failed:" + e));
                errorUpdateHandler.recordError(resultKey, taskDefinition.getPluginKey(), e);
            }
        }
    }
}

