/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainPluginSupport;
import com.atlassian.bamboo.chains.ChainPluginSupportHelper;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PostJobAction;
import com.atlassian.bamboo.chains.plugins.PostStageAction;
import com.atlassian.bamboo.chains.plugins.PreJobAction;
import com.atlassian.bamboo.chains.plugins.PreStageAction;
import com.atlassian.bamboo.chains.plugins.RestartFailedStageAction;
import com.atlassian.bamboo.chains.plugins.ResumeManualStageAction;
import com.atlassian.bamboo.chains.plugins.StopOnManualStageAction;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.PostChainActionModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.PreChainActionModuleDescriptor;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.v2.BambooPluginModule;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.security.CodeSource;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
class ChainPluginSupportImpl
implements ChainPluginSupport {
    private static final Logger log = Logger.getLogger(ChainPluginSupportImpl.class);
    private final ResultsSummaryManager resultsSummaryManager;
    private final PluginAccessor pluginAccessor;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final CustomVariableContextRunner customVariableContextRunner;
    private final CachedPlanManager cachedPlanManager;
    private final PlanManager planManager;
    private final TaskManager taskManager;

    public ChainPluginSupportImpl(ResultsSummaryManager resultsSummaryManager, PluginAccessor pluginAccessor, ErrorUpdateHandler errorUpdateHandler, CustomVariableContextRunner customVariableContextRunner, CachedPlanManager cachedPlanManager, PlanManager planManager, TaskManager taskManager) {
        this.resultsSummaryManager = resultsSummaryManager;
        this.pluginAccessor = pluginAccessor;
        this.errorUpdateHandler = errorUpdateHandler;
        this.customVariableContextRunner = customVariableContextRunner;
        this.cachedPlanManager = cachedPlanManager;
        this.planManager = planManager;
        this.taskManager = taskManager;
    }

    private <T extends BambooPluginModule> void withCustomVariableContext(@NotNull BuildContext buildContext, @NotNull Iterable<T> actions, @NotNull ChainPluginSupportCallable<T> actionFunction) {
        if (!Iterables.isEmpty(actions)) {
            this.customVariableContextRunner.execute((CommonContext)buildContext, () -> this.callActionFunction(buildContext, actionFunction, actions));
        }
    }

    private <T extends BambooPluginModule> void callActionFunction(final @NotNull BuildContext buildContext, final @NotNull ChainPluginSupportCallable<T> actionFunction, @NotNull Iterable<T> actions) {
        for (final BambooPluginModule action : actions) {
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<Void>(String.format("Error while executing %s", action.getClass().getName())){

                @Override
                @Nullable
                public Void call() throws Exception {
                    actionFunction.call(action);
                    return null;
                }

                @Override
                public void onThrow(@NotNull Throwable e) {
                    ChainPluginSupportImpl.this.logPluginError(action.getClass(), action, e, buildContext.getPlanResultKey());
                }
            });
        }
    }

    public void chainStarted(@NotNull ChainExecution chainExecution, @NotNull BuildContext buildContext) {
        Chain chain = this.getChain(chainExecution);
        if (chain != null) {
            Collection actions = this.getActionsForModuleDescriptor(PreChainActionModuleDescriptor.class);
            this.withCustomVariableContext(buildContext, actions, action -> action.execute(chain, chainExecution));
        }
    }

    public void chainCompleted(@NotNull ChainExecution chainExecution, @NotNull BuildContext buildContext) {
        Chain chain = this.getChain(chainExecution);
        if (chain != null) {
            ChainResultsSummary chainResult = this.getChainResultsSummaryNotNull(chainExecution);
            Collection actions = this.getActionsForModuleDescriptor(PostChainActionModuleDescriptor.class);
            this.withCustomVariableContext(buildContext, actions, action -> {
                action.execute(chain, chainResult, chainExecution);
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResult);
            });
        }
    }

    public void stageStarted(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        Chain chain = this.getChain(stageExecution);
        if (chain != null) {
            List actions = this.pluginAccessor.getEnabledModulesByClass(PreStageAction.class);
            this.withCustomVariableContext(buildContext, actions, action -> action.execute(stageExecution));
        }
    }

    public void stageCompleted(@NotNull StageExecution stageExecution, long stageResultId, @NotNull BuildContext buildContext) {
        ChainResultsSummary chainResult;
        Chain chain = this.getChain(stageExecution);
        ChainStageResult chainStageResult = this.resultsSummaryManager.getChainStageResultById(Long.valueOf(stageResultId));
        if (chain != null && chainStageResult != null && (chainResult = this.getChainResultsSummary(stageExecution)) != null) {
            List actions = this.pluginAccessor.getEnabledModulesByClass(PostStageAction.class);
            this.withCustomVariableContext(buildContext, actions, action -> {
                action.execute(chainResult, chainStageResult, stageExecution);
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResult);
            });
        }
    }

    public void stoppedOnManualStage(@NotNull StageExecution stageExecution, long stageResultId, @NotNull BuildContext buildContext) {
        ChainResultsSummary chainResult;
        Chain chain = this.getChain(stageExecution);
        ChainStageResult chainStageResult = this.resultsSummaryManager.getChainStageResultById(Long.valueOf(stageResultId));
        if (chain != null && chainStageResult != null && (chainResult = this.getChainResultsSummary(stageExecution)) != null) {
            List actions = this.pluginAccessor.getEnabledModulesByClass(StopOnManualStageAction.class);
            this.withCustomVariableContext(buildContext, actions, action -> {
                action.execute(chainResult, chainStageResult, stageExecution);
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResult);
            });
        }
    }

    public void manualStageResumed(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        Chain chain = this.getChain(stageExecution);
        if (chain != null) {
            List actions = this.pluginAccessor.getEnabledModulesByClass(ResumeManualStageAction.class);
            this.withCustomVariableContext(buildContext, actions, action -> action.execute(stageExecution));
        }
    }

    public void failedStageRestarted(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        Chain chain = this.getChain(stageExecution);
        if (chain != null) {
            List actions = this.pluginAccessor.getEnabledModulesByClass(RestartFailedStageAction.class);
            this.withCustomVariableContext(buildContext, actions, action -> action.execute(stageExecution));
        }
    }

    public void buildStarted(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        List actions = this.pluginAccessor.getEnabledModulesByClass(PreJobAction.class);
        this.customVariableContextRunner.execute((CommonContext)buildContext, () -> {
            this.callActionFunction(buildContext, action -> action.execute(stageExecution, buildContext), actions);
            ChainPluginSupportHelper.prepareRuntimeTaskData((CommonContext)buildContext, this.taskManager, this.errorUpdateHandler);
        });
    }

    public void buildCompleted(@NotNull BuildExecution buildExecution) {
        List actions = this.pluginAccessor.getEnabledModulesByClass(PostJobAction.class);
        ImmutableJob immutableJob = (ImmutableJob)this.cachedPlanManager.getPlanByKey(buildExecution.getPlanResultKey().getPlanKey(), ImmutableJob.class);
        if (immutableJob != null) {
            BuildResultsSummary buildResultsSummary = this.getBuildResultsSummary(buildExecution);
            if (buildResultsSummary != null) {
                BuildContext buildContext = buildExecution.getBuildContext();
                this.customVariableContextRunner.execute((CommonContext)buildContext, () -> {
                    this.callActionFunction(buildContext, action -> {
                        block2: {
                            try {
                                action.execute(buildExecution.getStageExecution(), immutableJob, buildResultsSummary);
                            }
                            catch (IncompatibleClassChangeError e) {
                                log.warn((Object)String.format("A plugins class %s implements only a deprecated action method. It's not going to work for plan branches", action.getClass()));
                                Job job = (Job)this.planManager.getPlanByKey(buildExecution.getPlanResultKey().getPlanKey(), Job.class);
                                if (job == null) break block2;
                                action.execute(buildExecution.getStageExecution(), job, buildResultsSummary);
                            }
                        }
                        this.resultsSummaryManager.saveResultSummary((ResultsSummary)buildResultsSummary);
                    }, actions);
                    ChainPluginSupportHelper.processRuntimeTaskData((CommonContext)buildContext, this.taskManager, this.errorUpdateHandler);
                });
            }
        } else {
            log.warn((Object)String.format("Could not find job with key %s", buildExecution.getPlanResultKey().getPlanKey()));
        }
    }

    public boolean shouldStopExecution(final @NotNull ImmutableChain chain, final @NotNull Map<String, String> triggerConditionsConfiguration) {
        List conditions = this.pluginAccessor.getEnabledModulesByClass(BuildTriggerCondition.class);
        if (!conditions.isEmpty()) {
            try {
                return (Boolean)this.customVariableContextRunner.execute((PlanIdentifier)chain, () -> {
                    BuildTriggerCondition.ExecutionPreference currentPreference = BuildTriggerCondition.ExecutionPreference.NONE;
                    for (final BuildTriggerCondition condition : conditions) {
                        BuildTriggerCondition.ExecutionPreference preference = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<BuildTriggerCondition.ExecutionPreference>("CustomVariableContext aware not executed"){

                            @Override
                            @Nullable
                            public BuildTriggerCondition.ExecutionPreference call() {
                                return condition.getExecutionPreference((ImmutablePlan)chain, triggerConditionsConfiguration);
                            }
                        });
                        if (preference == null || !preference.isHigherThan(currentPreference)) continue;
                        currentPreference = preference;
                    }
                    return currentPreference.stopBuild();
                });
            }
            catch (Exception e) {
                log.error((Object)("CustomVariableContext aware not executed: " + e));
            }
        }
        return false;
    }

    private void logPluginError(Class<? extends BambooPluginModule> actionClass, BambooPluginModule pluginModule, Throwable e, PlanResultKey planResultKey) {
        CodeSource codeSource = pluginModule.getClass().getProtectionDomain().getCodeSource();
        String pluginModuleClassLocation = "";
        if (codeSource != null) {
            pluginModuleClassLocation = codeSource.getLocation().toString() + ", ";
        }
        String pluginModuleTypeAndPluginModuleName = actionClass.getSimpleName() + ": " + pluginModule.getClass().getCanonicalName();
        log.error((Object)(pluginModuleClassLocation + pluginModuleTypeAndPluginModuleName + ": " + e.getMessage()), e);
        this.errorUpdateHandler.recordError((ResultKey)planResultKey, pluginModuleTypeAndPluginModuleName, e);
    }

    @NotNull
    private <T> Collection<T> getActionsForModuleDescriptor(Class<? extends AbstractBambooModuleDescriptor<T>> clazz) {
        List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(clazz);
        LinkedList actions = new LinkedList();
        for (AbstractBambooModuleDescriptor postChainActionModuleDescriptor : modules) {
            actions.add(postChainActionModuleDescriptor.getModule());
        }
        return actions;
    }

    @Nullable
    private ChainResultsSummary getChainResultsSummary(@NotNull ChainExecution chainExecution) {
        return (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainExecution.getPlanResultKey(), ChainResultsSummary.class);
    }

    @Nullable
    private ChainResultsSummary getChainResultsSummary(@NotNull StageExecution stageExecution) {
        return this.getChainResultsSummary(stageExecution.getChainExecution());
    }

    @Nullable
    private BuildResultsSummary getBuildResultsSummary(@NotNull BuildExecution buildExecution) {
        return (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(buildExecution.getPlanResultKey(), BuildResultsSummary.class);
    }

    @NotNull
    private ChainResultsSummary getChainResultsSummaryNotNull(@NotNull ChainExecution chainExecution) {
        return (ChainResultsSummary)Preconditions.checkNotNull((Object)this.getChainResultsSummary(chainExecution), (Object)("Result summary not found for " + chainExecution.getPlanResultKey()));
    }

    @Nullable
    private Chain getChain(@NotNull ChainExecution chainExecution) {
        return (Chain)this.planManager.getPlanByKey(chainExecution.getPlanResultKey().getPlanKey(), Chain.class);
    }

    @Nullable
    private Chain getChain(@NotNull StageExecution stageExecution) {
        return this.getChain(stageExecution.getChainExecution());
    }

    private static interface ChainPluginSupportCallable<T extends BambooPluginModule> {
        public void call(@NotNull T var1) throws Exception;
    }
}

