/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.context.BuildContextBuilder;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainStateResult;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCreationException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaBuilder;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.NameProviderFunctions;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainResultManagerImpl
implements ChainResultManager {
    private static final Logger log = Logger.getLogger(ChainResultManagerImpl.class);
    private static final String ERROR_CONTEXT = "Creating Plan and Job Results";
    private final BuildResultsSummaryManager buildResultsSummaryManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final LimitedConcurrencyCaller limitedConcurrencyCaller;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final TextProvider textProvider;
    private final ArtifactLinkManager artifactLinkManager;
    private final Persister persister;
    private final BuildContextBuilderFactory buildContextBuilderFactory;
    private final TriggerManager triggerManager;
    private final AuthorCreatorService authorCreatorService;

    public ChainResultManagerImpl(BuildResultsSummaryManager buildResultsSummaryManager, ResultsSummaryManager resultsSummaryManager, LimitedConcurrencyCaller limitedConcurrencyCaller, ErrorUpdateHandler errorUpdateHandler, TextProvider textProvider, ArtifactLinkManager artifactLinkManager, Persister persister, BuildContextBuilderFactory buildContextBuilderFactory, TriggerManager triggerManager, AuthorCreatorService authorCreatorService) {
        this.buildResultsSummaryManager = buildResultsSummaryManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.limitedConcurrencyCaller = limitedConcurrencyCaller;
        this.errorUpdateHandler = errorUpdateHandler;
        this.textProvider = textProvider;
        this.artifactLinkManager = artifactLinkManager;
        this.persister = persister;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
        this.triggerManager = triggerManager;
        this.authorCreatorService = authorCreatorService;
    }

    public void updateStateToInProgress(@NotNull PlanResultKey chainResultKey, @NotNull Date startDate) {
        ResultsSummary chainResultsSummary = this.resultsSummaryManager.getResultsSummary(chainResultKey);
        if (chainResultsSummary != null && LifeCycleState.isQueued((LifeCycleState)chainResultsSummary.getLifeCycleState())) {
            chainResultsSummary.setBuildDate(startDate);
            this.resultsSummaryManager.updateLifeCycleState(chainResultsSummary, LifeCycleState.IN_PROGRESS, BuildState.UNKNOWN);
        }
    }

    @NotNull
    public ChainStateResult create(@NotNull BuildContext chainBuildContext, @NotNull Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> jobBuildContexts, @NotNull Collection<? extends ImmutableChainStage> stagesToExecute) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        HashMap<PlanResultKey, BuildContext> buildContextMap = new HashMap<PlanResultKey, BuildContext>();
        HashMap<PlanResultKey, Long> averageDurationMap = new HashMap<PlanResultKey, Long>();
        ChainResultsSummary chainResultsSummary = null;
        try {
            chainResultsSummary = this.limitedConcurrencyCaller.execute(() -> this.lambda$create$0(chainBuildContext, jobBuildContexts, stagesToExecute, (ErrorCollection)errors, buildContextMap, averageDurationMap));
        }
        catch (ResultsSummaryCreationException e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
            errors.addErrorMessage(this.textProvider.getText("chain.internalExecutionError"));
            this.errorUpdateHandler.recordError((ResultKey)chainBuildContext.getPlanResultKey(), ERROR_CONTEXT, (Throwable)e);
        }
        return new ChainResultStateImpl(chainResultsSummary, buildContextMap, averageDurationMap, (ErrorCollection)errors);
    }

    @NotNull
    private ChainResultsSummary createWithLimitedConcurrency(@NotNull BuildContext chainBuildContext, @NotNull Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> jobBuildContexts, @NotNull Collection<? extends ImmutableChainStage> stagesToExecute, ErrorCollection errors, Map<PlanResultKey, BuildContext> buildContextMap, Map<PlanResultKey, Long> averageDurationMap) throws ResultsSummaryCreationException {
        ChainResultsSummary crs = (ChainResultsSummary)this.resultsSummaryManager.createResultsSummary(chainBuildContext, ChainResultsSummary.class);
        this.resultsSummaryManager.logVariablesForSubstitution(chainBuildContext, (ResultsSummary)crs);
        for (Map.Entry<ImmutableChainStage, Map<ImmutableJob, BuildContext>> entry : jobBuildContexts.entrySet()) {
            ImmutableChainStage stage = entry.getKey();
            Map<ImmutableJob, BuildContext> buildContextForStage = entry.getValue();
            ChainStageResult stageResult = crs.createStageResult(stage);
            for (Map.Entry<ImmutableJob, BuildContext> jobBuildContextEntry : buildContextForStage.entrySet()) {
                ImmutableJob job = jobBuildContextEntry.getKey();
                try {
                    BuildContext buildContext = jobBuildContextEntry.getValue();
                    if (buildContext == null) {
                        throw new ResultsSummaryCreationException(this.textProvider.getText("chain.missingBuildContext", (List)Lists.newArrayList((Object[])new Serializable[]{job.getPlanKey(), crs.getPlanResultKey().toString()})));
                    }
                    PlanResultKey jobResultKey = buildContext.getPlanResultKey();
                    BuildResultsSummary buildResultsSummary = (BuildResultsSummary)this.buildResultsSummaryManager.createResultsSummary(crs, buildContext, BuildResultsSummary.class);
                    if (stagesToExecute.contains(stage)) {
                        buildContextMap.put(jobResultKey, buildContext);
                        averageDurationMap.put(jobResultKey, job.getAverageBuildDuration());
                    } else {
                        buildResultsSummary.updateLifeCycleState(LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
                    }
                    stageResult.addBuildResult(buildResultsSummary);
                }
                catch (ResultsSummaryCreationException e) {
                    errors.addErrorMessage(this.textProvider.getText("chain.internalExecutionError"));
                    this.errorUpdateHandler.recordError((ResultKey)chainBuildContext.getPlanResultKey(), ERROR_CONTEXT, (Throwable)e);
                    this.rollbackResultSummaryState(crs);
                }
            }
        }
        crs.setQueueTime(new Date());
        crs.updateLifeCycleState(LifeCycleState.QUEUED, BuildState.UNKNOWN);
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)crs);
        return crs;
    }

    @NotNull
    public ChainStateResult updateForContinuedBuild(@NotNull BuildContext chainBuildContext, @NotNull Collection<BuildContext> jobBuildContexts, @NotNull PlanExecutionConfig planExecutionConfig) throws IOException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        HashMap<PlanResultKey, BuildContext> buildContextMap = new HashMap<PlanResultKey, BuildContext>();
        HashMap<PlanResultKey, Long> averageDurationMap = new HashMap<PlanResultKey, Long>();
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainBuildContext.getPlanResultKey(), ChainResultsSummary.class);
        HashMap<BuildResultsSummary, ChainStageResult> resultsToRemove = new HashMap<BuildResultsSummary, ChainStageResult>();
        boolean buildActuallyRestarted = false;
        boolean isContinuable = false;
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            if (!planExecutionConfig.isScheduledForExecution(chainStageResult.getName())) {
                isContinuable = true;
            }
            for (BuildResultsSummary jobResultsSummary : chainStageResult.getBuildResults()) {
                boolean isJobBeingRun = false;
                for (BuildContext buildContext : jobBuildContexts) {
                    if (!jobResultsSummary.getPlanResultKey().equals((Object)buildContext.getPlanResultKey())) continue;
                    buildContextMap.put(jobResultsSummary.getPlanResultKey(), buildContext);
                    buildContextMap.put(jobResultsSummary.getPlanResultKey(), buildContext);
                    averageDurationMap.put(jobResultsSummary.getPlanResultKey(), jobResultsSummary.getImmutablePlan().getAverageBuildDuration());
                    if (jobResultsSummary.getBuildState() == BuildState.FAILED) {
                        jobResultsSummary.incrementRestartCount();
                    }
                    this.artifactLinkManager.removeProducedArtifactLinks(jobResultsSummary);
                    jobResultsSummary.updateLifeCycleState(LifeCycleState.PENDING, BuildState.UNKNOWN);
                    buildActuallyRestarted = true;
                    BuildResults buildResults = this.persister.getBuildResults((Key)buildContext.getPlanResultKey().getPlanKey(), buildContext.getBuildNumber());
                    if (buildResults != null && chainResultsSummary.isRestartable()) {
                        buildResults.clearBuildErrors();
                        ImmutableBuildable buildable = (ImmutableBuildable)Narrow.to((Object)jobResultsSummary.getImmutablePlan(), ImmutableBuildable.class);
                        this.persister.addBuildResults(buildable.getPlanKey(), buildResults);
                    }
                    isJobBeingRun = true;
                }
                if (isJobBeingRun || !planExecutionConfig.isScheduledForExecution(chainStageResult.getName()) || !jobResultsSummary.getPlanIfExists().map(PlanIdentifier::isSuspendedFromBuilding).orElse(false).booleanValue()) continue;
                resultsToRemove.put(jobResultsSummary, chainStageResult);
            }
        }
        resultsToRemove.forEach((jobResult, stageResult) -> stageResult.removeBuildResult(jobResult));
        if (buildActuallyRestarted) {
            chainResultsSummary.setQueueTime(new Date());
            int startingStageIndex = planExecutionConfig.getStartStage() != null ? planExecutionConfig.getStartStage().getIndex() : Integer.MAX_VALUE;
            chainResultsSummary.updateLifeCycleState(startingStageIndex == 0 ? LifeCycleState.QUEUED : LifeCycleState.IN_PROGRESS, BuildState.UNKNOWN);
        } else {
            chainResultsSummary.setContinuable(isContinuable);
            chainResultsSummary.updateLifeCycleState(LifeCycleState.FINISHED, BuildState.SUCCESS);
        }
        if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RESTART) {
            chainResultsSummary.incrementRestartCount();
        }
        chainResultsSummary.setTriggerReason(chainBuildContext.getTriggerReason());
        if (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.CONTINUE) {
            this.resultsSummaryManager.updateVariablesOnContinuedBuild((ResultsSummary)chainResultsSummary, chainBuildContext.getVariableContext());
        }
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
        resultsToRemove.forEach((brs, ignore) -> this.resultsSummaryManager.removeResultSummary(brs.getPlanResultKey()));
        return new ChainResultStateImpl(chainResultsSummary, buildContextMap, averageDurationMap, (ErrorCollection)errors);
    }

    @NotNull
    public ChainStateResult updateForRerunBuild(@NotNull BuildContext chainBuildContext, @NotNull Map<ImmutableChainStage, Map<ImmutableJob, BuildContext>> jobBuildContexts, @NotNull PlanExecutionConfig planExecutionConfig) throws IOException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        HashMap<PlanResultKey, BuildContext> buildContextMap = new HashMap<PlanResultKey, BuildContext>();
        HashMap<PlanResultKey, Long> averageDurationMap = new HashMap<PlanResultKey, Long>();
        Set stagesToExecute = planExecutionConfig.getStagesToExecute();
        HashMap<PlanKey, BuildResultsSummary> existingJobResultSummaries = new HashMap<PlanKey, BuildResultsSummary>();
        HashMap<String, ChainStageResult> existingStageResults = new HashMap<String, ChainStageResult>();
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainBuildContext.getPlanResultKey(), ChainResultsSummary.class);
        ArrayList<ChainStageResult> newStageResultList = new ArrayList<ChainStageResult>();
        for (ChainStageResult chainStageResult2 : chainResultsSummary.getStageResults()) {
            existingStageResults.put(chainStageResult2.getName(), chainStageResult2);
            for (BuildResultsSummary jobResultsSummary : chainStageResult2.getBuildResults()) {
                existingJobResultSummaries.put(jobResultsSummary.getPlanKey(), jobResultsSummary);
            }
        }
        boolean buildActuallyRestarted = false;
        boolean allStagesExecuted = true;
        for (Map.Entry<ImmutableChainStage, Map<ImmutableJob, BuildContext>> entry : jobBuildContexts.entrySet()) {
            ImmutableChainStage stage = entry.getKey();
            Map<ImmutableJob, BuildContext> buildContextForStage = entry.getValue();
            ChainStageResult stageResult = existingStageResults.containsKey(stage.getName()) ? (ChainStageResult)existingStageResults.get(stage.getName()) : chainResultsSummary.createStageResult(stage);
            newStageResultList.add(stageResult);
            existingStageResults.remove(stage.getName());
            for (Map.Entry<ImmutableJob, BuildContext> jobBuildContextEntry : buildContextForStage.entrySet()) {
                ImmutableJob job = jobBuildContextEntry.getKey();
                try {
                    BuildContext buildContext = jobBuildContextEntry.getValue();
                    if (buildContext == null) {
                        throw new ResultsSummaryCreationException(this.textProvider.getText("chain.missingBuildContext", (List)Lists.newArrayList((Object[])new Serializable[]{job.getPlanKey(), chainResultsSummary.getPlanResultKey().toString()})));
                    }
                    PlanResultKey jobResultKey = buildContext.getPlanResultKey();
                    boolean isJobBeingRerun = existingJobResultSummaries.containsKey(job.getPlanKey());
                    BuildResultsSummary buildResultsSummary = isJobBeingRerun ? (BuildResultsSummary)existingJobResultSummaries.get(job.getPlanKey()) : (BuildResultsSummary)this.buildResultsSummaryManager.createResultsSummary(chainResultsSummary, buildContext, BuildResultsSummary.class);
                    existingJobResultSummaries.remove(job.getPlanKey());
                    if (stagesToExecute.contains(stage)) {
                        buildActuallyRestarted = true;
                        buildContextMap.put(jobResultKey, buildContext);
                        averageDurationMap.put(jobResultKey, job.getAverageBuildDuration());
                        if (isJobBeingRerun) {
                            buildResultsSummary.incrementRestartCount();
                            buildResultsSummary.updateLifeCycleState(LifeCycleState.PENDING, BuildState.UNKNOWN);
                            this.resultsSummaryManager.resetResultSummary(buildResultsSummary);
                            BuildResults buildResults = this.persister.getBuildResults((Key)buildResultsSummary.getPlanKey(), buildResultsSummary.getBuildNumber());
                            if (buildResults != null) {
                                buildResults.clearBuildErrors();
                                this.persister.addBuildResults(job.getPlanKey(), buildResults);
                            }
                        }
                    } else {
                        allStagesExecuted = false;
                        buildResultsSummary.updateLifeCycleState(LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
                    }
                    stageResult.addBuildResult(buildResultsSummary);
                }
                catch (ResultsSummaryCreationException e) {
                    errors.addErrorMessage(this.textProvider.getText("chain.internalExecutionError"));
                    this.errorUpdateHandler.recordError((ResultKey)chainBuildContext.getPlanResultKey(), ERROR_CONTEXT, (Throwable)e);
                    this.rollbackResultSummaryState(chainResultsSummary);
                }
            }
        }
        for (ChainStageResult chainStageResult3 : newStageResultList) {
            chainStageResult3.getBuildResults().removeIf(brs -> existingJobResultSummaries.containsKey(brs.getPlanKey()));
        }
        existingStageResults.values().forEach(chainStageResult -> chainStageResult.getBuildResults().clear());
        chainResultsSummary.getStageResults().clear();
        newStageResultList.forEach(arg_0 -> ((ChainResultsSummary)chainResultsSummary).addStageResult(arg_0));
        if (buildActuallyRestarted) {
            chainResultsSummary.setQueueTime(new Date());
            int startingStageIndex = planExecutionConfig.getStartStage() != null ? planExecutionConfig.getStartStage().getIndex() : Integer.MAX_VALUE;
            chainResultsSummary.updateLifeCycleState(startingStageIndex == 0 ? LifeCycleState.QUEUED : LifeCycleState.IN_PROGRESS, BuildState.UNKNOWN);
        } else {
            if (!allStagesExecuted) {
                chainResultsSummary.setContinuable(true);
            }
            chainResultsSummary.updateLifeCycleState(LifeCycleState.FINISHED, BuildState.SUCCESS);
        }
        chainResultsSummary.incrementRestartCount();
        chainResultsSummary.setRebuild(true);
        chainResultsSummary.setTriggerReason(chainBuildContext.getTriggerReason());
        this.resultsSummaryManager.clearVariablesOnRerunBuild((ResultsSummary)chainResultsSummary);
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
        for (BuildResultsSummary buildResultsSummary : existingJobResultSummaries.values()) {
            this.resultsSummaryManager.removeResultSummary(buildResultsSummary.getPlanResultKey());
        }
        return new ChainResultStateImpl(chainResultsSummary, buildContextMap, averageDurationMap, (ErrorCollection)errors);
    }

    public long getAverageProgressDurationForStages(@NotNull PlanIdentifier chain, @NotNull Collection<ChainStageResult> stages, int numberOfResults) {
        ResultsSummaryCriteria criteriaForAllResults;
        ResultsSummaryCriteria criteriaForSuccessfulResults = new ResultsSummaryCriteriaBuilder().setResultSummaryClass(ChainResultsSummary.class).setPlanKey(chain.getPlanKey()).setBuildState(BuildState.SUCCESS).setMaxRowCount(numberOfResults).buildCriteria();
        List resultSummaries = this.resultsSummaryManager.getResultSummaries(criteriaForSuccessfulResults);
        if (resultSummaries.isEmpty() && (resultSummaries = this.resultsSummaryManager.getResultSummaries(criteriaForAllResults = new ResultsSummaryCriteriaBuilder().setPlanKey(chain.getPlanKey()).setMaxRowCount(numberOfResults).buildCriteria())).isEmpty()) {
            return 0L;
        }
        int totalNumOfResults = 0;
        int totalDuration = 0;
        for (ChainResultsSummary resultsSummary : resultSummaries) {
            totalDuration = (int)((long)totalDuration + resultsSummary.getStageResults().stream().filter(stage -> stages.stream().anyMatch(NameProviderFunctions.isNameEqual((NameProvider)stage))).mapToLong(ChainStageResult::getProcessingDuration).sum());
            ++totalNumOfResults;
        }
        if (totalNumOfResults != 0) {
            return totalDuration / totalNumOfResults;
        }
        return 0L;
    }

    public void createRepositorySpecFailedResult(@NotNull ImmutableChain plan, @NotNull VcsRepositoryData repositoryData, @NotNull BuildChanges buildChanges, int buildNumber, @NotNull VcsLocationBambooSpecsState specsState) {
        this.createRepositorySpecExecutedResult(plan, repositoryData, buildChanges, buildNumber, false, specsState);
    }

    public void createRepositorySpecSuccessResult(@NotNull ImmutableChain plan, @NotNull VcsRepositoryData repositoryData, @NotNull BuildChanges buildChanges, int buildNumber) {
        this.createRepositorySpecExecutedResult(plan, repositoryData, buildChanges, buildNumber, true, plan.getVcsBambooSpecsSource().getVcsLocationBambooSpecsState());
    }

    private void createRepositorySpecExecutedResult(@NotNull ImmutableChain plan, @NotNull VcsRepositoryData repositoryData, @NotNull BuildChanges buildChanges, int buildNumber, boolean success, @NotNull VcsLocationBambooSpecsState specsState) {
        BuildState buildState = success ? BuildState.SUCCESS : BuildState.FAILED;
        PlanRepositoryDefinition planRepositoryDefinition = PlanRepositoryDefinitionImpl.createForPosition(repositoryData, 0);
        BuildContextBuilder buildContextBuilder = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)plan).triggerReason(this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:RssChangedTriggerReason", Collections.emptyMap())).buildNumber(buildNumber).buildDefinition(plan.getBuildDefinition()).buildChanges(buildChanges).planRepositoryDefinitionMap((Map)ImmutableMap.of((Object)repositoryData.getRootVcsRepositoryId(), (Object)planRepositoryDefinition));
        if (success) {
            ResultSummaryHelper.markAsBambooSpecSuccess(buildContextBuilder, specsState);
        } else {
            ResultSummaryHelper.markAsBambooSpecFailure(buildContextBuilder, specsState);
        }
        BuildContext chainBuildContext = buildContextBuilder.build();
        this.authorCreatorService.createMissingAuthors(chainBuildContext);
        try {
            ChainResultsSummary resultsSummary = (ChainResultsSummary)this.resultsSummaryManager.createResultsSummary(chainBuildContext, ChainResultsSummary.class);
            resultsSummary.setBuildCompletedDate(new Date());
            resultsSummary.updateLifeCycleState(LifeCycleState.FINISHED, buildState);
            this.resultsSummaryManager.saveResultSummary((ResultsSummary)resultsSummary);
        }
        catch (ResultsSummaryCreationException e) {
            this.errorUpdateHandler.recordError((ResultKey)chainBuildContext.getPlanResultKey(), ERROR_CONTEXT, (Throwable)e);
        }
    }

    private void rollbackResultSummaryState(@NotNull ChainResultsSummary chainResultsSummary) {
        this.updateBuildAndLifeCycleState((ResultsSummary)chainResultsSummary);
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                this.updateBuildAndLifeCycleState((ResultsSummary)buildResultsSummary);
            }
        }
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
    }

    private void updateBuildAndLifeCycleState(@NotNull ResultsSummary resultsSummary) {
        resultsSummary.updateLifeCycleState(LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
    }

    private /* synthetic */ ChainResultsSummary lambda$create$0(BuildContext chainBuildContext, Map jobBuildContexts, Collection stagesToExecute, ErrorCollection errors, Map buildContextMap, Map averageDurationMap) throws ResultsSummaryCreationException {
        return this.createWithLimitedConcurrency(chainBuildContext, jobBuildContexts, stagesToExecute, errors, buildContextMap, averageDurationMap);
    }

    static class ChainResultStateImpl
    implements ChainStateResult {
        private final ChainResultsSummary chainResultsSummary;
        private final Map<PlanResultKey, BuildContext> buildContextMap;
        private final Map<PlanResultKey, Long> averageDurationMap;
        private final ErrorCollection errorCollection;

        ChainResultStateImpl(ChainResultsSummary chainResultsSummary, Map<PlanResultKey, BuildContext> buildContextMap, Map<PlanResultKey, Long> averageDurationMap, ErrorCollection errorCollection) {
            this.chainResultsSummary = chainResultsSummary;
            this.buildContextMap = buildContextMap;
            this.averageDurationMap = averageDurationMap;
            this.errorCollection = errorCollection;
        }

        @Nullable
        public ChainResultsSummary getChainResultsSummary() {
            return this.chainResultsSummary;
        }

        @Nullable
        public BuildContext getBuildContext(@NotNull PlanResultKey planResultKey) {
            return this.buildContextMap.get(planResultKey);
        }

        @Nullable
        public Long getAverageDuration(@NotNull PlanResultKey planResultKey) {
            return this.averageDurationMap.get(planResultKey);
        }

        @NotNull
        public ErrorCollection getErrors() {
            return this.errorCollection;
        }
    }
}

