/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.chains.ChainFilteredTestResults;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainStageResultImpl;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultDescriptor;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainResultsSummaryImpl
extends AbstractResultsSummary
implements ChainResultsSummary {
    private static final Logger log = Logger.getLogger(ChainResultsSummaryImpl.class);
    private List<ChainStageResult> stageResults;
    private transient ChainFilteredTestResults chainTestResultsHelper;
    private boolean continuable = false;
    private MergeResultSummary mergeResult;
    private Integer fixedInResult;
    private final ResettableLazyReference<Optional<ImmutableChain>> immutableChainLazyReference = new ResettableLazyReference<Optional<ImmutableChain>>(){

        @NotNull
        protected Optional<ImmutableChain> create() {
            ImmutableChain plan = (ImmutableChain)((CachedPlanManager)cachedPlanManagerRef.get()).getPlanByKey(ChainResultsSummaryImpl.this.getPlanKey(), ImmutableChain.class);
            return Optional.ofNullable(plan);
        }
    };

    public ChainResultsSummaryImpl() {
        this.stageResults = new LinkedList<ChainStageResult>();
    }

    @NotNull
    public ImmutableChain getImmutablePlan() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find Plan for " + this.getPlanResultKey()));
    }

    @NotNull
    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find chain for " + this.getPlanResultKey()));
    }

    @NotNull
    public Optional<ImmutableChain> getPlanIfExists() {
        return (Optional)this.immutableChainLazyReference.get();
    }

    @NotNull
    public String getFullPlanName() {
        return this.getImmutablePlan().getName();
    }

    @Override
    @NotNull
    public String getPlanName() {
        return this.getImmutablePlan().getBuildName();
    }

    @NotNull
    public ChainStageResult createStageResult(@NotNull ImmutableChainStage chainStage) {
        ChainStageResultImpl result = new ChainStageResultImpl(chainStage.getName(), chainStage.getDescription(), chainStage.isManual(), chainStage.isFinal(), this);
        this.stageResults.add(result);
        return result;
    }

    @NotNull
    public List<ChainStageResult> getStageResults() {
        return this.stageResults;
    }

    public void setStageResults(@NotNull List<ChainStageResult> stageResults) {
        this.stageResults = stageResults;
    }

    public boolean addStageResult(@NotNull ChainStageResult chainStageResult) {
        chainStageResult.setChainResult((ChainResultsSummary)this);
        return this.stageResults.add(chainStageResult);
    }

    public boolean removeStageResult(@NotNull ChainStageResult chainStageResult) {
        return this.stageResults.remove(chainStageResult);
    }

    @NotNull
    public List<BuildResultsSummary> getFailedJobResults() {
        ArrayList<BuildResultsSummary> failedResults = new ArrayList<BuildResultsSummary>();
        for (ChainStageResult stageResult : this.stageResults) {
            failedResults.addAll(stageResult.getFailedBuildResults());
        }
        return failedResults;
    }

    public int getTotalJobCount() {
        int resultCount = 0;
        for (ChainStageResult stageResult : this.stageResults) {
            resultCount += stageResult.getBuildResults().size();
        }
        return resultCount;
    }

    @Nullable
    public FilteredTestResults<TestClassResultDescriptor> getTestResults() {
        if (this.chainTestResultsHelper == null) {
            this.chainTestResultsHelper = ChainFilteredTestResults.newInstance(null, null, this, 0, 0);
        }
        return this.chainTestResultsHelper;
    }

    @NotNull
    public List<ResultsSummary> getOrderedJobResultSummaries() {
        ArrayList<ResultsSummary> jobResults = new ArrayList<ResultsSummary>();
        for (ChainStageResult chainStageResult : this.stageResults) {
            jobResults.addAll(chainStageResult.getSortedBuildResults());
        }
        return jobResults;
    }

    public boolean isContinuable() {
        return this.continuable;
    }

    public void setContinuable(boolean continuable) {
        this.continuable = continuable;
    }

    public boolean isRestartable() {
        return this.isFailed() || this.isNotBuilt();
    }

    public boolean isNotRunYet() {
        return false;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    public MergeResultSummary getMergeResult() {
        return this.mergeResult;
    }

    public void setMergeResult(MergeResultSummary mergeResult) {
        this.mergeResult = mergeResult;
    }

    public Integer getFixedInResult() {
        return this.fixedInResult;
    }

    public void setFixedInResult(Integer fixedInBuild) {
        this.fixedInResult = fixedInBuild;
    }
}

