/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityWithOid;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="CHAIN_STAGE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class ChainStageImpl
extends HibernateBambooEntityWithOid
implements ChainStage {
    private static final Logger log = Logger.getLogger(ChainStageImpl.class);
    private String name;
    private String description;
    private boolean manual;
    private boolean finalStage;
    private boolean markedForDeletion;
    private Chain chain;
    private Set<Job> jobs = new HashSet<Job>();

    public ChainStageImpl() {
    }

    @Deprecated
    public ChainStageImpl(@NotNull Chain chain, @NotNull String name, String description, boolean manual) {
        this(chain, name, description, manual, false);
    }

    public ChainStageImpl(@NotNull Chain chain, @NotNull String name, String description, boolean manual, boolean finalStage) {
        this.setName(name);
        this.setDescription(description);
        this.manual = manual;
        this.chain = chain;
        this.finalStage = finalStage;
    }

    @NotNull
    public Optional<Long> getDatabaseId() {
        return Optional.of(this.getId());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = BambooInterners.intern((String)name);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = BambooInterners.intern((String)description);
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    public void setFinal(boolean finalStage) {
        this.finalStage = finalStage;
    }

    @Transient
    public boolean isFinal() {
        return this.finalStage;
    }

    @NotNull
    public Chain getChain() {
        return this.chain;
    }

    public void setChain(@NotNull Chain chain) {
        this.chain = chain;
    }

    @NotNull
    public Set<Job> getJobs() {
        return Sets.filter((Set)this.getAllJobs(), BambooPredicates::isNotDeleted);
    }

    @NotNull
    public Set<Job> getAllJobs() {
        return this.jobs;
    }

    public void setAllJobs(Set<Job> jobs) {
        this.jobs = jobs;
    }

    public boolean addJob(@NotNull Job job) {
        ChainStage oldStage = job.getStage();
        job.setStage((ChainStage)this);
        boolean result = this.getAllJobs().add(job);
        if (!result) {
            job.setStage(oldStage);
        }
        return result;
    }

    public boolean removeJob(@NotNull Job job) {
        boolean result = this.getAllJobs().remove(job);
        if (result) {
            job.setStage(null);
        }
        return result;
    }

    @Nullable
    public ImmutableChainStage getMaster() {
        Chain masterChain = this.chain.getMaster();
        if (masterChain == null) {
            return null;
        }
        for (ImmutableChainStage masterStage : masterChain.getStages()) {
            if (!masterStage.getName().equals(this.name)) continue;
            return masterStage;
        }
        throw new IllegalArgumentException("Stage " + this.name + " of chain " + this.chain.getPlanKey() + " has no master");
    }

    public boolean hasMaster() {
        return this.chain.hasMaster();
    }

    public int hashCode() {
        return new HashCodeBuilder(457, 23).append((Object)this.chain).append((Object)this.name).append((Object)this.description).append(this.manual).append(this.markedForDeletion).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChainStageImpl)) {
            return false;
        }
        ChainStageImpl rhs = (ChainStageImpl)((Object)o);
        return new EqualsBuilder().append(this.getId(), rhs.getId()).append((Object)this.chain, (Object)rhs.chain).append((Object)this.name, (Object)rhs.name).append((Object)this.description, (Object)rhs.description).append(this.manual, rhs.manual).append(this.markedForDeletion, rhs.markedForDeletion).isEquals();
    }
}

