/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryPredicates;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.variable.StageVariableContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="CHAIN_STAGE_RESULT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class ChainStageResultImpl
extends BambooEntityObject
implements ChainStageResult {
    private static final Logger log = Logger.getLogger(ChainStageResultImpl.class);
    private String name;
    private String description;
    private boolean manual;
    private boolean finalStage;
    private long processingDuration;
    private ChainResultsSummary chainResult;
    private Set<BuildResultsSummary> buildResults = new LinkedHashSet<BuildResultsSummary>();
    private List<StageVariableContext> manualVariables;

    @Deprecated
    public ChainStageResultImpl(String name, String description, boolean manual, ChainResultsSummary chainResult) {
        this(name, description, manual, false, chainResult);
    }

    public ChainStageResultImpl(String name, String description, boolean manual, boolean finalStage, ChainResultsSummary chainResult) {
        this();
        this.name = name;
        this.description = description;
        this.manual = manual;
        this.finalStage = finalStage;
        this.chainResult = chainResult;
    }

    public ChainStageResultImpl() {
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    @Transient
    public boolean isFinal() {
        return this.finalStage;
    }

    public void setFinal(boolean finalStage) {
        this.finalStage = finalStage;
    }

    public long getProcessingDuration() {
        return this.processingDuration;
    }

    public void setProcessingDuration(long processingDuration) {
        this.processingDuration = processingDuration;
    }

    @NotNull
    public ChainResultsSummary getChainResult() {
        return this.chainResult;
    }

    public void setChainResult(@NotNull ChainResultsSummary chainResult) {
        this.chainResult = chainResult;
    }

    @NotNull
    public Set<BuildResultsSummary> getBuildResults() {
        return this.buildResults;
    }

    @NotNull
    public List<BuildResultsSummary> getSortedBuildResults() {
        return Comparators.getPlanNameResultOrdering().sortedCopy(this.buildResults);
    }

    @NotNull
    public Collection<BuildResultsSummary> getFailedBuildResults() {
        return this.buildResults.stream().filter(ResultSummaryPredicates::isFailed).collect(Collectors.toList());
    }

    @NotNull
    public Collection<BuildResultsSummary> getSuccessfulBuildResults() {
        return this.buildResults.stream().filter(ResultSummaryPredicates::isSuccessful).collect(Collectors.toList());
    }

    public void setBuildResults(@NotNull Set<BuildResultsSummary> buildResults) {
        this.buildResults = buildResults;
    }

    public boolean addBuildResult(@NotNull BuildResultsSummary buildResult) {
        buildResult.setChainResultsSummary(this.chainResult);
        return this.buildResults.add(buildResult);
    }

    public boolean removeBuildResult(@NotNull BuildResultsSummary buildResult) {
        return this.buildResults.remove(buildResult);
    }

    public boolean isPending() {
        boolean result = true;
        if (!this.buildResults.isEmpty()) {
            for (BuildResultsSummary buildResult : this.buildResults) {
                if (buildResult.isPending()) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean isNotBuilt() {
        return this.buildResults.stream().anyMatch(ResultSummaryPredicates::isNotBuilt);
    }

    public boolean isCompleted() {
        boolean result = true;
        if (!this.buildResults.isEmpty()) {
            for (BuildResultsSummary buildResult : this.buildResults) {
                if (!buildResult.isActive()) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean isFinished() {
        boolean allFinished = true;
        for (BuildResultsSummary buildResult : this.buildResults) {
            Optional plan;
            if (buildResult.isFinished() || buildResult.isMarkedForDeletion() || (plan = buildResult.getPlanIfExists()).map(PlanIdentifier::isSuspendedFromBuilding).orElse(false).booleanValue()) continue;
            allFinished = false;
            if (!plan.map(ImmutablePlan::isMarkedForDeletion).orElse(true).booleanValue()) continue;
            return false;
        }
        return allFinished;
    }

    public boolean isAllJobsExist() {
        boolean allFinished = true;
        for (BuildResultsSummary buildResult : this.buildResults) {
            if (!buildResult.getPlanIfExists().map(ImmutablePlan::isMarkedForDeletion).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllNotSuccessfulJobsExist() {
        for (BuildResultsSummary buildResult : this.buildResults) {
            Optional plan;
            if (buildResult.isFinished() || buildResult.isMarkedForDeletion() || (plan = buildResult.getPlanIfExists()).map(PlanIdentifier::isSuspendedFromBuilding).orElse(false).booleanValue() || !plan.map(ImmutablePlan::isMarkedForDeletion).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSuccessful() {
        return this.buildResults.stream().allMatch(ResultSummaryPredicates::isSuccessful);
    }

    public boolean isFailed() {
        return this.buildResults.stream().anyMatch(ResultSummaryPredicates::isFailed);
    }

    public boolean isRunnable() {
        if (!this.manual) {
            return false;
        }
        if (this.chainResult.isFailed() && !this.finalStage || !this.chainResult.isFinished()) {
            return false;
        }
        List stageResults = this.chainResult.getStageResults();
        for (int i = 0; i < stageResults.size(); ++i) {
            ChainStageResult chainStageResult = (ChainStageResult)stageResults.get(i);
            if (!chainStageResult.isManual()) continue;
            boolean isLastStage = i == stageResults.size() - 1;
            boolean isEmptyStage = chainStageResult.getBuildResults().isEmpty();
            if (chainStageResult.isFinished() && (!isEmptyStage || isLastStage)) continue;
            return chainStageResult.getId() == this.getId() && chainStageResult.isAllJobsExist();
        }
        return false;
    }

    public boolean isRestartable() {
        boolean result = false;
        if (this.chainResult.isFailed() || this.chainResult.isNotBuilt()) {
            for (ChainStageResult chainStageResult : this.chainResult.getStageResults()) {
                if (!chainStageResult.isFailed() && !chainStageResult.isNotBuilt()) continue;
                if (chainStageResult.getId() != this.getId() || !chainStageResult.isAllNotSuccessfulJobsExist()) break;
                return true;
            }
        }
        return result;
    }

    public BuildState getState() {
        if (this.isFinished()) {
            if (this.isSuccessful()) {
                return BuildState.SUCCESS;
            }
            return BuildState.FAILED;
        }
        return BuildState.UNKNOWN;
    }

    public LifeCycleState getLifeCycleState() {
        if (this.isFinished()) {
            return LifeCycleState.FINISHED;
        }
        if (this.isCompleted()) {
            return LifeCycleState.NOT_BUILT;
        }
        if (this.isPending()) {
            return LifeCycleState.PENDING;
        }
        return LifeCycleState.IN_PROGRESS;
    }

    public List<StageVariableContext> getManualVariables() {
        if (this.manualVariables == null) {
            this.manualVariables = new ArrayList<StageVariableContext>();
        }
        return this.manualVariables;
    }

    public void setManualVariables(@NotNull List<StageVariableContext> manualVariables) {
        this.manualVariables = manualVariables;
    }
}

