/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.ChainBuildStateImpl;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.ChainStateFactory;
import com.atlassian.bamboo.chains.ChainStateImpl;
import com.atlassian.bamboo.chains.ChainStateResult;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.chains.StageStateImpl;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class ChainStateFactoryImpl
implements ChainStateFactory {
    private static final Logger log = Logger.getLogger(ChainStateFactoryImpl.class);
    @Inject
    @Lazy
    private ChainResultManager chainResultManager;

    @NotNull
    public ChainState create(@NotNull PlanIdentifier chain, @NotNull BuildContext chainBuildContext, @NotNull ChainStateResult chainResultState) {
        return this.create(chain, null, chainBuildContext, chainResultState);
    }

    @NotNull
    public ChainState create(@NotNull PlanIdentifier chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull BuildContext chainBuildContext, @NotNull ChainStateResult chainResultState) {
        ArrayList<StageState> stageStates = new ArrayList<StageState>();
        ArrayList<ChainStageResult> stageResultsForExecution = new ArrayList<ChainStageResult>();
        LinkedHashMap<PlanResultKey, ChainBuildState> allChainBuildStates = new LinkedHashMap<PlanResultKey, ChainBuildState>();
        ChainResultsSummary chainResultsSummary = chainResultState.getChainResultsSummary();
        if (chainResultsSummary != null) {
            List stageResults = chainResultsSummary.getStageResults();
            int startingStageIndex = 0;
            if (planExecutionConfig != null) {
                StageIdentifier startStage = planExecutionConfig.getStartStage();
                startingStageIndex = startStage != null ? startStage.getIndex() : Integer.MAX_VALUE;
            }
            for (int stagePosition = startingStageIndex; stagePosition < stageResults.size(); ++stagePosition) {
                ChainStageResult chainStageResult = (ChainStageResult)stageResults.get(stagePosition);
                if (planExecutionConfig != null && !planExecutionConfig.isScheduledForExecution(chainStageResult.getName())) break;
                stageResultsForExecution.add(chainStageResult);
                LinkedHashMap<PlanResultKey, ChainBuildState> buildStateMap = new LinkedHashMap<PlanResultKey, ChainBuildState>();
                StageStateImpl stageState = new StageStateImpl(chainStageResult, buildStateMap, stagePosition);
                Set buildResultsForStage = chainStageResult.getBuildResults();
                if (buildResultsForStage.isEmpty()) continue;
                for (BuildResultsSummary buildResultsSummary : buildResultsForStage) {
                    PlanResultKey jobResultKey = buildResultsSummary.getPlanResultKey();
                    BuildContext buildContext = chainResultState.getBuildContext(jobResultKey);
                    Long averageDuration = chainResultState.getAverageDuration(jobResultKey);
                    if (buildContext == null || averageDuration == null) continue;
                    ChainBuildStateImpl buildState = new ChainBuildStateImpl(buildContext, stageState, averageDuration);
                    buildStateMap.put(jobResultKey, buildState);
                    allChainBuildStates.put(jobResultKey, buildState);
                }
                stageStates.add(stageState);
            }
        }
        PlanExecutionConfig.PlanExecutionType planExecutionType = planExecutionConfig != null ? planExecutionConfig.getPlanExecutionType() : null;
        boolean isGoingToStopAtManualStage = planExecutionConfig != null && planExecutionConfig.isGoingToStopAtManualStage();
        boolean continueFromFailed = planExecutionConfig != null && planExecutionConfig.isContinueFromFailed();
        boolean stageToStopIsFinal = planExecutionConfig != null && planExecutionConfig.isStageToStopFinal();
        long averageProgressDurationForStages = this.chainResultManager.getAverageProgressDurationForStages(chain, stageResultsForExecution, 10);
        return new ChainStateImpl(chain, chainBuildContext, allChainBuildStates, stageStates, chainResultsSummary.getQueueTime(), averageProgressDurationForStages, planExecutionConfig);
    }
}

