/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.ExecutionContextImpl;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainStateImpl
implements ChainState {
    private static final Logger log = Logger.getLogger(ChainStateImpl.class);
    private final Map<PlanResultKey, ChainBuildState> buildStates;
    private final List<StageState> stageStates;
    private final String name;
    private final BuildContext buildContext;
    private final Queue<StageState> stageStateQueue;
    private final ExecutionContextImpl executionContext = new ExecutionContextImpl();
    private final long averageDuration;
    private volatile StageState previousStageState;
    private volatile StageState currentStageState;
    private volatile boolean successfulSoFar = true;
    private final boolean isContinuedFromFailed;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private Date startDate;
    private final Date queueTime;
    private final PlanExecutionConfig.PlanExecutionType planExecutionType;
    private final boolean isGoingToStopAtManualStage;
    private final boolean stageToStopIsFinal;
    private final Map<String, VariableDefinitionContext> currentResultVariables = new HashMap<String, VariableDefinitionContext>();
    private MergeResultSummary mergeResult;
    private VcsWorkingCopy mergeWorkingCopy;

    public ChainStateImpl(@NotNull PlanIdentifier chain, @NotNull BuildContext buildContext, @NotNull Map<PlanResultKey, ChainBuildState> buildStates, @NotNull List<StageState> stageStates, @Nullable Date queueTime, long averageDuration, @Nullable PlanExecutionConfig planExecutionConfig) {
        this.name = chain.getName();
        this.buildContext = buildContext;
        this.buildStates = buildStates;
        this.stageStates = stageStates;
        this.stageStateQueue = new LinkedList<StageState>(stageStates);
        this.averageDuration = averageDuration;
        this.queueTime = queueTime;
        this.planExecutionType = planExecutionConfig != null ? planExecutionConfig.getPlanExecutionType() : PlanExecutionConfig.PlanExecutionType.REGULAR;
        this.isGoingToStopAtManualStage = planExecutionConfig != null && planExecutionConfig.isGoingToStopAtManualStage();
        this.stageToStopIsFinal = planExecutionConfig != null && planExecutionConfig.isStageToStopFinal();
        this.isContinuedFromFailed = planExecutionConfig != null && planExecutionConfig.isContinueFromFailed();
        this.successfulSoFar = !this.isContinuedFromFailed;
    }

    @Nullable
    public ChainBuildState getChainBuildState(@NotNull PlanResultKey planResultKey) {
        return this.buildStates.get(planResultKey);
    }

    @NotNull
    public Collection<ChainBuildState> getChainBuildStates() {
        return this.buildStates.values();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.buildContext.getPlanResultKey();
    }

    @NotNull
    public List<StageState> getStages() {
        return this.stageStates;
    }

    @Nullable
    public StageState getCurrentStage() {
        return this.currentStageState;
    }

    public int getCurrentStageNumber() {
        return this.stageStates.size() - this.stageStateQueue.size();
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    @NotNull
    public Date getQueueTime() {
        return this.queueTime;
    }

    @Nullable
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(@NotNull Date startDate) {
        if (this.startDate == null) {
            this.startDate = startDate;
        }
    }

    public long getElapsedTime() {
        return this.startDate != null ? System.currentTimeMillis() - this.startDate.getTime() : 0L;
    }

    public StageState getPreviousStage() {
        return this.previousStageState;
    }

    public StageState getNextStage() {
        return this.stageStateQueue.peek();
    }

    public StageState proceedToNextStage(@NotNull Multimap<String, Artifact> publishedChainArtifacts, boolean lastExecutedStageSuccessful) {
        StageState nextStageState;
        boolean skipEmptyStage;
        boolean skipAfterFailure;
        this.successfulSoFar &= lastExecutedStageSuccessful;
        for (VariableDefinitionContext vdc : this.currentResultVariables.values()) {
            this.buildContext.getVariableContext().addResultVariable(vdc.getKey(), vdc.getValue());
        }
        for (StageState stageState : this.stageStateQueue) {
            stageState.addResultVariablesFromPreviousStages(this.currentResultVariables);
            stageState.setPublishedChainArtifactsInfo(publishedChainArtifacts);
        }
        do {
            nextStageState = this.stageStateQueue.poll();
            this.previousStageState = this.currentStageState;
            if (this.previousStageState != null && !this.previousStageState.isCompleted()) {
                this.previousStageState.setSkipped(true);
            }
            this.currentStageState = nextStageState;
            if (this.currentStageState == null) break;
            skipAfterFailure = !this.successfulSoFar && !this.currentStageState.isFinal();
            skipEmptyStage = this.currentStageState.getBuilds().stream().noneMatch(ChainBuildState::isWaiting);
        } while (skipAfterFailure || skipEmptyStage);
        return nextStageState;
    }

    public boolean isCompleted() {
        if (this.mergeResult != null && this.mergeResult.hasFailed()) {
            return true;
        }
        for (StageState stageState : this.getStages()) {
            if (stageState.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isSuccessful() {
        if (!this.successfulSoFar) {
            return false;
        }
        if (this.mergeResult != null && this.mergeResult.hasFailed()) {
            return false;
        }
        for (StageState stageState : this.getStages()) {
            if (stageState.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public boolean isFailed() {
        if (this.mergeResult != null && this.mergeResult.hasFailed()) {
            return true;
        }
        for (StageState stageState : this.getStages()) {
            if (!stageState.isFailed()) continue;
            return true;
        }
        return this.isContinuedFromFailed && this.isCompleted();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    public void markAsStopping() {
        this.stopRequested.set(true);
        this.stopping.set(true);
    }

    public void finishStopping() {
        this.stopping.set(false);
    }

    @NotNull
    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    @NotNull
    public ExecutionContextImpl getExecutionContext() {
        return this.executionContext;
    }

    public PlanExecutionConfig.PlanExecutionType getPlanExecutionType() {
        return this.planExecutionType;
    }

    public boolean isGoingToStopAtManualStage() {
        return this.isGoingToStopAtManualStage;
    }

    public boolean isContinuable() {
        return this.isGoingToStopAtManualStage && (this.isSuccessful() || this.stageToStopIsFinal);
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.getPlanResultKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChainStateImpl)) {
            return false;
        }
        ChainStateImpl rhs = (ChainStateImpl)o;
        return new EqualsBuilder().append((Object)this.getPlanResultKey(), (Object)rhs.getPlanResultKey()).isEquals();
    }

    public MergeResultSummary getMergeResult() {
        return this.mergeResult;
    }

    public void setMergeResult(@NotNull MergeResultSummary mergeResult) {
        this.mergeResult = mergeResult;
    }

    public void updateVariableContext(@NotNull VariableContext variableContext) {
        this.currentResultVariables.putAll(variableContext.getResultVariables());
    }

    @Nullable
    public VcsWorkingCopy getMergeWorkingCopy() {
        return this.mergeWorkingCopy;
    }

    public void setMergeWorkingCopy(VcsWorkingCopy workingCopy) {
        this.mergeWorkingCopy = workingCopy;
    }
}

