/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.JobExecutionManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BuildContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JobExecutionManagerImpl
implements JobExecutionManager {
    private static final Logger log = Logger.getLogger(JobExecutionManagerImpl.class);
    private final BuildExecutionManager buildExecutionManager;
    private final StopBuildManager stopBuildManager;
    private final ResultsSummaryManager resultsSummaryManager;

    public JobExecutionManagerImpl(BuildExecutionManager buildExecutionManager, StopBuildManager stopBuildManager, ResultsSummaryManager resultsSummaryManager) {
        this.buildExecutionManager = buildExecutionManager;
        this.stopBuildManager = stopBuildManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void requestExecution(@NotNull BuildContext buildContext) {
        this.buildExecutionManager.execute(buildContext);
    }

    public boolean requestStop(@NotNull PlanResultKey planResultKey) {
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        if (resultsSummary != null) {
            LifeCycleState lifeCycleState = resultsSummary.getLifeCycleState();
            if (lifeCycleState == LifeCycleState.PENDING) {
                this.resultsSummaryManager.updateLifeCycleState(resultsSummary, LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
                this.buildExecutionManager.finishBuildWithCleanState(planResultKey, null);
            } else if (lifeCycleState == LifeCycleState.IN_PROGRESS || lifeCycleState == LifeCycleState.QUEUED) {
                this.stopBuildManager.cancelBuild(planResultKey, false);
                return true;
            }
        }
        return false;
    }
}

