/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ExecutionContext;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.StageState;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StageExecutionImpl
implements StageExecution {
    private static final Logger log = Logger.getLogger(StageExecutionImpl.class);
    private final StageState stageState;
    private final ChainExecution chainExecution;
    private final List<BuildExecution> buildExecutions;

    StageExecutionImpl(StageState stageState, ChainExecution chainExecution, List<BuildExecution> buildExecutions) {
        this.stageState = stageState;
        this.chainExecution = chainExecution;
        this.buildExecutions = buildExecutions;
    }

    public int getStageIndex() {
        return this.stageState.getStageIndex();
    }

    @NotNull
    public ChainExecution getChainExecution() {
        return this.chainExecution;
    }

    @NotNull
    public String getName() {
        return this.stageState.getName();
    }

    @Nullable
    public String getDescription() {
        return this.stageState.getDescription();
    }

    public boolean isBuilding() {
        return this.stageState.isBuilding();
    }

    public boolean isCompleted() {
        return this.stageState.isCompleted();
    }

    public boolean isSuccessful() {
        return this.stageState.isSuccessful();
    }

    @NotNull
    public List<BuildExecution> getBuilds() {
        return Collections.unmodifiableList(this.buildExecutions);
    }

    @NotNull
    public ExecutionContext getExecutionContext() {
        return this.stageState.getExecutionContext();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.chainExecution).append((Object)this.stageState).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StageExecutionImpl)) {
            return false;
        }
        StageExecutionImpl rhs = (StageExecutionImpl)o;
        return new EqualsBuilder().append((Object)this.chainExecution, (Object)rhs.chainExecution).append((Object)this.stageState, (Object)rhs.stageState).isEquals();
    }
}

