/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.chains.ChainBuildState;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ExecutionContextImpl;
import com.atlassian.bamboo.chains.StageState;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StageStateImpl
implements StageState {
    private static final Logger log = Logger.getLogger(StageStateImpl.class);
    private final long chainStageResultId;
    private final String name;
    private final String description;
    private final boolean manual;
    private final boolean finalStage;
    private final Map<PlanResultKey, ChainBuildState> buildStates;
    private final ExecutionContextImpl executionContext = new ExecutionContextImpl();
    private final int stagePosition;
    private boolean skipped;

    public StageStateImpl(ChainStageResult chainStageResult, Map<PlanResultKey, ChainBuildState> buildStates, int stagePosition) {
        this.name = chainStageResult.getName();
        this.description = chainStageResult.getDescription();
        this.manual = chainStageResult.isManual();
        this.buildStates = buildStates;
        this.chainStageResultId = chainStageResult.getId();
        this.stagePosition = stagePosition;
        this.finalStage = chainStageResult.isFinal();
    }

    public Long getChainStageResultId() {
        return this.chainStageResultId;
    }

    public int getStageIndex() {
        return this.stagePosition;
    }

    @NotNull
    public Collection<ChainBuildState> getBuilds() {
        return Collections.unmodifiableCollection(this.buildStates.values());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isFinal() {
        return this.finalStage;
    }

    @Nullable
    public ChainBuildState get(@NotNull PlanResultKey planResultKey) {
        return this.buildStates.get(planResultKey);
    }

    public boolean isWaiting() {
        for (ChainBuildState chainBuildState : this.getBuilds()) {
            if (chainBuildState.isWaiting()) continue;
            return false;
        }
        return true;
    }

    public boolean isBuilding() {
        for (ChainBuildState chainBuildState : this.getBuilds()) {
            if (!chainBuildState.isDispatched()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccessful() {
        if (!this.isCompleted()) {
            return false;
        }
        if (this.skipped) {
            return false;
        }
        for (ChainBuildState chainBuildState : this.getBuilds()) {
            if (!chainBuildState.isFinalized() || chainBuildState.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public boolean isFailed() {
        if (!this.isCompleted()) {
            return false;
        }
        if (this.skipped) {
            return false;
        }
        for (ChainBuildState chainBuildState : this.getBuilds()) {
            if (!chainBuildState.isFinalized() || !chainBuildState.isFailed()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        if (this.skipped) {
            return true;
        }
        for (ChainBuildState chainBuildState : this.getBuilds()) {
            if (chainBuildState.isFinalized()) continue;
            return false;
        }
        return true;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    @NotNull
    public ExecutionContextImpl getExecutionContext() {
        return this.executionContext;
    }

    public void addResultVariablesFromPreviousStages(@NotNull Map<String, VariableDefinitionContext> resultVariables) {
        for (ChainBuildState buildState : this.getBuilds()) {
            buildState.addResultVariablesFromPreviousStages(resultVariables);
        }
    }

    public void setPublishedChainArtifactsInfo(@NotNull Multimap<String, Artifact> publishedChainArtifacts) {
        for (ChainBuildState buildState : this.getBuilds()) {
            buildState.setPublishedChainArtifactsInfo(publishedChainArtifacts);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append(this.chainStageResultId).append((Object)this.name).append((Object)this.description).append(this.manual).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StageStateImpl)) {
            return false;
        }
        StageStateImpl rhs = (StageStateImpl)o;
        return new EqualsBuilder().append(this.chainStageResultId, rhs.chainStageResultId).append((Object)this.name, (Object)rhs.name).append((Object)this.description, (Object)rhs.description).append(this.manual, rhs.manual).isEquals();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stagePosition", this.stagePosition).add("name", (Object)this.name).add("manual", this.manual).add("buildStates", this.buildStates).toString();
    }
}

