/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.branches;

import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchStatusLinkInfo {
    private static final BranchStatusLinkInfo NOT_SHOWN = new BranchStatusLinkInfo(false, -1L, null, null, null);
    private final boolean showLink;
    private final long repositoryId;
    private final String repositoryName;
    private final String branchName;
    private final String navigationSource;

    public static BranchStatusLinkInfo forBranch(long repositoryId, @NotNull String repositoryName, @NotNull String branchName, @Nullable String navigationSource) {
        return new BranchStatusLinkInfo(true, repositoryId, repositoryName, branchName, navigationSource);
    }

    public static BranchStatusLinkInfo forRepository(@NotNull VcsRepositoryData vcsRepositoryData, @Nullable String navigationSource) {
        return new BranchStatusLinkInfo(true, vcsRepositoryData.getRootVcsRepositoryId(), vcsRepositoryData.getName(), vcsRepositoryData.getBranch().getVcsBranch().getName(), navigationSource);
    }

    public static BranchStatusLinkInfo notShown() {
        return NOT_SHOWN;
    }

    private BranchStatusLinkInfo(boolean showLink, long repositoryId, String repositoryName, String branchName, String navigationSource) {
        this.showLink = showLink;
        this.repositoryId = repositoryId;
        this.repositoryName = repositoryName;
        this.branchName = branchName;
        this.navigationSource = navigationSource;
    }

    public String getPath() {
        Preconditions.checkState((boolean)this.showLink, (Object)"Can't generate path to branch status page if link should not be shown");
        String path = Joiner.on((char)'/').join((Object)this.repositoryId, (Object)BranchStatusLinkInfo.encodePath(this.repositoryName), new Object[]{BranchStatusLinkInfo.encodePath(this.branchName)});
        if (this.navigationSource != null) {
            path = path + "?source=" + this.navigationSource;
        }
        return path;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    @VisibleForTesting
    static String encodePath(@NotNull String path) {
        return EscapeChars.forUrl((String)path).replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%21", "!").replace("%5C", "%255C").replace("%2F", "%252F");
    }
}

