/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.branches;

import com.atlassian.bamboo.chains.branches.BranchStatusLinkInfo;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchStatusServiceImpl
implements BranchStatusService {
    private final CachedPlanManager cachedPlanManager;

    @Inject
    public BranchStatusServiceImpl(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    @Override
    @NotNull
    public BranchStatusLinkInfo getBranchStatusLinkInfo(@NotNull ImmutablePlan plan, @Nullable String navigationSource) {
        if (!this.shouldDisplayBranchStatusLink(plan) || !(plan instanceof ImmutableChain)) {
            return BranchStatusLinkInfo.notShown();
        }
        PlanRepositoryDefinition planRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition(plan);
        if (planRepositoryDefinition == null || planRepositoryDefinition.getBranch() == null) {
            return BranchStatusLinkInfo.notShown();
        }
        return BranchStatusLinkInfo.forBranch(planRepositoryDefinition.getRootVcsRepositoryId(), planRepositoryDefinition.getName(), planRepositoryDefinition.getBranch().getVcsBranch().getName(), navigationSource);
    }

    @Override
    public boolean shouldDisplayBranchStatusLink(@NotNull ImmutablePlan plan) {
        ImmutableChain chain;
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        ImmutableChain immutableChain = chain = job != null ? job.getParent() : (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
        if (chain != null && this.hasPlanBranches(chain)) {
            PlanRepositoryDefinition defaultRepository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
            return defaultRepository != null && defaultRepository.isRootVcsLinked();
        }
        return false;
    }

    private boolean hasPlanBranches(@NotNull ImmutableChain chain) {
        return chain.getPlanType() == PlanType.CHAIN_BRANCH || this.cachedPlanManager.getBranchesOfChain(chain.getPlanKey()).findAny().isPresent();
    }
}

