/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.branches;

import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.util.BambooStringUtils;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="MERGE_RESULT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class MergeResultSummaryImpl
extends BambooEntityObject
implements MergeResultSummary {
    private static final Logger log = Logger.getLogger(MergeResultSummaryImpl.class);
    private static final String UNITIALISED = "UNKNOWN";
    private static int FAILURE_REASON_MAX_LENGTH_BYTES = 4000;
    private String failureReason;
    private String integrationBranchVcsKey = "UNKNOWN";
    private String mergeResultVcsKey;
    private long integrationRepositoryId;
    private String integrationRepositoryBranchName;
    protected String branchTargetVcsKey;
    protected String branchName;
    private transient boolean emptyMerge;
    private MergeResultState mergeState = MergeResultState.NOT_ATTEMPTED;
    private MergeResultState pushState = MergeResultState.NOT_ATTEMPTED;
    private BranchIntegrationStrategy integrationStrategy;

    public MergeResultSummaryImpl() {
    }

    public MergeResultSummaryImpl(BranchIntegrationStrategy integrationStrategy) {
        this.integrationStrategy = integrationStrategy;
    }

    public MergeResultSummaryImpl(@NotNull MergeResultSummary other) {
        this.pushState = other.getPushState();
        this.mergeState = other.getMergeState();
        this.setFailureReason(other.getFailureReason());
        this.integrationBranchVcsKey = other.getIntegrationBranchVcsKey();
        this.mergeResultVcsKey = other.getMergeResultVcsKey();
        this.integrationRepositoryId = other.getIntegrationRepositoryId();
        this.branchTargetVcsKey = other.getBranchTargetVcsKey();
        this.integrationStrategy = other.getIntegrationStrategy();
        this.integrationRepositoryBranchName = other.getIntegrationRepositoryBranchName();
        this.branchName = other.getBranchName();
    }

    public long getIntegrationRepositoryId() {
        return this.integrationRepositoryId;
    }

    public void setIntegrationRepositoryId(long integrationRepositoryId) {
        this.integrationRepositoryId = integrationRepositoryId;
    }

    @Nullable
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(@Nullable String failureReason) {
        this.failureReason = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)failureReason, (int)FAILURE_REASON_MAX_LENGTH_BYTES);
    }

    @NotNull
    public String getIntegrationBranchVcsKey() {
        return this.integrationBranchVcsKey;
    }

    public void setIntegrationBranchVcsKey(@NotNull String integrationBranchVcsKey) {
        this.integrationBranchVcsKey = integrationBranchVcsKey;
    }

    @Nullable
    public String getMergeResultVcsKey() {
        return this.mergeResultVcsKey;
    }

    public void setMergeResultVcsKey(@Nullable String pushRevisionKey) {
        this.mergeResultVcsKey = pushRevisionKey;
    }

    public boolean isEmptyMerge() {
        return this.emptyMerge;
    }

    public void setEmptyMerge(boolean emptyMerge) {
        this.emptyMerge = emptyMerge;
    }

    @NotNull
    public MergeResultState getMergeState() {
        return this.mergeState;
    }

    public void setMergeState(@NotNull MergeResultState mergeState) {
        this.mergeState = mergeState;
    }

    @NotNull
    public MergeResultState getPushState() {
        return this.pushState;
    }

    public void setPushState(@NotNull MergeResultState pushState) {
        this.pushState = pushState;
    }

    @Nullable
    public String getBranchTargetVcsKey() {
        return this.branchTargetVcsKey;
    }

    public void setBranchTargetVcsKey(@Nullable String branchTargetVcsKey) {
        this.branchTargetVcsKey = branchTargetVcsKey;
    }

    public BranchIntegrationStrategy getIntegrationStrategy() {
        return this.integrationStrategy;
    }

    public void setIntegrationStrategy(BranchIntegrationStrategy integrationStrategy) {
        this.integrationStrategy = integrationStrategy;
    }

    public String getIntegrationRepositoryBranchName() {
        return this.integrationRepositoryBranchName;
    }

    public void setIntegrationRepositoryBranchName(String integrationRepositoryBranchName) {
        this.integrationRepositoryBranchName = integrationRepositoryBranchName;
    }

    @Nullable
    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(@Nullable String branchName) {
        this.branchName = branchName;
    }

    public boolean hasFailed() {
        return this.pushState == MergeResultState.FAILED || this.mergeState == MergeResultState.FAILED;
    }

    public static void copy(@Nullable MergeResultSummary from, @NotNull MergeResultSummary to) {
        if (from != null) {
            to.setFailureReason(from.getFailureReason());
            to.setIntegrationBranchVcsKey(from.getIntegrationBranchVcsKey());
            to.setMergeResultVcsKey(from.getMergeResultVcsKey());
            to.setIntegrationRepositoryId(from.getIntegrationRepositoryId());
            to.setEmptyMerge(from.isEmptyMerge());
            to.setBranchTargetVcsKey(from.getBranchTargetVcsKey());
            to.setMergeState(from.getMergeState());
            to.setPushState(from.getPushState());
            to.setIntegrationRepositoryBranchName(from.getIntegrationRepositoryBranchName());
            to.setIntegrationStrategy(from.getIntegrationStrategy());
            to.setBranchName(from.getBranchName());
        }
    }

    public String toString() {
        return "MergeResultSummaryImpl{integrationStrategy='" + this.integrationStrategy.name() + "', mergeState='" + this.mergeState.name() + "', pushState='" + this.pushState.name() + "', failureReason='" + this.failureReason + '\'' + ", integrationBranchVcsKey='" + this.integrationBranchVcsKey + '\'' + ", mergeResultVcsKey='" + this.mergeResultVcsKey + '\'' + ", integrationRepositoryId=" + this.integrationRepositoryId + ", integrationRepositoryBranchName='" + this.integrationRepositoryBranchName + "', branchTargetVcsKey='" + this.branchTargetVcsKey + "', branchName='" + this.branchName + "'" + '}';
    }
}

