/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.cache;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutablePlanManager;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableChainStageImpl
implements ImmutableChainStage {
    private static final Logger log = Logger.getLogger(ImmutableChainStageImpl.class);
    private Long id;
    private String name;
    private String description;
    private boolean manual;
    private boolean finalStage;
    private boolean markedForDeletion;
    private ImmutableChain chain;
    @NotNull
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private BambooEntityOid oid;
    private Set<ImmutableJob> jobs;
    private ImmutableChainStage master;

    public ImmutableChainStageImpl(@NotNull ImmutableChain chain, @NotNull ChainStage mutableStage, @NotNull ImmutablePlanManager immutablePlanManager, @NotNull ImmutablePlanCacheService immutablePlanCacheService) {
        this.name = mutableStage.getName();
        this.description = mutableStage.getDescription();
        this.manual = mutableStage.isManual();
        this.finalStage = mutableStage.isFinal();
        this.markedForDeletion = mutableStage.isMarkedForDeletion();
        this.oid = mutableStage.getOid();
        this.chain = chain;
        this.immutablePlanCacheService = immutablePlanCacheService;
        log.trace((Object)"CACHE_TRACE creating immutable jobs");
        ImmutableSet.Builder jobsBuilder = ImmutableSet.builder();
        for (Job job : mutableStage.getJobs()) {
            jobsBuilder.add((Object)immutablePlanManager.createImmutableJob(chain, (ImmutableChainStage)this, job));
        }
        this.jobs = jobsBuilder.build();
        log.trace((Object)"CACHE_TRACE /creating immutable jobs");
        ImmutableChain masterChain = PlanHelper.getMasterPlan(chain);
        if (masterChain != chain) {
            this.id = null;
            this.master = masterChain.getAllStages().stream().filter(masterStage -> {
                if (masterStage.getId() == mutableStage.getId()) {
                    return true;
                }
                return mutableStage.getMaster() != null && masterStage.getId() == mutableStage.getMaster().getId();
            }).findAny().orElseThrow(() -> new IllegalStateException("Unable to find master stage for " + mutableStage));
        } else {
            this.id = mutableStage.getId();
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isFinal() {
        return this.finalStage;
    }

    @NotNull
    public ImmutableChain getChain() {
        return this.chain;
    }

    @NotNull
    public Set<ImmutableJob> getJobs() {
        return this.immutablePlanCacheService.filterOutDeletedIfNeeded(this.jobs);
    }

    public ImmutableChainStage getMaster() {
        return this.master;
    }

    public boolean hasMaster() {
        return this.getMaster() != null;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public long getId() {
        if (this.id == null) {
            throw new IllegalStateException("This stage is not a DB object");
        }
        return this.id;
    }

    @NotNull
    public Optional<Long> getDatabaseId() {
        return Optional.ofNullable(this.id);
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }
}

