/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.plugins;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PostJobAction;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.MutableTestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TestResultSummaryMergeAction
implements PostJobAction {
    private static final Logger log = Logger.getLogger(TestResultSummaryMergeAction.class);
    private final Function<PlanResultKey, ManagedLock> testSummaryLock = ManagedLocks.weakManagedLockFactory();
    private ResultsSummaryManager resultsSummaryManager;

    public void execute(@NotNull StageExecution stageExecution, @NotNull ImmutableJob job, @NotNull BuildResultsSummary buildResultsSummary) {
        PlanResultKey planResultKey = stageExecution.getChainExecution().getPlanResultKey();
        this.testSummaryLock.apply(planResultKey).withLock(() -> {
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class);
            if (chainResultsSummary != null) {
                TestResultsSummary buildTestResultsSummary = buildResultsSummary.getTestResultsSummary();
                MutableTestResultsSummary chainTestResultsSummary = (MutableTestResultsSummary)Narrow.to((Object)chainResultsSummary.getTestResultsSummary(), MutableTestResultsSummary.class);
                if (chainTestResultsSummary == null) throw new IllegalStateException("For some reason the TestResultsSummary for '" + planResultKey + "' was not MutableTestResultsSummary.");
                chainTestResultsSummary.addCountsFrom(buildTestResultsSummary);
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
                return;
            } else {
                log.debug((Object)("Could not find result of Chain '" + planResultKey + "'. Could not merge the Jobs '" + buildResultsSummary.getPlanResultKey() + "' test summary with those of the Chain."));
            }
        });
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

