/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.collections;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleActionParametersMap
extends ForwardingMap<String, Object>
implements ActionParametersMap {
    private static final Logger log = Logger.getLogger(SimpleActionParametersMap.class);
    private final Map<String, Object> parameters = new TreeMap<String, Object>();
    private volatile HttpParameters actionParameters;

    public SimpleActionParametersMap(HttpParameters parameters) {
        this.actionParameters = parameters;
        for (Map.Entry entry : parameters.entrySet()) {
            this.parameters.put((String)entry.getKey(), ((Parameter)entry.getValue()).getObject());
        }
    }

    @Deprecated
    public SimpleActionParametersMap(Map<String, ?> parameters) {
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Parameter parameter = (Parameter)Narrow.downTo(value, Parameter.class);
            if (parameter != null) {
                this.parameters.put(entry.getKey(), parameter.getObject());
                continue;
            }
            this.parameters.put(entry.getKey(), value);
        }
        this.actionParameters = null;
    }

    @NotNull
    public String getString(@Nullable String key, @NotNull String defaultString) {
        return StringUtils.defaultString((String)this.getString(key), (String)defaultString);
    }

    @Nullable
    public String getString(@Nullable String key) {
        Object o = this.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            String[] sa = (String[])o;
            return sa.length > 0 ? sa[0] : null;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.isEmpty()) {
                return null;
            }
            Object i = c.iterator().next();
            return i == null ? null : i.toString();
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Nullable
    public String[] getStringArray(@Nullable String key) {
        Object o = this.get(key);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            String[] sa = new String[c.size()];
            int i = 0;
            for (Object co : c) {
                if (co != null) {
                    sa[i++] = co.toString();
                    continue;
                }
                sa[i++] = null;
            }
            return sa;
        }
        if (o != null) {
            return new String[]{o.toString()};
        }
        return null;
    }

    public double getDouble(@Nullable String key, double defaultValue) {
        return NumberUtils.toDouble((String)this.getString(key), (double)defaultValue);
    }

    public int getInt(@Nullable String key, int defaultValue) {
        return NumberUtils.toInt((String)this.getString(key), (int)defaultValue);
    }

    public long getLong(@Nullable String key, long defaultValue) {
        return NumberUtils.toLong((String)this.getString(key), (long)defaultValue);
    }

    public boolean getBoolean(@Nullable String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    @NotNull
    public Map<String, File> getFiles() {
        return Collections.emptyMap();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    protected Map<String, Object> delegate() {
        return this.parameters;
    }

    public Object put(@NotNull String key, @NotNull Object value) {
        if (this.actionParameters != null) {
            log.warn((Object)("Mutation of action parameter map: " + key + " your plugin needs to be fixed"), new Throwable());
            this.actionParameters.appendAll((Map)ImmutableMap.of((Object)key, (Object)new Parameter.Request(key, value)));
        }
        return super.put((Object)key, value);
    }

    public void clear() {
        this.blockOperationOnActionContext();
        super.clear();
    }

    public Object remove(Object object) {
        this.blockOperationOnActionContext();
        return super.remove(object);
    }

    public void putAll(Map<? extends String, ?> map) {
        this.blockOperationOnActionContext();
        super.putAll(map);
    }

    private void blockOperationOnActionContext() {
        if (this.actionParameters != null) {
            throw new UnsupportedOperationException("Direct mutation of ActionContext parameters is not supported. Your plugin needs to be corrected.");
        }
    }

    public void detachFromActionContext() {
        this.actionParameters = null;
    }
}

