/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.command;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.command.ErrorStreamToLogsPumper;
import com.atlassian.bamboo.command.StreamToLogsPumper;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class CommandExecuteStreamHandler
implements ExecuteStreamHandler {
    private static final Logger log = Logger.getLogger(CommandExecuteStreamHandler.class);
    private static final boolean FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = SystemProperty.FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS.getValue(true);
    protected Thread outputThread;
    protected Thread errorThread;
    protected final BuildLogger buildLogger;
    protected final String planKey;

    public CommandExecuteStreamHandler(BuildLogger buildLogger, String planKey) {
        this.buildLogger = buildLogger;
        this.planKey = planKey;
    }

    public void setProcessInputStream(OutputStream outputStream) throws IOException {
    }

    public void setProcessErrorStream(InputStream inputStream) throws IOException {
        Thread result = new Thread((Runnable)new ErrorStreamToLogsPumper(inputStream, this.buildLogger, this.planKey), this.planKey + ":Error Pump");
        result.setDaemon(true);
        this.errorThread = result;
    }

    public void setProcessOutputStream(InputStream inputStream) throws IOException {
        StreamToLogsPumper pumper = new StreamToLogsPumper(inputStream, this.buildLogger, this.planKey, FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS);
        Thread result = new Thread((Runnable)pumper, this.planKey + ":Output Pump");
        result.setDaemon(true);
        this.outputThread = result;
    }

    public void start() throws IOException {
        this.outputThread.start();
        this.errorThread.start();
    }

    public void stop() {
        try {
            this.outputThread.join();
        }
        catch (InterruptedException e) {
            log.info((Object)"Standard output interuppted", (Throwable)e);
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException e) {
            log.info((Object)"Standard error interuppted", (Throwable)e);
        }
    }
}

