/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.command;

import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.command.StreamToListPumper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.jetbrains.annotations.Nullable;

public class SimpleExecuteStreamHandler
implements ExecuteStreamHandler {
    private static final Logger log = Logger.getLogger(SimpleExecuteStreamHandler.class);
    private final List<String> outputLog;
    private final List<String> errorLog;
    private Thread outputThread;
    private Thread errorThread;
    private final SystemAuthorityThreadFactory threadFactory;

    public SimpleExecuteStreamHandler(@Nullable List<String> outputLog, @Nullable List<String> errorLog, String nameSuffix) {
        this.threadFactory = new SystemAuthorityThreadFactory("OutputHandler::" + nameSuffix);
        this.outputLog = outputLog;
        this.errorLog = errorLog;
    }

    public void setProcessInputStream(OutputStream outputStream) throws IOException {
    }

    public void setProcessErrorStream(InputStream inputStream) throws IOException {
        if (this.errorLog != null) {
            this.errorThread = this.threadFactory.newThread((Runnable)new StreamToListPumper(inputStream, this.errorLog, null, null));
            this.errorThread.setDaemon(true);
        }
    }

    public void setProcessOutputStream(InputStream inputStream) throws IOException {
        if (this.outputLog != null) {
            this.outputThread = this.threadFactory.newThread((Runnable)new StreamToListPumper(inputStream, this.outputLog, null, null));
            this.outputThread.setDaemon(true);
        }
    }

    public void start() throws IOException {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
    }

    public void stop() {
        if (this.outputThread != null) {
            try {
                this.outputThread.join();
            }
            catch (InterruptedException e) {
                log.info((Object)"Standard output interrupted", (Throwable)e);
            }
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.join();
            }
            catch (InterruptedException e) {
                log.info((Object)"Standard error interrupted", (Throwable)e);
            }
        }
    }
}

