/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.command;

import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.apache.log4j.Logger;

public class StreamToListPumper
implements Runnable {
    private static final Logger log = Logger.getLogger(StreamToListPumper.class);
    private InputStream myInputStream;
    private Collection<String> myOutputList;
    protected final BuildLogger buildLogger;
    protected final String planKey;

    public StreamToListPumper(InputStream inputStream, Collection<String> outputList, BuildLogger buildLogger, String planKey) {
        this.myInputStream = inputStream;
        this.myOutputList = outputList;
        this.buildLogger = buildLogger;
        this.planKey = planKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.myInputStream));
            this.pump(reader);
        }
        catch (Exception e) {
            log.info((Object)"Failed to pump input stream", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            StreamToListPumper streamToListPumper = this;
            synchronized (streamToListPumper) {
                this.notify();
            }
        }
    }

    protected void pump(BufferedReader reader) throws IOException {
        try {
            String line;
            while (!Thread.currentThread().isInterrupted() && (line = reader.readLine()) != null) {
                this.log(line);
                this.myOutputList.add(line);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void log(String line) {
        if (this.buildLogger != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.planKey + "] " + line));
            }
            this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry(line));
        }
    }
}

