/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.command;

import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StreamToLogsPumper
implements Runnable {
    private static final Logger log = Logger.getLogger(StreamToLogsPumper.class);
    private InputStream inputStream;
    protected final BuildLogger buildLogger;
    protected final String planKey;
    private final Pattern MAVEN_DOWNLOAD_PATTERNS = Pattern.compile("^[0-9]*/[0-9]*K$");
    private final Pattern MAVEN_UPLOAD_PATTERNS = Pattern.compile("^[0-9]*/\\?$");
    private final boolean filterDownloadStatusMessages;

    public StreamToLogsPumper(InputStream inputStream, BuildLogger buildLogger, String planKey) {
        this(inputStream, buildLogger, planKey, false);
    }

    public StreamToLogsPumper(InputStream inputStream, BuildLogger buildLogger, String planKey, boolean filterDownloadStatusMessages) {
        this.inputStream = inputStream;
        this.buildLogger = buildLogger;
        this.planKey = planKey;
        this.filterDownloadStatusMessages = filterDownloadStatusMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            this.pump(reader);
        }
        catch (Exception e) {
            try {
                log.info((Object)"Failed to pump input stream", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                StreamToLogsPumper streamToLogsPumper = this;
                synchronized (streamToLogsPumper) {
                    this.notify();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            StreamToLogsPumper streamToLogsPumper = this;
            synchronized (streamToLogsPumper) {
                this.notify();
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        StreamToLogsPumper streamToLogsPumper = this;
        synchronized (streamToLogsPumper) {
            this.notify();
        }
    }

    protected void pump(BufferedReader reader) throws IOException {
        try {
            String line;
            while (!Thread.currentThread().isInterrupted() && (line = reader.readLine()) != null) {
                this.log(line);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void log(@NotNull String line) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.planKey + "] " + line));
        }
        if (this.buildLogger != null && (!this.filterDownloadStatusMessages || this.allowLogLines(line))) {
            this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry(line));
        }
    }

    private boolean allowLogLines(@NotNull String line) {
        return !this.MAVEN_DOWNLOAD_PATTERNS.matcher(line).matches() && !this.MAVEN_UPLOAD_PATTERNS.matcher(line).matches();
    }
}

